/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.regional.data.collection.application.controllers;

import gr.cite.regional.data.collection.application.controllers.BaseController;
import gr.cite.regional.data.collection.application.core.EntityDtoMapper;
import gr.cite.regional.data.collection.application.dtos.DomainDto;
import gr.cite.regional.data.collection.application.dtos.Dto;
import gr.cite.regional.data.collection.dataaccess.entities.Domain;
import gr.cite.regional.data.collection.dataaccess.entities.Entity;
import gr.cite.regional.data.collection.dataaccess.exceptions.ServiceException;
import gr.cite.regional.data.collection.dataaccess.services.DomainService;
import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@CrossOrigin
@RequestMapping(value={"/domains"})
public class DomainController
extends BaseController {
    private static final Logger logger = LogManager.getLogger(DomainController.class);
    private String hostname;
    private EntityDtoMapper entityDtoMapper;
    private DomainService domainService;

    @Autowired
    public DomainController(DomainService domainService, String hostname, EntityDtoMapper entityDtoMapper) {
        this.hostname = hostname;
        this.domainService = domainService;
        this.entityDtoMapper = entityDtoMapper;
    }

    @RequestMapping(value={""}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<DomainDto> getDomains(HttpServletRequest request) throws ServiceException {
        String scope = this.getGCubeScope();
        Domain domain = this.domainService.getDomainByLabel(scope);
        return ResponseEntity.ok((Object)this.entityDtoMapper.entityToDto((Entity)domain, DomainDto.class));
    }

    @RequestMapping(value={""}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public ResponseEntity<String> addDomain(@RequestBody DomainDto domainDto, HttpServletRequest request) throws ServiceException {
        Domain domainEntity = (Domain)this.entityDtoMapper.dtoToEntity((Dto)domainDto, Domain.class);
        this.domainService.addDomain(domainEntity);
        return ResponseEntity.created((URI)URI.create(this.hostname + "/" + domainEntity.getId())).build();
    }
}

