package gr.cite.regional.data.collection.application.dtos;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "attributes")
public class AttributesDto {
	@JsonIgnore
	private static final Logger logger = LoggerFactory.getLogger(AttributesDto.class);
	
	@JsonProperty("metadata")
	@XmlElement(name = "metadata")
	private MetadataDto metadata;
	
	public MetadataDto getMetadata() {
		return metadata;
	}
	
	public void setMetadata(MetadataDto metadata) {
		this.metadata = metadata;
	}
	
	public static String toXml(AttributesDto attributesDto) throws JAXBException {
		if (attributesDto == null) return null;
		JAXBContext ctx;
		ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
		
		ctx = JAXBContext.newInstance(AttributesDto.class);
		Marshaller marshaller = ctx.createMarshaller();
		//marshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, true);
		marshaller.marshal(attributesDto, outputStream);
		
		return outputStream.toString();
	}
	
	public static AttributesDto fromXml(String xml) throws JAXBException {
		if (xml == null) return null;
		
		JAXBContext jaxbContext = JAXBContext.newInstance(AttributesDto.class);
		Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
		
		ByteArrayInputStream inputStream = new ByteArrayInputStream(xml.getBytes());
		return (AttributesDto) jaxbUnmarshaller.unmarshal(inputStream);
	}
}
