/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.regional.data.collection.application.controllers;

import gr.cite.regional.data.collection.application.controllers.BaseController;
import gr.cite.regional.data.collection.application.core.EntityDtoMapper;
import gr.cite.regional.data.collection.application.dtos.CdtDto;
import gr.cite.regional.data.collection.application.dtos.DataCollectionDataDto;
import gr.cite.regional.data.collection.application.dtos.DataCollectionDto;
import gr.cite.regional.data.collection.application.dtos.DataSubmissionDto;
import gr.cite.regional.data.collection.application.dtos.Dto;
import gr.cite.regional.data.collection.application.dtos.TabmanDto;
import gr.cite.regional.data.collection.application.tabman.TabmanManager;
import gr.cite.regional.data.collection.dataaccess.dsd.DsdProcessing;
import gr.cite.regional.data.collection.dataaccess.dsd.Field;
import gr.cite.regional.data.collection.dataaccess.entities.Cdt;
import gr.cite.regional.data.collection.dataaccess.entities.DataCollection;
import gr.cite.regional.data.collection.dataaccess.entities.DataSubmission;
import gr.cite.regional.data.collection.dataaccess.entities.Entity;
import gr.cite.regional.data.collection.dataaccess.exceptions.ServiceException;
import gr.cite.regional.data.collection.dataaccess.services.DataCollectionService;
import gr.cite.regional.data.collection.dataaccess.services.DataSubmissionService;
import gr.cite.regional.data.collection.dataaccess.services.UserReferenceService;
import gr.cite.regional.data.collection.dataaccess.types.DataSubmissionStatusType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.NoSuchOperationException;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.NoSuchTabularResourceException;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.NoSuchTaskException;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.TaskStatus;
import org.gcube.data.analysis.tabulardata.service.operation.Task;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@CrossOrigin
@RequestMapping(value={"/dataCollections"})
public class DataCollectionController
extends BaseController {
    private static final Logger logger = LogManager.getLogger(DataCollectionController.class);
    static final String DATA_COLLECTION_ENDPOINT = "dataCollections";
    private static final String DATA_COLLECTION_AS_CSV_FILE_ENDPOINT = "{id}/dataSubmissions/data/file";
    private String hostname;
    private EntityDtoMapper entityDtoMapper;
    private DataCollectionService dataCollectionService;
    private DataSubmissionService dataSubmissionService;
    private DsdProcessing dsdProcessing;
    private UserReferenceService userReferenceService;

    @Autowired
    public DataCollectionController(DataCollectionService dataCollectionService, DataSubmissionService dataSubmissionService, DsdProcessing dsdProcessing, String hostname, EntityDtoMapper entityDtoMapper, UserReferenceService userReferenceService) {
        this.dataCollectionService = dataCollectionService;
        this.dataSubmissionService = dataSubmissionService;
        this.hostname = hostname;
        this.entityDtoMapper = entityDtoMapper;
        this.dsdProcessing = dsdProcessing;
        this.userReferenceService = userReferenceService;
    }

    @RequestMapping(value={""}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<List<DataCollectionDto>> getDataCollections() throws ServiceException {
        logger.debug("Get DataCollections");
        String scope = this.getGCubeScope();
        List dataCollections = this.dataCollectionService.getDataCollectionsByDomain(scope);
        ArrayList dataCollectionDtos = new ArrayList();
        dataCollections.forEach(dc -> {
            DataCollectionDto dcDto = (DataCollectionDto)this.entityDtoMapper.entityToDto((Entity)dc, DataCollectionDto.class);
            try {
                if (this.dataSubmissionService.getDataSubmissionsByDataCollectionId(dc.getId()).size() == 0) {
                    dcDto.setCanChangeDataModel(true);
                } else {
                    dcDto.setCanChangeDataModel(false);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            dataCollectionDtos.add(dcDto);
        });
        return ResponseEntity.ok(dataCollectionDtos);
    }

    @RequestMapping(value={"/{id}/dataSubmissions"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<List<DataSubmissionDto>> getDataSubmissionsOfDataCollection(@PathVariable(value="id") Integer id) throws ServiceException {
        logger.debug("Get DataSubmissions of DataCollection " + id);
        List dataSubmissions = this.dataSubmissionService.getDataSubmissionsByDataCollectionId(id);
        List dataSubmissionDtos = this.entityDtoMapper.entitiesToDtos((Collection)dataSubmissions, DataSubmissionDto.class);
        return ResponseEntity.ok((Object)dataSubmissionDtos);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<DataCollectionDto> getDataCollection(@PathVariable(value="id") Integer id) {
        logger.debug("Get DataCollection " + id);
        DataCollection dataCollection = this.dataCollectionService.getDataCollection(id);
        return dataCollection == null ? ResponseEntity.notFound().build() : ResponseEntity.ok((Object)this.entityDtoMapper.entityToDto((Entity)dataCollection, DataCollectionDto.class));
    }

    @RequestMapping(value={""}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public ResponseEntity<String> addDataCollection(@RequestBody DataCollectionDto dataCollectionDto) throws ServiceException {
        logger.debug("Add DataCollection");
        DataCollection dataCollectionEntity = (DataCollection)this.entityDtoMapper.dtoToEntity((Dto)dataCollectionDto, DataCollection.class);
        dataCollectionEntity = this.dataCollectionService.addDataCollection(dataCollectionEntity);
        return ResponseEntity.ok((Object)("Data Collection " + dataCollectionEntity.getLabel() + " [" + dataCollectionEntity.getId() + "] successfully created"));
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public ResponseEntity<DataCollectionDto> updateDataCollection(@PathVariable(value="id") Integer id, @RequestBody DataCollectionDto dataCollectionDto) throws ServiceException {
        logger.debug("Update DataCollection");
        dataCollectionDto.setId(id);
        long initialDataModelId = this.dataCollectionService.getDataCollection(id).getDataModel().getId().intValue();
        DataCollection dataCollectionEntity = this.dataCollectionService.updateDataCollection((DataCollection)this.entityDtoMapper.dtoToEntity((Dto)dataCollectionDto, DataCollection.class));
        int datasubmissionsSize = this.dataSubmissionService.getDataSubmissionsByDataCollectionId(dataCollectionEntity.getId()).size();
        if (initialDataModelId != (long)dataCollectionEntity.getDataModel().getId().intValue()) {
            if (datasubmissionsSize == 0) {
                this.dataCollectionService.updateCdtOfDataCollection(dataCollectionEntity.getId());
            } else {
                throw new ServiceException("Cannot change data model of a data collection that contains data");
            }
        }
        return ResponseEntity.ok((Object)this.entityDtoMapper.entityToDto((Entity)dataCollectionEntity, DataCollectionDto.class));
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE}, consumes={"application/json"})
    public ResponseEntity deleteDataCollection(@PathVariable(value="id") Integer id) throws ServiceException {
        logger.debug("Delete DataCollection " + id);
        this.dataCollectionService.deleteDataCollection(id);
        return ResponseEntity.noContent().build();
    }

    @RequestMapping(value={"/{id}/tabman/import"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResponseEntity importToTabman(@PathVariable(value="id") Integer id, @RequestBody TabmanDto tabmanDto, HttpServletRequest request) throws ServiceException {
        Task task;
        logger.debug("Importing dataCollection " + id + " to tabman");
        String scope = request.getHeader("scope");
        logger.debug("Scope: " + scope);
        String token = request.getHeader("token");
        String host = request.getHeader("discovered_host");
        byte[] encodedBytes = host.getBytes();
        String decodedHost = new String(Base64.getDecoder().decode(host));
        String fileURL = decodedHost + DATA_COLLECTION_ENDPOINT + "/" + DATA_COLLECTION_AS_CSV_FILE_ENDPOINT;
        List dataSubmissions = this.dataSubmissionService.getDataSubmissionsByDataCollectionId(id);
        if (!dataSubmissions.isEmpty()) {
            if (dataSubmissions.stream().filter(ds -> ds.getStatus().intValue() == DataSubmissionStatusType.VALIDATED.code()).collect(Collectors.toList()).isEmpty()) {
                throw new ServiceException("Export to Tabman aborted, no Data Submission is validated!");
            }
        } else {
            throw new ServiceException("Export to Tabman aborted, threre is no Data Submission under this Data Collection!");
        }
        DataCollection dataCollection = this.dataCollectionService.getDataCollection(id);
        try {
            List fieldNames = this.getFieldNamesOrdered(dataCollection.getDataModel().getDefinition());
            task = TabmanManager.exportDataCollectionToTabman((DataCollection)dataCollection, (List)fieldNames, (String)scope, (String)token, (String)fileURL.replace("{id}", id.toString()), (TabmanDto)tabmanDto);
        }
        catch (InterruptedException | NoSuchOperationException | NoSuchTabularResourceException | NoSuchTaskException e) {
            e.printStackTrace();
            throw new ServiceException("An error occurred while exporting data collection [" + id + "] to tabman: " + e.getCause().getMessage());
        }
        if (!task.getStatus().name().equals(TaskStatus.SUCCEDED.name())) {
            throw new ServiceException("Export to tabman for Data Collection [" + id + "]: " + task.getStatus().name() + ", " + task.getErrorCause().getMessage());
        }
        dataCollection.setTabularResourceId(Long.valueOf(task.getTabularResourceId().getValue()));
        this.dataCollectionService.updateDataCollection(dataCollection);
        return ResponseEntity.ok((Object)("Export to tabman for Datacollection [" + id + "]: " + task.getStatus().name()));
    }

    @RequestMapping(value={"/{id}/dataSubmissions/data"}, method={RequestMethod.GET}, produces={"text/csv"})
    public ResponseEntity<String> getDataCollectionSubmissionsAsCsv(@PathVariable(value="id") Integer id) throws ServiceException {
        List dataSubmissions = this.dataSubmissionService.getDataSubmissionsByDataCollectionId(id, true);
        DataCollection dataCollection = this.dataCollectionService.getDataCollection(id);
        List fieldNames = this.getFieldNamesOrdered(dataCollection.getDataModel().getDefinition());
        ArrayList dataSubmissionsData = new ArrayList();
        dataSubmissions.forEach(dataSubmission -> dataSubmissionsData.addAll(dataSubmission.getData()));
        String csv = null;
        try {
            csv = this.constructDataSubmissionCsv(fieldNames, dataSubmissionsData);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceException("An error occurred while processing csv data");
        }
        return ResponseEntity.ok((Object)csv);
    }

    @RequestMapping(value={"/{id}/dataSubmissions/data"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<DataCollectionDataDto> getDataCollectionSubmissionsJSON(@PathVariable(value="id") Integer id) throws ServiceException, JAXBException {
        List dataSubmissions = this.dataSubmissionService.getDataSubmissionsByDataCollectionId(id, true);
        DataCollection dataCollection = this.dataCollectionService.getDataCollection(id);
        List headers = this.getFieldNamesOrdered(dataCollection.getDataModel().getDefinition());
        ArrayList dataSubmissionsData = new ArrayList();
        dataSubmissions.forEach(dataSubmission -> dataSubmissionsData.addAll(dataSubmission.getData()));
        DataCollectionDataDto dataCollectionData = new DataCollectionDataDto();
        dataCollectionData.setHeaders(headers);
        dataCollectionData.setData(this.entityDtoMapper.entitiesToDtos(dataSubmissionsData, CdtDto.class));
        return ResponseEntity.ok((Object)dataCollectionData);
    }

    @RequestMapping(value={"/{id}/dataSubmissions/data/file"}, method={RequestMethod.GET}, produces={"text/csv"})
    public void getFileOfDataSubmissions(@PathVariable(value="id") Integer id, HttpServletRequest request, HttpServletResponse response) throws ServiceException {
        List dataSubmissions = this.dataSubmissionService.getDataSubmissionsByDataCollectionId(id, true);
        DataCollection dataCollection = this.dataCollectionService.getDataCollection(id);
        List fieldNames = this.getFieldNamesOrdered(dataCollection.getDataModel().getDefinition());
        List dataSubmissionsData = dataSubmissions.stream().filter(dataSubmission -> dataSubmission.getStatus().intValue() == DataSubmissionStatusType.VALIDATED.code()).map(DataSubmission::getData).flatMap(Collection::stream).collect(Collectors.toList());
        String csv = null;
        try {
            csv = this.constructDataSubmissionCsv(fieldNames, dataSubmissionsData);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceException("An error occurred while processing csv data");
        }
        String fileName = dataCollection.getLabel() + dataCollection.getId().toString() + ".csv";
        response.setContentType("text/csv; charset=utf-8");
        response.setContentLength(csv.getBytes().length);
        response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
        try {
            response.getOutputStream().write(csv.getBytes());
            response.flushBuffer();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private List<String> getFieldNamesOrdered(String dsd) {
        return this.dsdProcessing.getDefinitionForExcelAddIn(dsd).getFields().stream().sorted(Comparator.comparingInt(Field::getOrder)).map(Field::getLabel).collect(Collectors.toList());
    }

    private String constructDataSubmissionCsv(List<String> fieldNames, List<Cdt> data) throws Exception {
        String csvHeaders = fieldNames.stream().collect(Collectors.joining(",", "", "\n"));
        String csvData = data.stream().map(cdt -> fieldNames.stream().map(field -> cdt.getData().get(field) == null ? "" : cdt.getData().get(field).toString()).collect(Collectors.joining(","))).collect(Collectors.joining("\n"));
        return csvHeaders + csvData;
    }
}

