/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.repo.auth.saml.messages;

import gr.cite.repo.auth.saml.messages.SamlMessagesHelpers;
import java.util.TimeZone;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.opensaml.common.SAMLVersion;
import org.opensaml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml2.core.AuthnContextComparisonTypeEnumeration;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.NameIDPolicy;
import org.opensaml.saml2.core.RequestedAuthnContext;
import org.opensaml.saml2.core.impl.AuthnContextClassRefBuilder;
import org.opensaml.saml2.core.impl.AuthnRequestBuilder;
import org.opensaml.saml2.core.impl.IssuerBuilder;
import org.opensaml.saml2.core.impl.NameIDPolicyBuilder;
import org.opensaml.saml2.core.impl.RequestedAuthnContextBuilder;
import org.opensaml.xml.ConfigurationException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.MarshallingException;

public class SamlAuthRequest {
    private final String issuer;
    private final String assertionConsumerServiceUrl;

    public SamlAuthRequest(String issuer, String assertionConsumerServiceUrl) {
        this.issuer = issuer;
        this.assertionConsumerServiceUrl = assertionConsumerServiceUrl;
    }

    public String getAuthReq() throws MarshallingException, ConfigurationException {
        String id = "_" + UUID.randomUUID().toString();
        AuthnRequest authRequest = new AuthnRequestBuilder().buildObject();
        authRequest.setID(id);
        authRequest.setVersion(SAMLVersion.VERSION_20);
        authRequest.setIssueInstant(new DateTime().withZone(DateTimeZone.forTimeZone((TimeZone)TimeZone.getDefault())));
        authRequest.setProtocolBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        authRequest.setAssertionConsumerServiceURL(this.assertionConsumerServiceUrl);
        Issuer issuer = new IssuerBuilder().buildObject();
        issuer.setValue(this.issuer);
        authRequest.setIssuer(issuer);
        NameIDPolicy nameIDPolicy = new NameIDPolicyBuilder().buildObject();
        nameIDPolicy.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:transient");
        nameIDPolicy.setAllowCreate(Boolean.valueOf(true));
        authRequest.setNameIDPolicy(nameIDPolicy);
        RequestedAuthnContext requestedAuthnContext = new RequestedAuthnContextBuilder().buildObject();
        requestedAuthnContext.setComparison(AuthnContextComparisonTypeEnumeration.EXACT);
        AuthnContextClassRef authnContextClassRef = new AuthnContextClassRefBuilder().buildObject();
        authnContextClassRef.setAuthnContextClassRef("urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport");
        requestedAuthnContext.getAuthnContextClassRefs().add(authnContextClassRef);
        authRequest.setRequestedAuthnContext(requestedAuthnContext);
        String requestMessage = SamlMessagesHelpers.samlXmlObjToString((XMLObject)authRequest);
        requestMessage = SamlMessagesHelpers.base64Encode(requestMessage);
        return requestMessage;
    }
}

