/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.repo.auth.dropwizard.commands;

import gr.cite.repo.auth.app.SecureAppHelpers;
import gr.cite.repo.auth.app.config.SamlSecurityConfiguration;
import io.dropwizard.Application;
import io.dropwizard.cli.EnvironmentCommand;
import io.dropwizard.setup.Environment;
import net.sourceforge.argparse4j.inf.Namespace;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureServerCommand<T extends SamlSecurityConfiguration>
extends EnvironmentCommand<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecureServerCommand.class);
    private final Class<T> configurationClass;
    public static final String SECURE_SERVER_COMMAND = "secureserver";

    public SecureServerCommand(Application<T> application) {
        super(application, SECURE_SERVER_COMMAND, "Runs the Dropwizard application as an HTTP server with SAML security");
        this.configurationClass = application.getConfigurationClass();
    }

    protected Class<T> getConfigurationClass() {
        return this.configurationClass;
    }

    protected void run(Environment environment, Namespace namespace, T configuration) throws Exception {
        Server server = configuration.getServerFactory().build(environment);
        SecureAppHelpers secureAppHelper = new SecureAppHelpers(environment);
        secureAppHelper.applySessionManager(((SamlSecurityConfiguration)((Object)configuration)).getSessionManager(), server);
        if (SecureAppHelpers.hasSessionManager(((SamlSecurityConfiguration)((Object)configuration)).getSessionManager())) {
            secureAppHelper.applySecurity(((SamlSecurityConfiguration)((Object)configuration)).getSecurity());
        }
        try {
            server.addLifeCycleListener((LifeCycle.Listener)new LifeCycleListener());
            this.cleanupAsynchronously();
            server.start();
        }
        catch (Exception e) {
            LOGGER.error("Unable to start server, shutting down", (Throwable)e);
            server.stop();
            this.cleanup();
            throw e;
        }
    }

    private class LifeCycleListener
    extends AbstractLifeCycle.AbstractLifeCycleListener {
        private LifeCycleListener() {
        }

        public void lifeCycleStopped(LifeCycle event) {
            SecureServerCommand.this.cleanup();
        }
    }
}

