/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.aginfra.data.analytics.visualization.model.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import gr.uoa.di.aginfra.data.analytics.visualization.model.daos.ConfigurationDAO;
import gr.uoa.di.aginfra.data.analytics.visualization.model.daos.DataDocumentDAO;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.Configuration;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.DataDocument;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.DataType;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.Graph;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.MMNode;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.TreeNode;
import gr.uoa.di.aginfra.data.analytics.visualization.model.helpers.CSVReader;
import gr.uoa.di.aginfra.data.analytics.visualization.model.helpers.MMReader;
import gr.uoa.di.aginfra.data.analytics.visualization.model.services.ConfigurationService;
import gr.uoa.di.aginfra.data.analytics.visualization.model.services.DataDocumentMetadata;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.modelmapper.ModelMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConfigurationServiceImpl
implements ConfigurationService {
    private static final Logger logger = LogManager.getLogger(ConfigurationServiceImpl.class);
    private ConfigurationDAO configurationDAO;
    private DataDocumentDAO dataDocumentDAO;
    private ModelMapper modelMapper;

    @Autowired
    public ConfigurationServiceImpl(ConfigurationDAO configurationDAO, DataDocumentDAO dataDocumentDAO, ModelMapper modelMapper) {
        this.configurationDAO = configurationDAO;
        this.dataDocumentDAO = dataDocumentDAO;
        this.modelMapper = modelMapper;
    }

    @Override
    public Configuration getConfiguration(String id) throws Exception {
        return this.configurationDAO.GetById(id);
    }

    @Override
    public List<Configuration> getConfigurations(String vre) throws Exception {
        return this.configurationDAO.GetConfigurations(vre);
    }

    @Override
    public DataDocument getDataDocument(String id) throws Exception {
        return this.dataDocumentDAO.GetById(id);
    }

    @Override
    public DataDocumentMetadata getDataDocumentMetadata(String id) throws Exception {
        return (DataDocumentMetadata)this.modelMapper.map((Object)this.dataDocumentDAO.GetById(id), DataDocumentMetadata.class);
    }

    @Override
    public String storeConfiguration(Configuration item) throws Exception {
        if (item.getId() == null) {
            item.setCreatedAt(new Date());
        }
        item.setUpdatedAt(new Date());
        if (item.getId() == null) {
            return this.configurationDAO.create(item);
        }
        this.configurationDAO.update(item);
        return item.getId();
    }

    @Override
    public String storeDataDocument(String vre, String name, DataType type, boolean isDataReference, byte[] content) throws Exception {
        logger.info("Storing document with name " + name + " and datatype " + (Object)((Object)type));
        DataDocument dataDocument = new DataDocument();
        dataDocument.setVre(vre);
        dataDocument.setName(name);
        dataDocument.setType(type);
        dataDocument.setDataReference(isDataReference);
        switch (type) {
            case Tree: {
                ConfigurationServiceImpl.loadTree(dataDocument, new String(content, StandardCharsets.UTF_8.name()));
                break;
            }
            case Graph: {
                ConfigurationServiceImpl.loadGraph(dataDocument, new String(content, StandardCharsets.UTF_8.name()));
                break;
            }
            case FreeMind: {
                ConfigurationServiceImpl.loadFreeMind(dataDocument, new String(content, StandardCharsets.UTF_8.name()));
                break;
            }
            case Records: {
                ConfigurationServiceImpl.loadCSV(dataDocument, new String(content, StandardCharsets.UTF_8.name()));
                break;
            }
            case JSON: {
                ConfigurationServiceImpl.loadJSON(dataDocument, new String(content, StandardCharsets.UTF_8.name()));
                break;
            }
            default: {
                dataDocument.setRawBytes(content);
            }
        }
        dataDocument.setCreatedAt(new Date());
        dataDocument.setUpdatedAt(new Date());
        String id = this.dataDocumentDAO.store(dataDocument);
        logger.info("Document stored with id " + id);
        return id;
    }

    @Override
    public void deleteConfiguration(String id) throws Exception {
        this.configurationDAO.delete(id);
    }

    private static void loadTree(DataDocument dataDocument, String content) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        TreeNode tree = (TreeNode)mapper.readValue(content, TreeNode.class);
        dataDocument.setTree(tree);
    }

    private static void loadFreeMind(DataDocument dataDocument, String content) throws Exception {
        MMNode freeMind = new MMReader().parse(content);
        dataDocument.setFreeMind(freeMind);
    }

    private static void loadGraph(DataDocument dataDocument, String content) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        Graph graph = (Graph)mapper.readValue(content, Graph.class);
        dataDocument.setGraph(graph);
    }

    private static void loadJSON(DataDocument dataDocument, String content) throws Exception {
        dataDocument.setJSON(content);
    }

    private static void loadCSV(DataDocument dataDocument, String content) throws Exception {
        String[][] csv = CSVReader.readCSV(content);
        if (csv.length < 2) {
            throw new Exception("No records found in csv file");
        }
        dataDocument.setFields(new ArrayList<String>(Arrays.stream(csv[0]).collect(Collectors.toList())));
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        for (int i = 1; i < csv.length; ++i) {
            HashMap<String, String> item = new HashMap<String, String>();
            for (int j = 0; j < dataDocument.getFields().size(); ++j) {
                String f = dataDocument.getFields().get(j);
                item.put(f, csv[i][j]);
            }
            list.add(item);
        }
        dataDocument.setRecords(list);
    }
}

