/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.generators;

import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.Configuration;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.Visualization;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.data.BarChartData;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.data.DataSet;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.extractors.BarChartDataExtractor;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.filters.DataSetFilterApplier;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.filters.Filter;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.filters.FilterOptionsExtractor;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.generators.RecordsGenerator;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.generators.VisualizationDataGenerator;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.transformation.UnpivotTransformer;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class BarChartDataGenerator
extends RecordsGenerator
implements VisualizationDataGenerator {
    private BarChartDataExtractor barChartDataExtractor;
    private DataSetFilterApplier dataSetFilterApplier;
    private FilterOptionsExtractor filterOptionsExtractor;
    private UnpivotTransformer unpivotTransformer;

    @Autowired
    public BarChartDataGenerator(BarChartDataExtractor barChartDataExtractor, DataSetFilterApplier dataSetFilterApplier, FilterOptionsExtractor filterOptionsExtractor, UnpivotTransformer unpivotTransformer) {
        this.barChartDataExtractor = barChartDataExtractor;
        this.dataSetFilterApplier = dataSetFilterApplier;
        this.filterOptionsExtractor = filterOptionsExtractor;
        this.unpivotTransformer = unpivotTransformer;
    }

    @Override
    public void generateData(Visualization visualization, Configuration configuration, DataSet dataSet, Map<String, String> filters) throws Exception {
        if (!this.hasNonFilledInRequiredFilter(visualization, filters)) {
            dataSet = this.unpivotTransformer.unPivot(dataSet, configuration.getTransformations());
            this.dataSetFilterApplier.applyFilters(dataSet, filters);
            BarChartData barChartData = this.barChartDataExtractor.extract(dataSet, configuration);
            visualization.setBarChartData(barChartData);
        }
        if (visualization.getFilters() != null) {
            for (Filter filter : visualization.getFilters()) {
                filter.setOptions(this.filterOptionsExtractor.extract(dataSet, filter.getField()));
            }
        }
    }
}

