/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.generators;

import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.Configuration;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.Visualization;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.data.DataSet;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.data.TimeSeries;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.extractors.TimeSeriesExtractor;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.filters.DataSetFilterApplier;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.filters.Filter;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.filters.FilterOptionsExtractor;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.generators.RecordsGenerator;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.generators.VisualizationDataGenerator;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.transformation.UnpivotTransformer;
import java.util.Collection;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class TimeSeriesDataGenerator
extends RecordsGenerator
implements VisualizationDataGenerator {
    private TimeSeriesExtractor timeSeriesExtractor;
    private DataSetFilterApplier dataSetFilterApplier;
    private FilterOptionsExtractor filterOptionsExtractor;
    private UnpivotTransformer unpivotTransformer;

    @Autowired
    public TimeSeriesDataGenerator(TimeSeriesExtractor timeSeriesExtractor, DataSetFilterApplier dataSetFilterApplier, FilterOptionsExtractor filterOptionsExtractor, UnpivotTransformer unpivotTransformer) {
        this.timeSeriesExtractor = timeSeriesExtractor;
        this.dataSetFilterApplier = dataSetFilterApplier;
        this.filterOptionsExtractor = filterOptionsExtractor;
        this.unpivotTransformer = unpivotTransformer;
    }

    @Override
    public void generateData(Visualization visualization, Configuration configuration, DataSet dataSet, Map<String, String> filters) throws Exception {
        if (!this.hasNonFilledInRequiredFilter(visualization, filters)) {
            dataSet = this.unpivotTransformer.unPivot(dataSet, configuration.getTransformations());
            this.dataSetFilterApplier.applyFilters(dataSet, filters);
            Collection<TimeSeries> timeSeries = this.timeSeriesExtractor.extract(dataSet, configuration);
            visualization.setTimeSeries(timeSeries);
        }
        if (visualization.getFilters() != null) {
            for (Filter filter : visualization.getFilters()) {
                filter.setOptions(this.filterOptionsExtractor.extract(dataSet, filter.getField()));
            }
        }
    }
}

