/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.aginfra.data.analytics.visualization.model.data;

import gr.uoa.di.aginfra.data.analytics.visualization.model.data.DataSetExtractor;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.DataDocument;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.DataSource;
import gr.uoa.di.aginfra.data.analytics.visualization.model.repositories.DataDocumentRepository;
import gr.uoa.di.aginfra.data.analytics.visualization.model.services.VisualizationDataType;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.data.DataSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

public class MongoDBExtractor
implements DataSetExtractor {
    private DataDocumentRepository dataDocumentDAO;

    @Autowired
    public MongoDBExtractor(DataDocumentRepository dataDocumentDAO) {
        this.dataDocumentDAO = dataDocumentDAO;
    }

    @Override
    public DataSet extract(DataSource dataSource, VisualizationDataType type) throws Exception {
        DataDocument dataDocument = this.dataDocumentDAO.getById(dataSource.getSource());
        DataSet dataSet = new DataSet();
        dataSet.setDataType(type);
        if (dataDocument.getFields() != null) {
            dataSet.setFields(dataDocument.getFields().stream().map(x -> dataSource.getSource() + "-" + x).collect(Collectors.toList()));
        }
        dataSet.setData(this.extractData(dataDocument));
        dataSet.setFreeMind(dataDocument.getFreeMind());
        dataSet.setGraph(dataDocument.getGraph());
        dataSet.setTree(dataDocument.getTree());
        dataSet.setJSON(dataDocument.getJSON());
        return dataSet;
    }

    private List<List<String>> extractData(DataDocument dataDocument) {
        if (dataDocument.getFields() == null || dataDocument.getFields().size() == 0) {
            return null;
        }
        ArrayList<List<String>> data = new ArrayList<List<String>>();
        Iterator<Map<String, String>> iterator = dataDocument.getRecords().iterator();
        while (iterator.hasNext()) {
            Map<String, String> item;
            Map<String, String> map = item = iterator.next();
            ArrayList<String> row = new ArrayList<String>();
            for (String field : dataDocument.getFields()) {
                String value = map.get(field);
                row.add(value != null ? value.toString() : "");
            }
            data.add(row);
        }
        return data;
    }
}

