/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.netgraph;

import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.netgraph.HasDateNode;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.netgraph.HasWeight;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.netgraph.Node;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.netgraph.SubGraphEntity;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class Edge
extends SubGraphEntity {
    private String edgeId;
    private String source;
    private String target;
    private Map<String, String> properties;
    private Set<HasWeight> transfers;

    public Edge(String id, Node source, Node target, Map<String, String> attributes, String graphId, String graphName, String tenantName) {
        this.edgeId = id;
        this.source = source.getNodeId();
        this.target = target.getNodeId();
        this.properties = new HashMap<String, String>();
        Iterator<Map.Entry<String, String>> it = attributes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            if (!entry.getKey().matches("[a-zA-Z]+")) continue;
            this.properties.put(entry.getKey(), entry.getValue());
            it.remove();
        }
        this.transfers = attributes.entrySet().stream().map(dNode -> new HasWeight(this.edgeId, source.getNodeId(), target.getNodeId(), ((HasDateNode)source.getHasDateNodes().stream().filter(n -> n.getTarget().getDate() == Integer.parseInt(((String)dNode.getKey()).replace(".", ""))).findAny().orElse(null)).getTarget(), ((HasDateNode)target.getHasDateNodes().stream().filter(t -> t.getTarget().getDate() == Integer.parseInt(((String)dNode.getKey()).replace(".", ""))).findAny().orElse(null)).getTarget(), (String)dNode.getKey(), Double.parseDouble((String)dNode.getValue()))).collect(Collectors.toSet());
        this.setSubGraphId(graphId);
        this.setSubGraphName(graphName);
        this.setTenantName(tenantName);
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getEdgeId() {
        return this.edgeId;
    }

    public void setEdgeId(String edgeId) {
        this.edgeId = edgeId;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public Set<HasWeight> getTransfers() {
        return this.transfers;
    }

    public void setTransfers(Set<HasWeight> transfers) {
        this.transfers = transfers;
    }
}

