/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.extractors;

import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.Configuration;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.data.DataSet;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.data.DataSetManipulator;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.data.Tuple;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.extractors.TupleDataExtractor;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class TupleDataExtractorImpl
extends DataSetManipulator
implements TupleDataExtractor {
    @Override
    public Collection<Tuple> extract(DataSet dataSet, Configuration configuration) throws Exception {
        String labelField = configuration.getLabelField();
        String valueField = configuration.getValueField();
        String colorField = configuration.getColorField();
        int labelFieldIndex = -1;
        if (labelField == null || (labelFieldIndex = this.getFieldIndex(dataSet, labelField)) == -1) {
            throw new Exception("Invalid data field provided " + labelField);
        }
        int valueFieldIndex = -1;
        if (valueField == null || (valueFieldIndex = this.getFieldIndex(dataSet, valueField)) == -1) {
            throw new Exception("Invalid data field provided " + valueField);
        }
        int colorIndex = -1;
        if (colorField != null) {
            colorIndex = this.getFieldIndex(dataSet, colorField);
        }
        return this.extractData(dataSet, labelFieldIndex, valueFieldIndex, colorIndex);
    }

    private Collection<Tuple> extractData(DataSet dataSet, int labelFieldIndex, int valueFieldIndex, int colorIndex) {
        ArrayList<Tuple> result = new ArrayList<Tuple>();
        for (List<String> row : dataSet.getData()) {
            String label = row.get(labelFieldIndex);
            BigDecimal value = this.parseBigDecimal(row.get(valueFieldIndex));
            String color = null;
            if (colorIndex > -1) {
                color = row.get(colorIndex);
            }
            if (label == null || value == null) continue;
            result.add(new Tuple(label, value, color));
        }
        return result;
    }
}

