/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.aginfra.data.analytics.visualization.model;

import org.modelmapper.ModelMapper;
import org.neo4j.ogm.config.Configuration;
import org.neo4j.ogm.session.SessionFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.data.neo4j.repository.config.EnableNeo4jRepositories;
import org.springframework.data.neo4j.transaction.Neo4jTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@ComponentScan(value={"gr.uoa.di.aginfra.data.analytics.visualization.model"})
@PropertySource(value={"classpath:data-analytics-visualization.properties"})
@EnableNeo4jRepositories(value={"gr.uoa.di.aginfra.data.analytics.visualization.model.repositories.netgraph"})
@EnableTransactionManagement
public class AppConfig {
    @Value(value="${spring.data.neo4j.uri}")
    private String databaseUrl;
    @Value(value="${spring.data.neo4j.username}")
    private String userName;
    @Value(value="${spring.data.neo4j.password}")
    private String password;

    @Bean
    public ModelMapper modelMapper() {
        return new ModelMapper();
    }

    @Bean
    public org.neo4j.ogm.config.Configuration configuration() {
        org.neo4j.ogm.config.Configuration configuration = new Configuration.Builder().uri(this.databaseUrl).credentials(this.userName, this.password).build();
        return configuration;
    }

    @Bean
    public SessionFactory sessionFactory() {
        return new SessionFactory(this.configuration(), new String[]{"gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.netgraph"});
    }

    @Bean
    public Neo4jTransactionManager transactionManager() {
        return new Neo4jTransactionManager(this.sessionFactory());
    }
}

