/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.aginfra.data.analytics.visualization.model.convert;

import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.DataDocument;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class CSVConvertor {
    public static void convert(DataDocument dataSet) {
        List<Map<String, String>> data = dataSet.getRecords();
        ArrayList newData = new ArrayList();
        List rawPosition = dataSet.getFields().stream().filter(s -> !s.equals("rawPosition")).collect(Collectors.toList());
        ArrayList f = new ArrayList(rawPosition);
        rawPosition.add("position");
        rawPosition.add("line");
        for (Map<String, String> row : data) {
            ArrayList<String> newRow = new ArrayList<String>();
            for (String string : f) {
                newRow.add(row.get(string));
            }
            String s2 = row.get("rawPosition");
            System.out.println(s2);
            if (s2.equals("NA")) continue;
            String[] stringArray = s2.split(",");
            String[] position = stringArray[0].split(Pattern.quote("("));
            stringArray[1].split(Pattern.quote(")"));
            String[] line = stringArray[1].split(Pattern.quote(")"));
            if (!CSVConvertor.isNumeric(position[1]) || !CSVConvertor.isNumeric(line[0])) continue;
            newRow.add(position[1]);
            newRow.add(line[0]);
            newData.add(newRow);
        }
        newData.size();
        File tmpFile = null;
        try {
            tmpFile = File.createTempFile("test", ".tmp");
            FileWriter writer = new FileWriter(tmpFile);
            String firstLine = rawPosition.stream().collect(Collectors.joining(","));
            writer.write(firstLine);
            writer.write(System.lineSeparator());
            for (List list : newData) {
                String dataLine = list.stream().collect(Collectors.joining(","));
                writer.write(dataLine);
                writer.write(System.lineSeparator());
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean isNumeric(String strNum) {
        return strNum.matches("-?\\d+(\\.\\d+)?");
    }
}

