/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.aginfra.data.analytics.visualization.model.repositories;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.BasicDBObject;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.Configuration;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.DataSource;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.Filter;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.Join;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.Transformation;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.VisualizationType;
import gr.uoa.di.aginfra.data.analytics.visualization.model.persistence.MongoDataSourceManager;
import gr.uoa.di.aginfra.data.analytics.visualization.model.repositories.ConfigurationRepository;
import gr.uoa.di.aginfra.data.analytics.visualization.model.repositories.DataDocumentRepository;
import gr.uoa.di.aginfra.data.analytics.visualization.model.repositories.querying.ConfigurationCriteria;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.bson.BasicBSONObject;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.BasicBSONList;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConfigurationRepositoryImpl
implements ConfigurationRepository {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static String CONFIGURATION_COLLECTION_NAME = "Configuration";
    private MongoDataSourceManager mongoDataSourceManager;
    private DataDocumentRepository dataDocumentDAO;

    @Autowired
    public ConfigurationRepositoryImpl(MongoDataSourceManager mongoDataSourceManager, DataDocumentRepository dataDocumentDAO) {
        this.mongoDataSourceManager = mongoDataSourceManager;
        this.dataDocumentDAO = dataDocumentDAO;
    }

    @Override
    public Configuration getById(String id) throws Exception {
        MongoDatabase database = this.mongoDataSourceManager.getDataBase();
        MongoCollection collection = database.getCollection(CONFIGURATION_COLLECTION_NAME);
        Document document = (Document)collection.find(Filters.eq((Object)new ObjectId(id))).first();
        if (document == null) {
            return null;
        }
        Configuration item = ConfigurationRepositoryImpl.mapTo(document);
        return item;
    }

    @Override
    public List<Configuration> getConfigurations(ConfigurationCriteria criteria) throws Exception {
        MongoDatabase database = this.mongoDataSourceManager.getDataBase();
        MongoCollection collection = database.getCollection(CONFIGURATION_COLLECTION_NAME);
        ArrayList<Configuration> configurations = new ArrayList<Configuration>();
        for (Document document : collection.find((Bson)new Document("vre", (Object)criteria.getVre())).sort((Bson)new Document("label", (Object)1))) {
            Configuration item = ConfigurationRepositoryImpl.mapTo(document);
            item.setId(document.getObjectId((Object)"_id").toString());
            configurations.add(item);
        }
        return configurations;
    }

    @Override
    public String create(Configuration item) throws Exception {
        MongoDatabase database = this.mongoDataSourceManager.getDataBase();
        MongoCollection collection = database.getCollection(CONFIGURATION_COLLECTION_NAME);
        Document document = ConfigurationRepositoryImpl.mapTo(item);
        collection.insertOne((Object)document);
        ObjectId id = (ObjectId)document.get((Object)"_id");
        return id.toString();
    }

    @Override
    public void update(Configuration item) throws Exception {
        MongoDatabase database = this.mongoDataSourceManager.getDataBase();
        MongoCollection collection = database.getCollection(CONFIGURATION_COLLECTION_NAME);
        Document document = ConfigurationRepositoryImpl.mapTo(item);
        collection.updateOne((Bson)new BasicDBObject("_id", (Object)new ObjectId(item.getId())), (Bson)new BasicDBObject("$set", (Object)document));
    }

    @Override
    public void delete(String id) throws Exception {
        MongoDatabase database = this.mongoDataSourceManager.getDataBase();
        MongoCollection collection = database.getCollection(CONFIGURATION_COLLECTION_NAME);
        Configuration configuration = this.getById(id);
        List<DataSource> dataSources = configuration.getDataSources();
        if (dataSources != null) {
            for (DataSource dataSource : dataSources) {
                this.dataDocumentDAO.delete(dataSource.getSource());
            }
        }
        collection.deleteOne((Bson)new BasicDBObject("_id", (Object)new ObjectId(id)));
    }

    private static Configuration mapTo(Document document) {
        Configuration configuration = new Configuration();
        configuration.setId(document.getObjectId((Object)"_id").toString());
        if (document.containsKey((Object)"label")) {
            configuration.setLabel(document.getString((Object)"label"));
        }
        if (document.containsKey((Object)"description")) {
            configuration.setDescription(document.getString((Object)"description"));
        }
        if (document.containsKey((Object)"type")) {
            configuration.setType(VisualizationType.valueOf(document.getString((Object)"type")));
        }
        if (document.containsKey((Object)"vre")) {
            configuration.setVre(document.getString((Object)"vre"));
        }
        if (document.containsKey((Object)"availableTypes")) {
            configuration.setAvailableTypes((List)mapper.convertValue(document.get((Object)"availableTypes"), (TypeReference)new TypeReference<List<VisualizationType>>(){}));
        }
        if (document.containsKey((Object)"groupBy")) {
            configuration.setGroupBy(document.getString((Object)"groupBy"));
        }
        if (document.containsKey((Object)"joins")) {
            configuration.setJoins((List)mapper.convertValue(document.get((Object)"joins"), (TypeReference)new TypeReference<List<Join>>(){}));
        }
        if (document.containsKey((Object)"dataSources")) {
            configuration.setDataSources((List)mapper.convertValue(document.get((Object)"dataSources"), (TypeReference)new TypeReference<List<DataSource>>(){}));
        }
        if (document.containsKey((Object)"xAxis")) {
            configuration.setXAxis(document.getString((Object)"xAxis"));
        }
        if (document.containsKey((Object)"xAxisLabel")) {
            configuration.setXAxisLabel(document.getString((Object)"xAxisLabel"));
        }
        if (document.containsKey((Object)"yAxis")) {
            configuration.setYAxis(document.getString((Object)"yAxis"));
        }
        if (document.containsKey((Object)"yAxisLabel")) {
            configuration.setYAxisLabel(document.getString((Object)"yAxisLabel"));
        }
        if (document.containsKey((Object)"zAxis")) {
            configuration.setZAxis(document.getString((Object)"zAxis"));
        }
        if (document.containsKey((Object)"zAxisLabel")) {
            configuration.setZAxisLabel(document.getString((Object)"zAxisLabel"));
        }
        if (document.containsKey((Object)"labelField")) {
            configuration.setLabelField(document.getString((Object)"labelField"));
        }
        if (document.containsKey((Object)"valueField")) {
            configuration.setValueField(document.getString((Object)"valueField"));
        }
        if (document.containsKey((Object)"filters")) {
            configuration.setFilters((List)mapper.convertValue(document.get((Object)"filters"), (TypeReference)new TypeReference<List<Filter>>(){}));
        }
        if (document.containsKey((Object)"transformations")) {
            configuration.setTransformations((Transformation)mapper.convertValue(document.get((Object)"transformations"), (TypeReference)new TypeReference<Transformation>(){}));
        }
        if (document.containsKey((Object)"colorField")) {
            configuration.setColorField(document.getString((Object)"colorField"));
        }
        if (document.containsKey((Object)"documentField")) {
            configuration.setDocumentField(document.getString((Object)"documentField"));
        }
        if (document.containsKey((Object)"activeDocuments")) {
            configuration.setActiveDocuments(document.getInteger((Object)"activeDocuments"));
        }
        if (document.containsKey((Object)"createdAt") && document.getLong((Object)"createdAt") != null) {
            configuration.setCreatedAt(new Date(document.getLong((Object)"createdAt")));
        }
        if (document.containsKey((Object)"updatedAt") && document.getLong((Object)"updatedAt") != null) {
            configuration.setUpdatedAt(new Date(document.getLong((Object)"updatedAt")));
        }
        return configuration;
    }

    private static Document mapTo(Configuration configuration) {
        BasicBSONObject object;
        BasicBSONList list;
        Document document = new Document();
        if (configuration.getLabel() != null) {
            document.append("label", (Object)configuration.getLabel());
        }
        if (configuration.getDescription() != null) {
            document.append("description", (Object)configuration.getDescription());
        }
        if (configuration.getType() != null) {
            document.append("type", (Object)configuration.getType().toString());
        }
        if (configuration.getVre() != null) {
            document.append("vre", (Object)configuration.getVre());
        }
        if (configuration.getAvailableTypes() != null) {
            document.append("availableTypes", configuration.getAvailableTypes().stream().map(x -> x.toString()).collect(Collectors.toList()));
        }
        if (configuration.getGroupBy() != null) {
            document.append("groupBy", (Object)configuration.getGroupBy());
        }
        if (configuration.getJoins() != null && configuration.getJoins().size() > 0) {
            list = new BasicBSONList();
            for (Join join : configuration.getJoins()) {
                object = new BasicBSONObject();
                object.append("source", (Object)join.getSource());
                object.append("field", (Object)join.getField());
                list.add((Object)object);
            }
            document.append("joins", (Object)list);
        } else {
            document.append("joins", null);
        }
        if (configuration.getDataSources() != null && configuration.getDataSources().size() > 0) {
            list = new BasicBSONList();
            for (DataSource dataSource : configuration.getDataSources()) {
                object = new BasicBSONObject();
                object.append("name", (Object)dataSource.getName());
                object.append("type", (Object)dataSource.getType().toString());
                object.append("source", (Object)dataSource.getSource());
                object.append("fields", dataSource.getFields());
                list.add((Object)object);
            }
            document.append("dataSources", (Object)list);
        } else {
            document.append("dataSources", null);
        }
        if (configuration.getTransformations() != null && configuration.getTransformations().getTransformationColumns().size() > 0) {
            BasicBSONObject object2 = new BasicBSONObject();
            object2.append("transformationLabel", (Object)configuration.getTransformations().getTransformationLabel());
            object2.append("transformationLabelValue", (Object)configuration.getTransformations().getTransformationLabelValue());
            object2.append("transformationColumns", configuration.getTransformations().getTransformationColumns().stream().map(x -> x.toString()).collect(Collectors.toList()));
            document.append("transformations", (Object)object2);
        } else {
            document.append("transformations", null);
        }
        document.append("activeDocuments", (Object)configuration.getActiveDocuments());
        if (configuration.getXAxis() != null) {
            document.append("xAxis", (Object)configuration.getXAxis());
        }
        if (configuration.getXAxisLabel() != null) {
            document.append("xAxisLabel", (Object)configuration.getXAxisLabel());
        }
        if (configuration.getYAxis() != null) {
            document.append("yAxis", (Object)configuration.getYAxis());
        }
        if (configuration.getYAxisLabel() != null) {
            document.append("yAxisLabel", (Object)configuration.getYAxisLabel());
        }
        if (configuration.getZAxis() != null) {
            document.append("zAxis", (Object)configuration.getZAxis());
        }
        if (configuration.getZAxisLabel() != null) {
            document.append("zAxisLabel", (Object)configuration.getZAxisLabel());
        }
        if (configuration.getLabelField() != null) {
            document.append("labelField", (Object)configuration.getLabelField());
        }
        if (configuration.getValueField() != null) {
            document.append("valueField", (Object)configuration.getValueField());
        }
        if (configuration.getFilters() != null && configuration.getFilters().size() > 0) {
            list = new BasicBSONList();
            for (Filter filter : configuration.getFilters()) {
                object = new BasicBSONObject();
                object.append("label", (Object)filter.getLabel());
                object.append("field", (Object)filter.getField());
                object.append("type", (Object)filter.getType().toString());
                object.append("required", (Object)filter.isRequired());
                list.add((Object)object);
            }
            document.append("filters", (Object)list);
        } else {
            document.append("filters", null);
        }
        if (configuration.getColorField() != null) {
            document.append("colorField", (Object)configuration.getColorField());
        }
        if (configuration.getDocumentField() != null) {
            document.append("documentField", (Object)configuration.getDocumentField());
        }
        if (configuration.getCreatedAt() != null) {
            document.append("createdAt", (Object)configuration.getCreatedAt().getTime());
        }
        if (configuration.getUpdatedAt() != null) {
            document.append("updatedAt", (Object)configuration.getUpdatedAt().getTime());
        }
        return document;
    }
}

