/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.extractors;

import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.Key;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.data.DataSet;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.data.DataSetManipulator;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.data.HeatMapData;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.extractors.HeatMapDataExtractor;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.filters.DataSetFilterApplier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class HeatMapDataExtractorImpl
extends DataSetManipulator
implements HeatMapDataExtractor {
    @Override
    public HeatMapData extract(DataSet dataSet, String xAxisField, String yAxisField, String zAxisField, String groupByField, Map<String, String> filters, DataSetFilterApplier dataSetFilterApplier) throws Exception {
        int xAxisFieldIndex = -1;
        if (xAxisField == null || (xAxisFieldIndex = this.getFieldIndex(dataSet, xAxisField)) == -1) {
            throw new Exception("Invalid data field provided " + xAxisField);
        }
        int yAxisFieldIndex = -1;
        if (yAxisField == null || (yAxisFieldIndex = this.getFieldIndex(dataSet, yAxisField)) == -1) {
            throw new Exception("Invalid data field provided " + yAxisField);
        }
        int zAxisFieldIndex = -1;
        if (zAxisField == null || (zAxisFieldIndex = this.getFieldIndex(dataSet, zAxisField)) == -1) {
            throw new Exception("Invalid data field provided " + zAxisField);
        }
        return this.extract(dataSet, xAxisFieldIndex, yAxisFieldIndex, zAxisFieldIndex);
    }

    private HeatMapData extract(DataSet dataSet, int xAxisFieldIndex, int yAxisFieldIndex, int zAxisFieldIndex) {
        HeatMapData heatMapData = new HeatMapData();
        ArrayList<String> xAxisData = new ArrayList();
        ArrayList<String> yAxisData = new ArrayList();
        ArrayList<List<Integer>> zAxisData = new ArrayList<List<Integer>>();
        HashMap uniqueFieldCombinations = new HashMap();
        for (List<String> row : dataSet.getData()) {
            String xValue = row.get(xAxisFieldIndex);
            String yValue = row.get(yAxisFieldIndex);
            String zValue = row.get(zAxisFieldIndex);
            if (xValue == null || yValue == null || zValue == null) continue;
            Key key = new Key(xValue, yValue);
            if (uniqueFieldCombinations.containsKey(key)) {
                ((List)uniqueFieldCombinations.get(key)).add(zValue);
                continue;
            }
            ArrayList<String> list = new ArrayList<String>();
            list.add(zValue);
            uniqueFieldCombinations.put(key, list);
            if (!xAxisData.contains(xValue)) {
                xAxisData.add(xValue);
            }
            if (yAxisData.contains(yValue)) continue;
            yAxisData.add(yValue);
        }
        try {
            List xAxisDataInteger = xAxisData.stream().map(Integer::valueOf).sorted().collect(Collectors.toList());
            xAxisData = xAxisDataInteger.stream().map(String::valueOf).collect(Collectors.toList());
        }
        catch (NumberFormatException exception) {
            xAxisData = xAxisData.stream().sorted().collect(Collectors.toList());
        }
        try {
            List yAxisDataInteger = yAxisData.stream().map(Integer::valueOf).sorted().collect(Collectors.toList());
            yAxisData = yAxisDataInteger.stream().map(String::valueOf).collect(Collectors.toList());
        }
        catch (NumberFormatException exception) {
            yAxisData = yAxisData.stream().sorted().collect(Collectors.toList());
        }
        for (String y : yAxisData) {
            ArrayList<Integer> zListRow = new ArrayList<Integer>();
            for (String x : xAxisData) {
                List combinationValue = (List)uniqueFieldCombinations.get(new Key(x, y));
                if (combinationValue != null) {
                    OptionalDouble total = combinationValue.stream().filter(e -> e.chars().allMatch(Character::isDigit)).mapToInt(i -> Integer.valueOf(i)).average();
                    if (total.isPresent()) {
                        Double average = total.getAsDouble();
                        zListRow.add(average.intValue());
                        continue;
                    }
                    zListRow.add(null);
                    continue;
                }
                zListRow.add(null);
            }
            zAxisData.add(zListRow);
        }
        heatMapData.setXAxis(xAxisData);
        heatMapData.setYAxis(yAxisData);
        heatMapData.setZAxis(zAxisData);
        return heatMapData;
    }
}

