/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.aginfra.data.analytics.visualization.service.controllers;

import gr.uoa.di.aginfra.data.analytics.visualization.model.exceptions.InvalidFormatException;
import java.util.NoSuchElementException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;

@Component
public class BaseController {
    private static final Logger logger = LogManager.getLogger(BaseController.class);

    @ExceptionHandler(value={NoSuchElementException.class})
    public final ResponseEntity<String> handleNoSuchElementException(NoSuchElementException e) {
        logger.info(e.getMessage(), (Throwable)e);
        return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)e.getMessage());
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public final ResponseEntity<String> handleIllegalArgumentException(IllegalArgumentException e) {
        logger.error(e.getMessage(), (Throwable)e);
        return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)e.getMessage());
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public final ResponseEntity<String> handleValidationException(MethodArgumentNotValidException exception) {
        String errorMsg = exception.getBindingResult().getFieldErrors().stream().map(DefaultMessageSourceResolvable::getDefaultMessage).findFirst().orElse(exception.getMessage());
        return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)errorMsg);
    }

    @ExceptionHandler(value={InvalidFormatException.class})
    public final ResponseEntity<String> handleInvalidFormatException(InvalidFormatException exception) {
        logger.error(exception.getMessage(), (Throwable)exception);
        return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)exception.getMessage());
    }

    @ExceptionHandler(value={Exception.class})
    public final ResponseEntity<String> handleGenericException(Exception exception) {
        logger.error(exception.getMessage(), (Throwable)exception);
        return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)exception.getMessage());
    }
}

