/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.aginfra.data.analytics.visualization.service.controllers;

import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.DropdownProperties;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.GeometryType;
import gr.uoa.di.aginfra.data.analytics.visualization.model.helpers.DashBoardMapConverter;
import gr.uoa.di.aginfra.data.analytics.visualization.model.services.DashBoardService;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.data.TimeSeries;
import gr.uoa.di.aginfra.data.analytics.visualization.service.mappers.EntityMapper;
import gr.uoa.di.aginfra.data.analytics.visualization.service.vres.VREResolver;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.geojson.Feature;
import org.geojson.FeatureCollection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@CrossOrigin(exposedHeaders={"Location"})
@RequestMapping(value={"/dashboard"})
public class DashBoardController {
    @Value(value="${gr.uoa.di.aginfra.agrodatacubeapi.baseUrl.fields}")
    private String gCubeUrl;
    @Value(value="${gr.uoa.di.aginfra.agrodatacubeapi.baseUrl.soiltypes}")
    private String gCubeUrlSoil;
    @Value(value="${gr.uoa.di.aginfra.agrodatacubeapi.baseUrl.meteodata}")
    private String gCubeUrlMeteoData;
    private static final Logger logger = LogManager.getLogger(DashBoardController.class);
    protected static final String DASHBOARD_BASE_PATH = "dashboard";
    private DashBoardService dashBoardService;
    private EntityMapper modelMapper;
    private VREResolver vreResolver;

    @Autowired
    public DashBoardController(DashBoardService dashBoardService, EntityMapper modelMapper, VREResolver vreResolver) {
        this.dashBoardService = dashBoardService;
        this.modelMapper = modelMapper;
        this.vreResolver = vreResolver;
    }

    @RequestMapping(value={"get"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResponseEntity<?> get(@RequestBody Map<String, Object> params) throws Exception {
        logger.debug("Retrieving visualization usage statistics");
        FeatureCollection stats = this.dashBoardService.get(this.gCubeUrl, params, GeometryType.Polygon);
        return ResponseEntity.ok((Object)stats);
    }

    @RequestMapping(value={"getCropHistory"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResponseEntity<?> getCropHistory(@RequestBody Map<String, Object> params) throws Exception {
        logger.debug("Retrieving visualization usage statistics");
        FeatureCollection cropHistory = this.dashBoardService.get(this.gCubeUrl, params, GeometryType.Point);
        List cropDetails = DashBoardMapConverter.cropDetailsConvert((List)cropHistory.getFeatures(), (DashBoardService)this.dashBoardService, (String)this.gCubeUrl, params);
        return ResponseEntity.ok((Object)cropDetails);
    }

    @RequestMapping(value={"field/{id}"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResponseEntity<?> getFieldCharacteristics(@PathVariable(value="id") String fieldId, @RequestBody Map<String, Object> params) throws Exception {
        logger.debug("Retrieving visualization usage statistics");
        FeatureCollection fieldDetailsFeatureCollection = this.dashBoardService.getFieldDetails(this.gCubeUrl + "/" + fieldId, params);
        List fieldDetails = DashBoardMapConverter.fieldInfoConvert((Map)((Feature)fieldDetailsFeatureCollection.getFeatures().get(0)).getProperties());
        return ResponseEntity.ok((Object)fieldDetails);
    }

    @RequestMapping(value={"field/{id}/{info}"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResponseEntity<?> getFieldCharacteristics(@PathVariable(value="id") String fieldId, @PathVariable(value="info") String altitude, @RequestBody Map<String, Object> params) throws Exception {
        logger.debug("Retrieving visualization usage statistics");
        FeatureCollection fieldDetailsFeatureCollection = this.dashBoardService.getFieldDetails(this.gCubeUrl + "/" + fieldId + "/" + altitude, params);
        List fieldDetails = DashBoardMapConverter.fieldInfoConvert((Map)((Feature)fieldDetailsFeatureCollection.getFeatures().get(0)).getProperties());
        if (((Feature)fieldDetailsFeatureCollection.getFeatures().get(0)).getProperties().get("soilid") != null) {
            FeatureCollection soilDetails = this.dashBoardService.getFieldDetails(this.gCubeUrlSoil + ((Feature)fieldDetailsFeatureCollection.getFeatures().get(0)).getProperties().get("soilid"), params);
            List soil = DashBoardMapConverter.FieldDetailsConvert((Map)((Feature)soilDetails.getFeatures().get(0)).getProperties());
            fieldDetails.addAll(soil);
        }
        return ResponseEntity.ok((Object)fieldDetails);
    }

    @RequestMapping(value={"soil/{id}/{info}"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResponseEntity<?> getSoilCharacteristics(@PathVariable(value="id") String fieldId, @PathVariable(value="info") String altitude, @RequestBody Map<String, Object> params) throws Exception {
        logger.debug("Retrieving visualization usage statistics");
        FeatureCollection fieldDetailsFeatureCollection = this.dashBoardService.getFieldDetails(this.gCubeUrl + "/" + fieldId + "/" + altitude, params);
        List fieldDetails = DashBoardMapConverter.soilDetailsConvert((List)fieldDetailsFeatureCollection.getFeatures());
        FeatureCollection soilDetails = null;
        for (int i = 0; i < fieldDetails.size(); ++i) {
            soilDetails = this.dashBoardService.getFieldDetails(this.gCubeUrlSoil + ((DashBoardMapConverter.SoilDetails)fieldDetails.get(i)).getSoilid(), params);
            DashBoardMapConverter.Soil soil = DashBoardMapConverter.soilConvert((Feature)((Feature)soilDetails.getFeatures().get(0)));
            ((DashBoardMapConverter.SoilDetails)fieldDetails.get(i)).setSoil(soil);
        }
        soilDetails.hashCode();
        return ResponseEntity.ok((Object)fieldDetails);
    }

    @RequestMapping(value={"soilInfo/{id}"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResponseEntity<?> getSoilTypeInfo(@PathVariable(value="id") String fieldId, @RequestBody Map<String, Object> params) throws Exception {
        logger.debug("Retrieving visualization usage statistics");
        FeatureCollection fieldDetails = this.dashBoardService.getFieldDetails(this.gCubeUrlSoil + fieldId, params);
        return ResponseEntity.ok((Object)fieldDetails);
    }

    @RequestMapping(value={"meteostation/{id}"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResponseEntity<?> getNearestMeteoStations(@PathVariable(value="id") String fieldId, @RequestBody Map<String, Object> params) throws Exception {
        logger.debug("Retrieving visualization usage statistics");
        FeatureCollection fieldDetails = this.dashBoardService.getFieldDetails(this.gCubeUrl + "/" + fieldId + "/meteostations", params);
        if (fieldDetails.getFeatures().isEmpty()) {
            return ResponseEntity.ok(null);
        }
        ArrayList meteoStationsIds = new ArrayList();
        for (Feature feature : fieldDetails.getFeatures()) {
            meteoStationsIds.add(feature.getProperties().get("meteostationid"));
        }
        return ResponseEntity.ok(meteoStationsIds);
    }

    @RequestMapping(value={"meteodata/{yAxisColumn}"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResponseEntity<?> getMeteoData(@PathVariable(value="yAxisColumn") String yAxisColumn, @RequestBody Map<String, Object> params) throws Exception {
        logger.debug("Retrieving visualization usage statistics");
        List meteostationIds = (List)params.get("meteostation");
        params.remove("meteostation");
        for (int meteoId = meteostationIds.size() - 1; meteoId >= 0; --meteoId) {
            params.remove("meteostation");
            params.put("meteostation", meteostationIds.get(meteoId));
            FeatureCollection fieldDetails = this.dashBoardService.get(this.gCubeUrlMeteoData, params, GeometryType.Polygon);
            ArrayList<TimeSeries> timeSeriesList = new ArrayList<TimeSeries>();
            TimeSeries timeSeries = this.dashBoardService.getTimeSeries(yAxisColumn, fieldDetails);
            timeSeriesList.add(timeSeries);
            if (timeSeriesList.isEmpty() || timeSeries.getXAxisData().size() == 0) continue;
            return ResponseEntity.ok(timeSeriesList);
        }
        return ResponseEntity.ok((Object)"");
    }

    @RequestMapping(value={"meteodata/properties"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResponseEntity<?> getMeteoDataProperties(@RequestBody Map<String, Object> params) throws Exception {
        logger.debug("Retrieving visualization usage statistics");
        List meteostationIds = (List)params.get("meteostation");
        params.remove("meteostation");
        for (int meteoId = meteostationIds.size() - 1; meteoId >= 0; --meteoId) {
            params.remove("meteostation");
            params.put("meteostation", meteostationIds.get(meteoId));
            FeatureCollection fieldDetails = this.dashBoardService.get(this.gCubeUrlMeteoData, params, GeometryType.Polygon);
            if (fieldDetails.getFeatures().isEmpty()) continue;
            ArrayList properties = new ArrayList(((Feature)fieldDetails.getFeatures().get(0)).getProperties().keySet());
            ArrayList<DropdownProperties> dropdownPropertiesList = new ArrayList<DropdownProperties>();
            int j = 0;
            for (int i = 0; i < properties.size(); ++i) {
                if (((String)properties.get(i)).equals("meteostationid") || ((String)properties.get(i)).equals("datum")) continue;
                dropdownPropertiesList.add(new DropdownProperties(j, (String)properties.get(i), j));
                ++j;
            }
            if (dropdownPropertiesList.isEmpty()) continue;
            return ResponseEntity.ok(dropdownPropertiesList);
        }
        return ResponseEntity.ok(new ArrayList());
    }

    @RequestMapping(value={"ndvi/{id}/{yAxisColumn}"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResponseEntity<?> getNdviData(@PathVariable(value="yAxisColumn") String yAxisColumn, @PathVariable(value="id") String fieldId, @RequestBody Map<String, Object> params) throws Exception {
        logger.debug("Retrieving visualization usage statistics");
        FeatureCollection fieldDetails = this.dashBoardService.get(this.gCubeUrl + "/" + fieldId + "/ndvi", params, GeometryType.Polygon);
        ArrayList<TimeSeries> timeSeriesList = new ArrayList<TimeSeries>();
        TimeSeries timeSeries = this.dashBoardService.getTimeSeries(yAxisColumn, fieldDetails);
        timeSeriesList.add(timeSeries);
        return ResponseEntity.ok(timeSeriesList);
    }

    @RequestMapping(value={"ndvi/properties/{id}"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResponseEntity<?> getNdviProperties(@PathVariable(value="id") String fieldId, @RequestBody Map<String, Object> params) throws Exception {
        logger.debug("Retrieving visualization usage statistics");
        FeatureCollection fieldDetails = this.dashBoardService.get(this.gCubeUrl + "/" + fieldId + "/ndvi", params, GeometryType.Polygon);
        if (fieldDetails.getFeatures().isEmpty()) {
            return ResponseEntity.ok(new ArrayList());
        }
        ArrayList properties = new ArrayList(((Feature)fieldDetails.getFeatures().get(0)).getProperties().keySet());
        ArrayList<DropdownProperties> dropdownPropertiesList = new ArrayList<DropdownProperties>();
        int j = 0;
        for (int i = 0; i < properties.size(); ++i) {
            if (((String)properties.get(i)).equals("fieldid") || ((String)properties.get(i)).equals("datum") || ((String)properties.get(i)).equals("id") || ((String)properties.get(i)).equals("daynr")) continue;
            dropdownPropertiesList.add(new DropdownProperties(j, (String)properties.get(i), j));
            ++j;
        }
        return ResponseEntity.ok(dropdownPropertiesList);
    }
}

