/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.aginfra.data.analytics.visualization.service.controllers;

import com.fasterxml.jackson.databind.ObjectMapper;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.netgraph.NetworkGraph;
import gr.uoa.di.aginfra.data.analytics.visualization.model.helpers.D3Helper;
import gr.uoa.di.aginfra.data.analytics.visualization.model.services.NetworkGraphService;
import gr.uoa.di.aginfra.data.analytics.visualization.service.dtos.netgraph.NetworkGraphDto;
import gr.uoa.di.aginfra.data.analytics.visualization.service.mappers.EntityMapper;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@Controller
@CrossOrigin(exposedHeaders={"Location"})
@RequestMapping(value={"/graph"})
public class NetworkGraphController {
    private static final Logger logger = LogManager.getLogger(NetworkGraphController.class);
    protected static final String NETWORK_GRAPH_BASE_PATH = "graph";
    private NetworkGraphService networkGraphService;
    private EntityMapper modelMapper;
    private static final ObjectMapper mapper = new ObjectMapper();

    @Autowired
    public NetworkGraphController(NetworkGraphService networkGraphService, EntityMapper modelMapper) {
        this.networkGraphService = networkGraphService;
        this.modelMapper = modelMapper;
    }

    @RequestMapping(value={"file"}, method={RequestMethod.POST}, consumes={"multipart/form-data"}, produces={"application/json"})
    public ResponseEntity<?> importDataFile(@RequestParam(value="file") MultipartFile file, @RequestParam(value="name") String graphName) throws Exception {
        String tenantName;
        NetworkGraphDto networkGraphDto = (NetworkGraphDto)mapper.readValue(file.getBytes(), NetworkGraphDto.class);
        NetworkGraph networkGraph = this.modelMapper.map(networkGraphDto, graphName, tenantName = "testTenant");
        int results = this.networkGraphService.storeNetworkGraph(networkGraph);
        if (results > 0) {
            // empty if block
        }
        UriComponents uriComponents = UriComponentsBuilder.newInstance().path("graph/{id}").buildAndExpand(new Object[]{networkGraph.getGraphId()});
        return ResponseEntity.created((URI)uriComponents.toUri()).body((Object)results);
    }

    @RequestMapping(value={"graphs"}, method={RequestMethod.GET}, produces={"application/json"})
    ResponseEntity<?> getAvailableGraphs() {
        try {
            List result = this.networkGraphService.getAllGraphsByTenant("tenant");
            return new ResponseEntity((Object)result, HttpStatus.OK);
        }
        catch (IOException e) {
            e.printStackTrace();
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"graphs/{subGraphId}"}, method={RequestMethod.GET}, produces={"application/json"})
    ResponseEntity<?> getTopNodes(@PathVariable String subGraphId, @RequestParam(value="number") int number) {
        try {
            List results = this.networkGraphService.getTopNodesOfGraph(subGraphId, number);
            Map d3Results = D3Helper.nodesToD3Format((Collection)results, (boolean)true);
            return new ResponseEntity((Object)d3Results, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"neighbors/{subGraphId}/{nodeId}"}, method={RequestMethod.GET}, produces={"application/json"})
    ResponseEntity<?> getNeighbors(@PathVariable String subGraphId, @PathVariable String nodeId) {
        try {
            List results = this.networkGraphService.getNeighborNodes(subGraphId, nodeId);
            Map d3Results = D3Helper.neighborsNodesToD3Format((Collection)results, (String)nodeId, (boolean)false);
            return new ResponseEntity((Object)d3Results, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"next/{id}"}, method={RequestMethod.GET}, produces={"application/json"})
    ResponseEntity<?> getNextTimeSubgraph(@PathVariable(value="id") String graphId, @RequestParam(value="nodes[]") String[] nodes, @RequestParam(value="date") String currentDate) {
        List<String> nodeList = Arrays.asList(nodes);
        try {
            Map result = this.networkGraphService.getNextTimestampSubGraph(graphId, nodeList, currentDate);
            return new ResponseEntity((Object)result, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"dates/{id}"}, method={RequestMethod.GET}, produces={"application/json"})
    ResponseEntity<?> getCurrentTimeSubgraph(@PathVariable(value="id") String graphId, @RequestParam(value="nodes") ArrayList<String> nodes, @RequestParam(value="date") String currentDate) {
        try {
            ArrayList<String> nodeList = nodes;
            List result = this.networkGraphService.getCurrentTimestampGraph(graphId, nodeList, currentDate);
            Map d3Results = D3Helper.hasWeightToD3Format((Collection)result, (String)graphId, (NetworkGraphService)this.networkGraphService);
            return new ResponseEntity((Object)d3Results, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"timestamps/{graphId}"})
    ResponseEntity<?> getTimestamps(@PathVariable(value="graphId") String graphId) {
        List results = null;
        try {
            results = this.networkGraphService.getAllTimestamps(graphId);
            results = D3Helper.datesToDateStrings((List)results);
            return new ResponseEntity((Object)results, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

