/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.aginfra.data.analytics.visualization.service.controllers;

import com.sun.org.apache.xerces.internal.parsers.DOMParser;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.DataDocument;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.DataMinerResults;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.DropdownProperties;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.GeometryType;
import gr.uoa.di.aginfra.data.analytics.visualization.model.helpers.CSVReader;
import gr.uoa.di.aginfra.data.analytics.visualization.model.helpers.DashBoardMapConverter;
import gr.uoa.di.aginfra.data.analytics.visualization.model.http.HttpClient;
import gr.uoa.di.aginfra.data.analytics.visualization.model.mapper.XMLMapper;
import gr.uoa.di.aginfra.data.analytics.visualization.model.repositories.DataDocumentRepository;
import gr.uoa.di.aginfra.data.analytics.visualization.model.services.DashBoardService;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.data.TimeSeries;
import gr.uoa.di.aginfra.data.analytics.visualization.service.mappers.EntityMapper;
import gr.uoa.di.aginfra.data.analytics.visualization.service.vres.VREResolver;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import mil.nga.sf.geojson.Feature;
import mil.nga.sf.geojson.FeatureCollection;
import mil.nga.sf.geojson.FeatureConverter;
import mil.nga.sf.geojson.GeoJsonObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@Controller
@CrossOrigin
@RequestMapping(value={"/dashboard"})
public class DashBoardController {
    @Value(value="${gr.uoa.di.aginfra.agrodatacubeapi.baseUrl.fields}")
    private String gCubeUrl;
    @Value(value="${gr.uoa.di.aginfra.agrodatacubeapi.baseUrl.soiltypes}")
    private String gCubeUrlSoil;
    @Value(value="${gr.uoa.di.aginfra.agrodatacubeapi.baseUrl.soiltypesV1}")
    private String gCubeUrlSoilV1;
    @Value(value="${gr.uoa.di.aginfra.agrodatacubeapi.baseUrl.meteodata}")
    private String gCubeUrlMeteoData;
    @Value(value="${gr.uoa.di.aginfra.dataminer_url}")
    private String url;
    private static final Logger logger = LogManager.getLogger(DashBoardController.class);
    protected static final String DASHBOARD_BASE_PATH = "dashboard";
    private DashBoardService dashBoardService;
    private EntityMapper modelMapper;
    private VREResolver vreResolver;
    private HttpClient httpClient = HttpClient.getInstance();
    private DataDocumentRepository dataDocumentDAO;

    @Autowired
    public DashBoardController(DashBoardService dashBoardService, EntityMapper modelMapper, DataDocumentRepository dataDocumentDAO, VREResolver vreResolver) {
        this.dashBoardService = dashBoardService;
        this.modelMapper = modelMapper;
        this.dataDocumentDAO = dataDocumentDAO;
        this.vreResolver = vreResolver;
    }

    @RequestMapping(value={"get"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResponseEntity<?> get(@RequestBody Map<String, Object> params) throws Exception {
        logger.debug("Retrieving visualization usage statistics");
        org.geojson.FeatureCollection stats = this.dashBoardService.get(this.gCubeUrl, params, GeometryType.Polygon);
        org.geojson.FeatureCollection features = this.dashBoardService.setColorsToFeatureCollection(stats);
        return ResponseEntity.ok((Object)features);
    }

    @RequestMapping(value={"getCropHistory"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResponseEntity<?> getCropHistory(@RequestBody Map<String, Object> params) throws Exception {
        logger.debug("Retrieving visualization usage statistics");
        org.geojson.FeatureCollection cropHistory = this.dashBoardService.get(this.gCubeUrl, params, GeometryType.Point);
        List cropDetails = DashBoardMapConverter.cropDetailsConvert((List)cropHistory.getFeatures(), (DashBoardService)this.dashBoardService, (String)this.gCubeUrl, params);
        return ResponseEntity.ok((Object)cropDetails);
    }

    @RequestMapping(value={"field/{id}"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResponseEntity<?> getFieldCharacteristics(@PathVariable(value="id") String fieldId, @RequestBody Map<String, Object> params) throws Exception {
        logger.debug("Retrieving visualization usage statistics");
        org.geojson.FeatureCollection fieldDetailsFeatureCollection = this.dashBoardService.getFieldDetails(this.gCubeUrl + "/" + fieldId, params);
        List fieldDetails = DashBoardMapConverter.fieldInfoConvert((Map)((org.geojson.Feature)fieldDetailsFeatureCollection.getFeatures().get(0)).getProperties());
        return ResponseEntity.ok((Object)fieldDetails);
    }

    @RequestMapping(value={"field/{id}/{info}"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResponseEntity<?> getFieldCharacteristics(@PathVariable(value="id") String fieldId, @PathVariable(value="info") String altitude, @RequestBody Map<String, Object> params) throws Exception {
        logger.debug("Retrieving visualization usage statistics");
        org.geojson.FeatureCollection fieldDetailsFeatureCollection = this.dashBoardService.getFieldDetails(this.gCubeUrl + "/" + fieldId + "/" + altitude, params);
        List fieldDetails = DashBoardMapConverter.fieldInfoConvert((Map)((org.geojson.Feature)fieldDetailsFeatureCollection.getFeatures().get(0)).getProperties());
        if (((org.geojson.Feature)fieldDetailsFeatureCollection.getFeatures().get(0)).getProperties().get("soilid") != null) {
            org.geojson.FeatureCollection soilDetails = this.dashBoardService.getFieldDetails(this.gCubeUrlSoil + ((org.geojson.Feature)fieldDetailsFeatureCollection.getFeatures().get(0)).getProperties().get("soilid"), params);
            List soil = DashBoardMapConverter.FieldDetailsConvert((Map)((org.geojson.Feature)soilDetails.getFeatures().get(0)).getProperties());
            fieldDetails.addAll(soil);
        }
        return ResponseEntity.ok((Object)fieldDetails);
    }

    @RequestMapping(value={"soil/{id}/{info}"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResponseEntity<?> getSoilCharacteristics(@PathVariable(value="id") String fieldId, @PathVariable(value="info") String altitude, @RequestBody Map<String, Object> params) throws Exception {
        logger.debug("Retrieving visualization usage statistics");
        org.geojson.FeatureCollection fieldDetailsFeatureCollection = this.dashBoardService.getFieldDetails(this.gCubeUrl + "/" + fieldId + "/" + altitude, params);
        List fieldDetails = DashBoardMapConverter.soilDetailsConvert((String)fieldId, (List)fieldDetailsFeatureCollection.getFeatures());
        org.geojson.FeatureCollection soilDetails = null;
        for (int i = 0; i < fieldDetails.size(); ++i) {
            soilDetails = this.dashBoardService.getFieldDetails(this.gCubeUrlSoilV1 + ((DashBoardMapConverter.SoilDetails)fieldDetails.get(i)).getSoilid(), params);
            DashBoardMapConverter.Soil soil = DashBoardMapConverter.soilConvert((org.geojson.Feature)((org.geojson.Feature)soilDetails.getFeatures().get(0)));
            ((DashBoardMapConverter.SoilDetails)fieldDetails.get(i)).setSoil(soil);
        }
        return ResponseEntity.ok((Object)fieldDetails);
    }

    @RequestMapping(value={"soilInfo/{id}"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResponseEntity<?> getSoilTypeInfo(@PathVariable(value="id") String fieldId, @RequestBody Map<String, Object> params) throws Exception {
        logger.debug("Retrieving visualization usage statistics");
        org.geojson.FeatureCollection fieldDetails = this.dashBoardService.getFieldDetails(this.gCubeUrlSoil + fieldId, params);
        return ResponseEntity.ok((Object)fieldDetails);
    }

    @RequestMapping(value={"meteostation/{id}"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResponseEntity<?> getNearestMeteoStations(@PathVariable(value="id") String fieldId, @RequestBody Map<String, Object> params) throws Exception {
        logger.debug("Retrieving visualization usage statistics");
        org.geojson.FeatureCollection fieldDetails = this.dashBoardService.getFieldDetails(this.gCubeUrl + "/" + fieldId + "/meteostations", params);
        if (fieldDetails.getFeatures().isEmpty()) {
            return ResponseEntity.ok(null);
        }
        ArrayList meteoStationsIds = new ArrayList();
        for (org.geojson.Feature feature : fieldDetails.getFeatures()) {
            meteoStationsIds.add(feature.getProperties().get("meteostationid"));
        }
        return ResponseEntity.ok(meteoStationsIds);
    }

    @RequestMapping(value={"meteodata/{yAxisColumn}"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResponseEntity<?> getMeteoData(@PathVariable(value="yAxisColumn") String yAxisColumn, @RequestBody Map<String, Object> params) throws Exception {
        logger.debug("Retrieving visualization usage statistics");
        List meteostationIds = (List)params.get("meteostation");
        params.remove("meteostation");
        for (int meteoId = meteostationIds.size() - 1; meteoId >= 0; --meteoId) {
            params.remove("meteostation");
            params.put("meteostation", meteostationIds.get(meteoId));
            org.geojson.FeatureCollection fieldDetails = this.dashBoardService.get(this.gCubeUrlMeteoData, params, GeometryType.Polygon);
            ArrayList<TimeSeries> timeSeriesList = new ArrayList<TimeSeries>();
            TimeSeries timeSeries = this.dashBoardService.getTimeSeries(yAxisColumn, fieldDetails);
            timeSeriesList.add(timeSeries);
            if (timeSeriesList.isEmpty() || timeSeries.getXAxisData().size() == 0) continue;
            return ResponseEntity.ok(timeSeriesList);
        }
        return ResponseEntity.ok((Object)"");
    }

    @RequestMapping(value={"meteodata/properties"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResponseEntity<?> getMeteoDataProperties(@RequestBody Map<String, Object> params) throws Exception {
        logger.debug("Retrieving visualization usage statistics");
        List meteostationIds = (List)params.get("meteostation");
        params.remove("meteostation");
        for (int meteoId = meteostationIds.size() - 1; meteoId >= 0; --meteoId) {
            params.remove("meteostation");
            params.put("meteostation", meteostationIds.get(meteoId));
            org.geojson.FeatureCollection fieldDetails = this.dashBoardService.get(this.gCubeUrlMeteoData, params, GeometryType.Polygon);
            if (fieldDetails.getFeatures().isEmpty()) continue;
            ArrayList properties = new ArrayList(((org.geojson.Feature)fieldDetails.getFeatures().get(0)).getProperties().keySet());
            ArrayList<DropdownProperties> dropdownPropertiesList = new ArrayList<DropdownProperties>();
            int j = 0;
            for (int i = 0; i < properties.size(); ++i) {
                if (((String)properties.get(i)).equals("meteostationid") || ((String)properties.get(i)).equals("datum")) continue;
                dropdownPropertiesList.add(new DropdownProperties(j, (String)properties.get(i), j));
                ++j;
            }
            if (dropdownPropertiesList.isEmpty()) continue;
            return ResponseEntity.ok(dropdownPropertiesList);
        }
        return ResponseEntity.ok(new ArrayList());
    }

    @RequestMapping(value={"ndvi/{id}/{yAxisColumn}"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResponseEntity<?> getNdviData(@PathVariable(value="yAxisColumn") String yAxisColumn, @PathVariable(value="id") String fieldId, @RequestBody Map<String, Object> params) throws Exception {
        logger.debug("Retrieving visualization usage statistics");
        org.geojson.FeatureCollection fieldDetails = this.dashBoardService.get(this.gCubeUrl + "/" + fieldId + "/ndvi", params, GeometryType.Polygon);
        ArrayList<TimeSeries> timeSeriesList = new ArrayList<TimeSeries>();
        TimeSeries timeSeries = this.dashBoardService.getTimeSeries(yAxisColumn, fieldDetails);
        timeSeriesList.add(timeSeries);
        return ResponseEntity.ok(timeSeriesList);
    }

    @RequestMapping(value={"ndvi/properties/{id}"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResponseEntity<?> getNdviProperties(@PathVariable(value="id") String fieldId, @RequestBody Map<String, Object> params) throws Exception {
        logger.debug("Retrieving visualization usage statistics");
        org.geojson.FeatureCollection fieldDetails = this.dashBoardService.get(this.gCubeUrl + "/" + fieldId + "/ndvi", params, GeometryType.Polygon);
        if (fieldDetails.getFeatures().isEmpty()) {
            return ResponseEntity.ok(new ArrayList());
        }
        ArrayList properties = new ArrayList(((org.geojson.Feature)fieldDetails.getFeatures().get(0)).getProperties().keySet());
        ArrayList<DropdownProperties> dropdownPropertiesList = new ArrayList<DropdownProperties>();
        int j = 0;
        for (int i = 0; i < properties.size(); ++i) {
            if (((String)properties.get(i)).equals("DATE") || ((String)properties.get(i)).equals("datum") || ((String)properties.get(i)).equals("id") || ((String)properties.get(i)).equals("daynr")) continue;
            dropdownPropertiesList.add(new DropdownProperties(j, (String)properties.get(i), j));
            ++j;
        }
        return ResponseEntity.ok(dropdownPropertiesList);
    }

    @RequestMapping(value={"getWorkspaceFile"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<?> getWorkspaceFile(@RequestParam String url) throws Exception {
        logger.debug("Retrieving visualization usage statistics");
        JSONObject selectedLayer = null;
        Map file = this.httpClient.workspaceGetRequest(url, null, null);
        JSONObject jsnobject = new JSONObject((String)file.get("body"));
        if (!(jsnobject.has("data") && jsnobject.has("visualization") && jsnobject.has("visualization") && jsnobject.has("data"))) {
            return ResponseEntity.ok((Object)"");
        }
        JSONObject data = jsnobject.getJSONObject("data");
        JSONObject visualization = jsnobject.getJSONObject("visualization");
        if (visualization.has("selectedLayer")) {
            Object selectedLayerObject = visualization.get("selectedLayer");
            if (selectedLayerObject instanceof String) {
                return ResponseEntity.ok((Object)jsnobject.toString());
            }
        } else {
            return ResponseEntity.ok((Object)jsnobject.toString());
        }
        selectedLayer = visualization.getJSONObject("selectedLayer");
        JSONObject properties = selectedLayer.getJSONObject("properties");
        int fieldid = properties.getInt("fieldid");
        JSONObject map = data.getJSONObject("map");
        String json = map.getString("json");
        FeatureCollection featureCollection = FeatureConverter.toFeatureCollection((String)json);
        for (Feature feature : featureCollection) {
            int fieldid1 = (Integer)feature.getProperties().get("fieldid");
            if (fieldid1 != fieldid) continue;
            String color = String.valueOf(feature.getProperties().get("color"));
            feature.getProperties().put("previousColor", color);
            feature.getProperties().put("color", "#ffaa33");
            System.out.println(feature.getProperties().toString());
        }
        jsnobject.getJSONObject("data").getJSONObject("map").remove("json");
        String newJson = FeatureConverter.toStringValue((GeoJsonObject)featureCollection);
        jsnobject.getJSONObject("data").getJSONObject("map").put("json", (Object)newJson);
        System.out.println(jsnobject.toString());
        return ResponseEntity.ok((Object)jsnobject.toString());
    }

    @RequestMapping(value={"getDataMinerData"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResponseEntity<?> getDataMinerData(@RequestBody Map<String, Object> params) throws Exception {
        logger.debug("Retrieving visualization usage statistics");
        Object selectedLayer = null;
        Map results = this.httpClient.workspaceGetRequest(this.url, null, params);
        if (results.get("body") == null) {
            return ResponseEntity.ok((Object)results);
        }
        DOMParser parser = new DOMParser();
        InputSource is = new InputSource(new StringReader((String)results.get("body")));
        parser.parse(is);
        Document doc = parser.getDocument();
        NodeList root = doc.getChildNodes();
        Node executeResponse = XMLMapper.getNode((String)"wps:ExecuteResponse", (NodeList)root);
        Node processOutputs = XMLMapper.getNode((String)"wps:ProcessOutputs", (NodeList)executeResponse.getChildNodes());
        Node output = XMLMapper.getNode((String)"wps:Output", (NodeList)processOutputs.getChildNodes());
        Node data = XMLMapper.getNode((String)"wps:Data", (NodeList)output.getChildNodes());
        Node complexData = XMLMapper.getNode((String)"wps:ComplexData", (NodeList)data.getChildNodes());
        Node featureCollection = XMLMapper.getNode((String)"ogr:FeatureCollection", (NodeList)complexData.getChildNodes());
        Node featureMember = XMLMapper.getNode((String)"gml:featureMember", (NodeList)featureCollection.getChildNodes());
        Node result = XMLMapper.getNode((String)"ogr:Result", (NodeList)featureMember.getChildNodes());
        List nodes1 = XMLMapper.getNodes((String)"ogr:Result", (NodeList)featureMember.getChildNodes());
        String execType = XMLMapper.getNodeAttr((String)"type", (Node)result);
        System.out.println(execType);
        NodeList nodes = ((Node)nodes1.get(1)).getChildNodes();
        String link = XMLMapper.getNodeValue((String)"d4science:Data", (NodeList)nodes);
        String desc = XMLMapper.getNodeValue((String)"d4science:Description", (NodeList)nodes);
        DataDocument dataDocument = new DataDocument();
        Map dataFromLink = this.httpClient.workspaceGetRequest(link, null, null);
        String[] units = new String[]{};
        String[] lines = ((String)dataFromLink.get("body")).split("\n");
        for (int i = 0; i < lines.length; ++i) {
            if (!lines[i].startsWith("#")) continue;
            if (lines[i].contains("Column units")) {
                String header = lines[i];
                for (String s : units = header.split(";")) {
                    System.out.println(s);
                }
            }
            lines[i] = "";
        }
        String[] finalCSV = (String[])Arrays.stream(lines).filter(value -> value != null && value.length() > 0).toArray(String[]::new);
        String[][] allData = CSVReader.readCSV((String[])finalCSV, (String)";");
        String[] header = finalCSV[0].split(";");
        List<String> properties = Arrays.asList(header);
        ArrayList<DropdownProperties> dropdownPropertiesList = new ArrayList<DropdownProperties>();
        int j = 0;
        for (int i = 0; i < properties.size(); ++i) {
            if (properties.get(i).equals("DATE")) continue;
            dropdownPropertiesList.add(new DropdownProperties(j, properties.get(i), j, units[i]));
            ++j;
        }
        DataMinerResults dataMinerResults = new DataMinerResults(dropdownPropertiesList, allData);
        System.out.println(link);
        return ResponseEntity.ok((Object)dataMinerResults);
    }
}

