/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.aginfra.data.analytics.visualization.service.controllers;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import gr.uoa.di.aginfra.data.analytics.visualization.model.config.NetworkGraphConfig;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.netgraph.NetworkGraph;
import gr.uoa.di.aginfra.data.analytics.visualization.model.helpers.GraphVisualizationHelper;
import gr.uoa.di.aginfra.data.analytics.visualization.model.services.NetworkGraphService;
import gr.uoa.di.aginfra.data.analytics.visualization.service.dtos.netgraph.NetworkGraphDto;
import gr.uoa.di.aginfra.data.analytics.visualization.service.dtos.netgraph.PropertyValuesDto;
import gr.uoa.di.aginfra.data.analytics.visualization.service.mappers.EntityMapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ForkJoinPool;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.context.request.async.DeferredResult;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@Controller
@CrossOrigin(exposedHeaders={"Location"})
@RequestMapping(value={"/graph"})
public class NetworkGraphController {
    private static final Logger logger = LogManager.getLogger(NetworkGraphController.class);
    protected static final String NETWORK_GRAPH_BASE_PATH = "graph";
    private NetworkGraphService networkGraphService;
    private EntityMapper modelMapper;
    private static final ObjectMapper mapper = new ObjectMapper();
    private NetworkGraphConfig networkGraphConfig;

    @Autowired
    public NetworkGraphController(NetworkGraphService networkGraphService, EntityMapper modelMapper, NetworkGraphConfig networkGraphConfig) {
        this.networkGraphService = networkGraphService;
        this.modelMapper = modelMapper;
        this.networkGraphConfig = networkGraphConfig;
    }

    @RequestMapping(value={"file"}, method={RequestMethod.POST}, consumes={"multipart/form-data"}, produces={"application/json"})
    public ResponseEntity<?> importDataFile(@RequestParam(value="file") MultipartFile file, @RequestParam(value="name") String graphName, @RequestParam(value="privacy") String privacy, @RequestParam(value="username") String username) throws Exception {
        DeferredResult output = new DeferredResult();
        ForkJoinPool.commonPool().submit(() -> {
            try {
                NetworkGraphDto networkGraphDto = (NetworkGraphDto)mapper.readValue(file.getBytes(), NetworkGraphDto.class);
                NetworkGraph networkGraph = this.modelMapper.map(networkGraphDto, graphName, username, privacy);
                int results = 0;
                results = this.networkGraphService.storeNetworkGraph(networkGraph);
                if (results > 0) {
                    // empty if block
                }
                System.out.println("Im here but after");
                UriComponents uriComponents = UriComponentsBuilder.newInstance().path("graph/{id}").buildAndExpand(new Object[]{networkGraph.getGraphId()});
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        System.out.println("servlet thread freed");
        return new ResponseEntity(HttpStatus.OK);
    }

    @RequestMapping(value={"graphs"}, method={RequestMethod.GET}, produces={"application/json"})
    ResponseEntity<?> getAvailableGraphs() {
        try {
            List result = this.networkGraphService.getAllGraphsByTenant("tenant");
            return new ResponseEntity((Object)result, HttpStatus.OK);
        }
        catch (IOException e) {
            e.printStackTrace();
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"graphs/{subGraphId}"}, method={RequestMethod.GET}, produces={"application/json"})
    ResponseEntity<?> getTopNodes(@PathVariable String subGraphId, @RequestParam(value="number") int number) {
        try {
            List results = this.networkGraphService.getTopNodesOfGraph(subGraphId, number);
            Map d3Results = GraphVisualizationHelper.nodesToD3Format((Collection)results, (boolean)true, (String)subGraphId);
            System.out.println(d3Results);
            return new ResponseEntity((Object)d3Results, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"neighbors/{subGraphId}/{nodeId}"}, method={RequestMethod.GET}, produces={"application/json"})
    ResponseEntity<?> getNeighbors(@PathVariable String subGraphId, @PathVariable String nodeId) {
        try {
            List results = this.networkGraphService.getNeighborNodes(subGraphId, nodeId);
            Map d3Results = GraphVisualizationHelper.neighborsNodesToD3Format((Collection)results, (String)nodeId, (boolean)false, (String)subGraphId);
            return new ResponseEntity((Object)d3Results, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"next/{id}"}, method={RequestMethod.GET}, produces={"application/json"})
    ResponseEntity<?> getNextTimeSubgraph(@PathVariable(value="id") String graphId, @RequestParam(value="nodes[]") String[] nodes, @RequestParam(value="date") String currentDate) {
        List<String> nodeList = Arrays.asList(nodes);
        try {
            Map result = this.networkGraphService.getNextTimestampSubGraph(graphId, nodeList, currentDate);
            return new ResponseEntity((Object)result, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"dates/{id}"}, method={RequestMethod.POST}, consumes={"application/json;charset=UTF-8"})
    ResponseEntity<?> getCurrentTimeSubgraph(@PathVariable(value="id") String graphId, @RequestBody Map<String, Object> request) {
        try {
            List<Object> nodeList = Arrays.asList((Object[])mapper.convertValue(request.get("nodes"), (TypeReference)new /* Unavailable Anonymous Inner Class!! */));
            List result = this.networkGraphService.getCurrentTimestampGraph(graphId, nodeList, request.get("date").toString());
            Map d3Results = GraphVisualizationHelper.hasWeightToD3Format((Collection)result, (String)graphId, (NetworkGraphService)this.networkGraphService, (NetworkGraphConfig)this.networkGraphConfig);
            return new ResponseEntity((Object)d3Results, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"timestamps/{graphId}"}, method={RequestMethod.GET})
    ResponseEntity<?> getTimestamps(@PathVariable(value="graphId") String graphId) {
        List results = null;
        try {
            results = this.networkGraphService.getAllTimestamps(graphId);
            results = GraphVisualizationHelper.datesToDateStrings((List)results);
            return new ResponseEntity((Object)results, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"filtered/{graphId}"}, method={RequestMethod.GET})
    ResponseEntity<?> getFilteredGraph(@PathVariable(value="graphId") String graphId, @RequestParam Map<String, String> allRequestParams, @RequestParam(value="nodesNumber") Integer nodesNumber) {
        try {
            allRequestParams.remove("nodesNumber");
            List result = this.networkGraphService.getFilteredGraph(graphId, allRequestParams, nodesNumber);
            Map d3Results = GraphVisualizationHelper.nodesToD3Format((Collection)result, (boolean)true, (String)graphId);
            System.out.println(d3Results.get("nodes"));
            System.out.println(d3Results.get("links"));
            return new ResponseEntity((Object)d3Results, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"properties/{graphId}"})
    ResponseEntity<?> getPropertyValues(@PathVariable(value="graphId") String graphId, @RequestParam(value="property") String property) {
        List result = this.networkGraphService.getPropertyValues(property, graphId);
        List resultProperties = IntStream.range(0, result.size()).mapToObj(i -> new PropertyValuesDto(i, (String)result.get(i), (String)result.get(i))).collect(Collectors.toList());
        return new ResponseEntity(resultProperties, HttpStatus.OK);
    }

    @RequestMapping(value={"graphs/{graphId}"}, method={RequestMethod.DELETE})
    ResponseEntity<?> deleteSubGraph(@PathVariable(value="graphId") String graphId) {
        String result = this.networkGraphService.deleteSubGraph(graphId);
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }
}

