/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.aginfra.data.analytics.visualization.service.mappers;

import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.Configuration;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.netgraph.Edge;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.netgraph.NetworkGraph;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.netgraph.Node;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.Visualization;
import gr.uoa.di.aginfra.data.analytics.visualization.service.dtos.ConfigurationDto;
import gr.uoa.di.aginfra.data.analytics.visualization.service.dtos.VisualizationDto;
import gr.uoa.di.aginfra.data.analytics.visualization.service.dtos.netgraph.NetworkGraphDto;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bson.types.ObjectId;
import org.modelmapper.Converter;
import org.modelmapper.ModelMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EntityMapper {
    private ModelMapper modelMapper;
    public static Converter<ObjectId, String> objectIdToStringConverter = new /* Unavailable Anonymous Inner Class!! */;
    public static Converter<String, ObjectId> stringToObjectIdConverter = new /* Unavailable Anonymous Inner Class!! */;

    @Autowired
    public EntityMapper(ModelMapper modelMapper) {
        this.modelMapper = modelMapper;
        this.modelMapper.addConverter(objectIdToStringConverter);
        this.modelMapper.addConverter(stringToObjectIdConverter);
    }

    public ConfigurationDto map(Configuration entity) {
        return (ConfigurationDto)this.modelMapper.map((Object)entity, ConfigurationDto.class);
    }

    public Configuration map(ConfigurationDto dto) {
        return (Configuration)this.modelMapper.map((Object)dto, Configuration.class);
    }

    public VisualizationDto map(Visualization entity) {
        return (VisualizationDto)this.modelMapper.map((Object)entity, VisualizationDto.class);
    }

    public Visualization map(VisualizationDto dto) {
        return (Visualization)this.modelMapper.map((Object)dto, Visualization.class);
    }

    public NetworkGraph map(NetworkGraphDto dto, String graphName, String tenantName, String privacy) {
        UUID uuid = UUID.randomUUID();
        String graphId = uuid.toString();
        Map nodeMap = dto.getNodes().stream().map((? super T node) -> new Node(node.getId(), node.getX(), node.getY(), node.getAttributes(), graphId, graphName, tenantName, privacy)).collect(Collectors.toMap(Node::getNodeId, Function.identity()));
        List edges = dto.getEdges().stream().map((? super T edge) -> new Edge(edge.getId(), (Node)nodeMap.get(edge.getSource()), (Node)nodeMap.get(edge.getTarget()), edge.getAtributes(), graphId, graphName, tenantName)).collect(Collectors.toList());
        NetworkGraph networkGraph = new NetworkGraph(nodeMap, edges);
        return networkGraph;
    }
}

