/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.config.endpoint;

import gr.uoa.di.madgik.config.exceptions.ServiceDiscoveryException;
import gr.uoa.di.madgik.config.service.ServiceDiscovery;
import gr.uoa.di.madgik.config.service.ServiceProfile;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointManager {
    private static Map<String, Map<ServiceProfile, Set<String>>> serviceEndpoints = new HashMap();
    private static Object serviceLock = new Object();
    private static long REFRESH_INTERVAL;
    private static Date lastUpdated;
    private static Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EndpointManager() {
        Properties prop = new Properties();
        InputStream input = null;
        try {
            input = Thread.currentThread().getContextClassLoader().getResourceAsStream("configuration.properties");
            prop.load(input);
            REFRESH_INTERVAL = Long.parseLong((String)prop.get("cache.refresh.interval"));
        }
        catch (IOException ex) {
            logger.error("Could not load properties file");
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    logger.error("Could not close properties file");
                }
            }
        }
        logger.info("Initiliazing Endpoint Manager with refresh interval " + REFRESH_INTERVAL + " minutes");
    }

    private void discoverServiceEndpoints(String scope, ServiceProfile serviceProfile) throws ServiceDiscoveryException {
        logger.info("Discovering service endpoints for scope " + scope);
        Set endpoints = ServiceDiscovery.discoverServiceEndpoints((String)scope, (ServiceProfile)serviceProfile);
        ((Map)serviceEndpoints.get(scope)).put(serviceProfile, endpoints);
        logger.info("Discovered " + endpoints.size() + " service endpoints for scope " + scope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getServiceEndpoints(String scope, ServiceProfile serviceProfile) throws ServiceDiscoveryException {
        ArrayList<String> asynchronizedEndpoints;
        Object object = serviceLock;
        synchronized (object) {
            boolean serviceNotExists;
            boolean scopeNotExists;
            boolean bl = scopeNotExists = !serviceEndpoints.containsKey(scope);
            boolean bl2 = scopeNotExists ? true : (serviceNotExists = !((Map)serviceEndpoints.get(scope)).containsKey(serviceProfile));
            boolean hasNotEndpoints = serviceNotExists ? true : ((Set)((Map)serviceEndpoints.get(scope)).get(serviceProfile)).size() == 0;
            boolean needsRefresh = this.needsRefresh();
            if (scopeNotExists) {
                serviceEndpoints.put(scope, new HashMap());
            }
            if (serviceNotExists || hasNotEndpoints || needsRefresh) {
                this.discoverServiceEndpoints(scope, serviceProfile);
            }
            Set endpoints = (Set)((Map)serviceEndpoints.get(scope)).get(serviceProfile);
            asynchronizedEndpoints = new ArrayList<String>(endpoints);
        }
        Collections.shuffle(asynchronizedEndpoints);
        logger.info("Returned " + asynchronizedEndpoints.size() + " service endpoint(s)");
        return asynchronizedEndpoints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServiceEndpoint(String scope, ServiceProfile serviceProfile, String endpoint) {
        Object object = serviceLock;
        synchronized (object) {
            if (((Set)((Map)serviceEndpoints.get(scope)).get(serviceProfile)).contains(endpoint)) {
                logger.info("Removing endpoint " + endpoint + " from cache.");
                ((Set)((Map)serviceEndpoints.get(scope)).get(serviceProfile)).remove(endpoint);
            }
        }
    }

    private boolean needsRefresh() {
        Date now = new Date();
        long duration = now.getTime() - lastUpdated.getTime();
        long diffInMinutes = TimeUnit.MILLISECONDS.toMinutes(duration);
        return diffInMinutes > REFRESH_INTERVAL;
    }

    static {
        lastUpdated = new Date();
        logger = LoggerFactory.getLogger(EndpointManager.class);
    }
}

