/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.index.publisher.oaipmh.verbs;

import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.UriInfo;
import org.apache.log4j.Logger;
import org.gcube.rest.index.publisher.RecordsResponse;
import org.gcube.rest.index.publisher.oaipmh.repository.FlowControl;
import org.gcube.rest.index.publisher.oaipmh.repository.Record;
import org.gcube.rest.index.publisher.oaipmh.repository.Repository;
import org.gcube.rest.index.publisher.oaipmh.repository.RepositoryRegistrationException;
import org.gcube.rest.index.publisher.oaipmh.repository.ResumptionToken;
import org.gcube.rest.index.publisher.oaipmh.repository.SetSpec;
import org.gcube.rest.index.publisher.oaipmh.utils.UTCDatetime;
import org.gcube.rest.index.publisher.oaipmh.utils.XMLUtils;
import org.gcube.rest.index.publisher.oaipmh.verbs.Verb;
import org.gcube.rest.index.publisher.oaipmh.verbs.errors.BadArgumentError;
import org.gcube.rest.index.publisher.oaipmh.verbs.errors.BadResumptionTokenError;
import org.gcube.rest.index.publisher.oaipmh.verbs.errors.CannotDisseminateFormatError;
import org.gcube.rest.index.publisher.oaipmh.verbs.errors.ErrorCondition;
import org.gcube.rest.index.publisher.oaipmh.verbs.errors.NoRecordsMatchError;
import org.gcube.rest.index.publisher.oaipmh.verbs.errors.NoSetHierarchyError;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ListIdentifiers
extends Verb {
    protected static Logger logger = Logger.getLogger((String)ListIdentifiers.class.getName());
    protected UTCDatetime from = null;
    protected UTCDatetime until = null;
    protected String metadataPrefix;
    protected SetSpec set = null;
    protected String resumptionToken = null;
    protected String requestURL;

    public void setResumptionToken(String resumptionToken) {
        this.resumptionToken = resumptionToken;
    }

    public void localInitializeRootElement() {
        logger.debug((Object)"localInitializeRootElement");
        super.initializeRootElement();
        Element rootElement = this.xmlDocument.getDocumentElement();
        Element requestElement = this.xmlDocument.createElement("request");
        requestElement.setAttribute("verb", "ListIdentifiers");
        if (this.metadataPrefix != null) {
            requestElement.setAttribute("metadataPrefix", this.metadataPrefix);
        }
        if (this.from != null) {
            requestElement.setAttribute("from", this.from.getDatetimeAsString());
        }
        if (this.until != null) {
            requestElement.setAttribute("until", this.until.getDatetimeAsString());
        }
        if (this.set != null) {
            requestElement.setAttribute("set", this.set.toString());
        }
        if (this.resumptionToken != null) {
            requestElement.setAttribute("resumptionToken", this.resumptionToken);
            FlowControl flowControl = FlowControl.getInstance();
            ResumptionToken token = flowControl.getResumptionToken(this.resumptionToken);
            this.metadataPrefix = token.getMetadataPrefix();
            this.from = token.getFrom();
            this.until = token.getUntil();
            this.set = token.getSet();
        }
        requestElement.setTextContent(this.requestURL);
        rootElement.appendChild(requestElement);
    }

    public String response(Repository repository) {
        logger.debug((Object)"response");
        this.localInitializeRootElement();
        if (this.hasErrors()) {
            this.appendErrorNodes();
        } else {
            List records;
            Element rootElement = this.xmlDocument.getDocumentElement();
            RecordsResponse recordsResponse = null;
            try {
                recordsResponse = this.getRecords(repository);
                records = recordsResponse.getRecords();
            }
            catch (RepositoryRegistrationException e1) {
                logger.error((Object)e1);
                records = null;
            }
            if (this.hasErrors()) {
                this.appendErrorNodes();
            } else {
                FlowControl flowControl;
                ResumptionToken token;
                Element listIdentifiersElement = this.xmlDocument.createElement("ListIdentifiers");
                for (Record record : records) {
                    listIdentifiersElement.appendChild(this.xmlDocument.importNode(record.getHeaderAsXMLElement(), true));
                }
                if (this.resumptionToken != null && (token = (flowControl = FlowControl.getInstance()).getResumptionToken(this.resumptionToken)) != null) {
                    listIdentifiersElement.appendChild(this.xmlDocument.importNode(token.getXMLElement(records.size()), true));
                    try {
                        Verb.handleResumptionToken((ResumptionToken)token, (int)records.size(), (String)recordsResponse.getScrollId());
                    }
                    catch (BadResumptionTokenError ex) {
                        this.addError((ErrorCondition)ex);
                        logger.error((Object)ex);
                    }
                    if (token.getMetadataPrefix().equals("")) {
                        token.setFrom(this.from);
                        token.setMetadataPrefix(this.metadataPrefix);
                        token.setSet(this.set);
                        token.setUntil(this.until);
                    }
                }
                rootElement.appendChild(listIdentifiersElement);
            }
        }
        try {
            return XMLUtils.transformDocumentToString((Document)this.xmlDocument);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            return null;
        }
    }

    public void setAttributes(UriInfo req) {
        logger.debug((Object)"setAttributes");
        this.requestURL = req.getAbsolutePath().toString();
        MultivaluedHashMap parameters = new MultivaluedHashMap();
        for (Map.Entry queryParam : req.getQueryParameters().entrySet()) {
            for (String queryParamValue : (List)queryParam.getValue()) {
                parameters.add(queryParam.getKey(), (Object)queryParamValue);
            }
        }
        if (parameters.containsKey((Object)"resumptionToken")) {
            this.resumptionToken = (String)parameters.getFirst((Object)"resumptionToken");
            ResumptionToken token = FlowControl.getInstance().getResumptionToken(this.resumptionToken);
            if (token == null) {
                this.addError((ErrorCondition)new BadResumptionTokenError("resumtionToken does not exist"));
                this.resumptionToken = null;
                return;
            }
            if (token.isExpired()) {
                FlowControl.getInstance().unregister(token);
                this.addError((ErrorCondition)new BadResumptionTokenError("resumtionToken has expired"));
                this.resumptionToken = null;
                return;
            }
            parameters.remove((Object)"resumptionToken");
        } else {
            if (parameters.containsKey((Object)"from")) {
                this.from = new UTCDatetime((String)parameters.getFirst((Object)"from"));
                parameters.remove((Object)"from");
            }
            if (parameters.containsKey((Object)"until")) {
                this.until = new UTCDatetime((String)parameters.getFirst((Object)"until"));
                parameters.remove((Object)"until");
            }
            if (!parameters.containsKey((Object)"metadataPrefix")) {
                this.addError((ErrorCondition)new BadArgumentError("There was no metadataPrefix"));
                return;
            }
            this.metadataPrefix = (String)parameters.getFirst((Object)"metadataPrefix");
            parameters.remove((Object)"metadataPrefix");
            if (parameters.containsKey((Object)"set")) {
                this.set = new SetSpec((String)parameters.getFirst((Object)"set"));
                parameters.remove((Object)"set");
            }
        }
        parameters.remove((Object)"verb");
        if (parameters.size() > 0) {
            this.addError((ErrorCondition)new BadArgumentError("There are extra parameters"));
        }
    }

    protected RecordsResponse getRecords(Repository repository) throws RepositoryRegistrationException {
        logger.debug((Object)"getRecords");
        try {
            if (this.until == null && this.from == null && this.set == null && this.resumptionToken == null) {
                return repository.getRecords(this.metadataPrefix, this);
            }
            if (this.until != null || this.from != null && this.set == null && this.resumptionToken == null) {
                return repository.getRecords(this.from, this.until, this.metadataPrefix);
            }
            if (this.until == null && this.from == null && this.set != null && this.resumptionToken == null) {
                return repository.getRecords(this.metadataPrefix, this.set, this);
            }
            if (this.until == null && this.from == null && this.set == null && this.resumptionToken != null) {
                return repository.getRecords(this.metadataPrefix, FlowControl.getInstance().getResumptionToken(this.resumptionToken));
            }
            if (this.until == null && this.from == null && this.set != null && this.resumptionToken != null) {
                return repository.getRecords(this.metadataPrefix, FlowControl.getInstance().getResumptionToken(this.resumptionToken), this.set);
            }
            return repository.getRecords(this.from, this.until, this.metadataPrefix, FlowControl.getInstance().getResumptionToken(this.resumptionToken), this.set);
        }
        catch (CannotDisseminateFormatError e) {
            this.addError((ErrorCondition)e);
            logger.info((Object)("ErrorCondition: " + e.getCode()));
        }
        catch (NoRecordsMatchError e) {
            this.addError((ErrorCondition)e);
            logger.info((Object)("ErrorCondition: " + e.getCode()));
        }
        catch (NoSetHierarchyError e) {
            this.addError((ErrorCondition)e);
            logger.info((Object)("ErrorCondition: " + e.getCode()));
        }
        catch (BadResumptionTokenError e) {
            this.addError((ErrorCondition)e);
            logger.info((Object)("ErrorCondition: " + e.getCode()));
        }
        return null;
    }
}

