/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.index.publisher.oaipmh.verbs;

import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.UriInfo;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.gcube.rest.index.publisher.oaipmh.repository.FlowControl;
import org.gcube.rest.index.publisher.oaipmh.repository.Repository;
import org.gcube.rest.index.publisher.oaipmh.repository.ResumptionToken;
import org.gcube.rest.index.publisher.oaipmh.repository.SetSpec;
import org.gcube.rest.index.publisher.oaipmh.utils.XMLUtils;
import org.gcube.rest.index.publisher.oaipmh.verbs.Verb;
import org.gcube.rest.index.publisher.oaipmh.verbs.errors.BadArgumentError;
import org.gcube.rest.index.publisher.oaipmh.verbs.errors.BadResumptionTokenError;
import org.gcube.rest.index.publisher.oaipmh.verbs.errors.ErrorCondition;
import org.gcube.rest.index.publisher.oaipmh.verbs.errors.NoSetHierarchyError;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ListSets
extends Verb {
    protected static Logger logger = Logger.getLogger((String)ListSets.class.getName());
    private String resumptionToken = null;
    private String requestURL;

    public void initializeRootElement() {
        logger.debug((Object)"initializeRootElement");
        super.initializeRootElement();
        Element rootElement = this.xmlDocument.getDocumentElement();
        Element requestElement = this.xmlDocument.createElement("request");
        requestElement.setAttribute("verb", "ListSets");
        if (this.resumptionToken != null) {
            requestElement.setAttribute("resumptionToken", this.resumptionToken);
        }
        requestElement.setTextContent(this.requestURL);
        rootElement.appendChild(requestElement);
    }

    public String response(Repository repository) {
        logger.debug((Object)"response");
        this.initializeRootElement();
        if (this.hasErrors()) {
            this.appendErrorNodes();
        } else {
            Element rootElement = this.xmlDocument.getDocumentElement();
            List setSpecs = null;
            try {
                setSpecs = this.resumptionToken == null ? repository.getSetSpecs() : repository.getSetSpecs(FlowControl.getInstance().getResumptionToken(this.resumptionToken));
            }
            catch (NoSetHierarchyError e) {
                this.addError((ErrorCondition)e);
            }
            catch (BadResumptionTokenError e) {
                this.addError((ErrorCondition)e);
            }
            if (this.hasErrors()) {
                this.appendErrorNodes();
            } else {
                FlowControl flowControl;
                ResumptionToken token;
                Element listSetsElement = this.xmlDocument.createElement("ListSets");
                for (SetSpec setSpec : setSpecs) {
                    try {
                        listSetsElement.appendChild(this.xmlDocument.importNode(setSpec.getXMLElement(), true));
                    }
                    catch (DOMException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    catch (ParserConfigurationException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                if (this.resumptionToken != null && (token = (flowControl = FlowControl.getInstance()).getResumptionToken(this.resumptionToken)) != null) {
                    listSetsElement.appendChild(this.xmlDocument.importNode(token.getXMLElement(setSpecs.size()), true));
                    try {
                        Verb.handleResumptionToken((ResumptionToken)token, (int)setSpecs.size(), (String)"");
                    }
                    catch (BadResumptionTokenError ex) {
                        this.addError((ErrorCondition)ex);
                        logger.info((Object)ex);
                    }
                }
                rootElement.appendChild(listSetsElement);
            }
        }
        try {
            return XMLUtils.transformDocumentToString((Document)this.xmlDocument);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            return null;
        }
    }

    public void setAttributes(UriInfo req) {
        logger.debug((Object)"setAttributes");
        this.requestURL = req.getAbsolutePath().toString();
        MultivaluedHashMap parameters = new MultivaluedHashMap();
        for (Map.Entry queryParam : req.getQueryParameters().entrySet()) {
            for (String queryParamValue : (List)queryParam.getValue()) {
                parameters.add(queryParam.getKey(), (Object)queryParamValue);
            }
        }
        if (parameters.containsKey((Object)"resumptionToken")) {
            this.resumptionToken = (String)parameters.getFirst((Object)"resumptionToken");
            ResumptionToken token = FlowControl.getInstance().getResumptionToken(this.resumptionToken);
            if (token == null) {
                this.addError((ErrorCondition)new BadResumptionTokenError("resumtionToken does not exist"));
                this.resumptionToken = null;
                return;
            }
            if (token.isExpired()) {
                FlowControl.getInstance().unregister(token);
                this.addError((ErrorCondition)new BadResumptionTokenError("resumtionToken has expired"));
                this.resumptionToken = null;
                return;
            }
            parameters.remove((Object)"resumptionToken");
        }
        parameters.remove((Object)"verb");
        if (parameters.size() > 0) {
            this.addError((ErrorCondition)new BadArgumentError());
        }
    }
}

