/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.index.publisher.oaipmh.repository;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.gcube.rest.index.publisher.oaipmh.repository.FlowControl;
import org.gcube.rest.index.publisher.oaipmh.repository.SetSpec;
import org.gcube.rest.index.publisher.oaipmh.utils.UTCDatetime;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ResumptionToken {
    private final String resumptionToken;
    private long completeListSize;
    private UTCDatetime expirationDate;
    private int cursor;
    private String scrollId;
    private String metadataPrefix = "";
    private SetSpec set = null;
    protected UTCDatetime from = null;
    protected UTCDatetime until = null;
    private Document xmlDocument;

    public ResumptionToken() {
        String resumptionToken = this.randomAlphaNumeric(10);
        while (FlowControl.getInstance().getResumptionToken(resumptionToken) != null) {
            resumptionToken = this.randomAlphaNumeric(10);
        }
        this.resumptionToken = resumptionToken;
        FlowControl.getInstance().register(this);
        this.initXML();
    }

    public ResumptionToken(String resumptionToken) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getResumptionToken() {
        return this.resumptionToken;
    }

    public void setCursor(int cursor) {
        this.cursor = cursor;
    }

    public int getCursor() {
        return this.cursor;
    }

    public String getScrollId() {
        return this.scrollId;
    }

    public void setScrollId(String scrollId) {
        this.scrollId = scrollId;
    }

    public void setExpirationDate(UTCDatetime expirationDate) {
        this.expirationDate = expirationDate;
    }

    public UTCDatetime getExpirationDate() {
        return this.expirationDate;
    }

    public void setCompleteListSize(long completeListSize) {
        this.completeListSize = completeListSize;
    }

    public long getCompleteListSize() {
        return this.completeListSize;
    }

    public void setMetadataPrefix(String metadataPrefix) {
        this.metadataPrefix = metadataPrefix;
    }

    public void setSet(SetSpec set) {
        this.set = set;
    }

    public void setFrom(UTCDatetime from) {
        this.from = from;
    }

    public void setUntil(UTCDatetime until) {
        this.until = until;
    }

    public String getMetadataPrefix() {
        return this.metadataPrefix;
    }

    public SetSpec getSet() {
        return this.set;
    }

    public UTCDatetime getFrom() {
        return this.from;
    }

    public UTCDatetime getUntil() {
        return this.until;
    }

    public boolean isExpired() {
        ZonedDateTime datetime = ZonedDateTime.now(ZoneId.systemDefault());
        UTCDatetime current_datetime = new UTCDatetime(datetime);
        return !current_datetime.isBefore(this.expirationDate);
    }

    private void initXML() {
        Logger.getLogger((String)ResumptionToken.class.getName()).log((Priority)Level.DEBUG, (Object)"initXML");
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.xmlDocument = builder.newDocument();
        }
        catch (ParserConfigurationException e) {
            Logger.getLogger((String)ResumptionToken.class.getName()).log((Priority)Level.ERROR, null, (Throwable)e);
        }
    }

    public Element getXMLElement(int returnedListFromRepositorySize) {
        Logger.getLogger((String)ResumptionToken.class.getName()).log((Priority)Level.DEBUG, (Object)"getXMLElement");
        Element recordElement = this.xmlDocument.createElement("resumptionToken");
        recordElement.setAttribute("expirationDate", this.expirationDate.getDatetimeAsString());
        recordElement.setAttribute("completeListSize", String.valueOf(this.completeListSize));
        recordElement.setAttribute("cursor", String.valueOf(this.cursor));
        if ((long)(this.cursor + returnedListFromRepositorySize) < this.completeListSize) {
            recordElement.setTextContent(this.resumptionToken);
        }
        return recordElement;
    }

    public String toString() {
        return this.resumptionToken;
    }

    private String randomAlphaNumeric(int count) {
        Logger.getLogger((String)ResumptionToken.class.getName()).log((Priority)Level.DEBUG, (Object)"randomAlphaNumeric");
        String ALPHA_NUMERIC_STRING = "abcdefghijklmnopqrstuvwxyz0123456789";
        StringBuilder builder = new StringBuilder();
        while (count-- != 0) {
            int character = (int)(Math.random() * (double)ALPHA_NUMERIC_STRING.length());
            builder.append(ALPHA_NUMERIC_STRING.charAt(character));
        }
        return builder.toString();
    }
}

