/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.index.publisher;

import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.gcube.rest.index.client.ClientFactory;
import org.gcube.rest.index.client.cache.IndexClient;
import org.gcube.rest.index.client.exceptions.NoAvailableIndexServiceInstance;
import org.gcube.rest.index.common.entities.CollectionInfo;
import org.gcube.rest.index.common.search.Query;
import org.gcube.rest.index.common.search.Search_Response;

public class IndexAdapterAPI {
    private static IndexClient client;
    private static String scope;
    private int limit;
    private Logger logger = Logger.getLogger((String)IndexAdapterAPI.class.getName());

    public IndexAdapterAPI(int limit) {
        this.limit = limit;
    }

    public void createClient(String scope) {
        client = ClientFactory.getMeAnIndexClient((String)scope);
        IndexAdapterAPI.scope = scope;
    }

    public Search_Response getRecord(String id) {
        Query query = new Query();
        query.setRecordId(id);
        query.setSearchMode(Query.SearchMode.ID);
        try {
            Search_Response searchResponce = client.search(query, scope);
            return searchResponce;
        }
        catch (NoAvailableIndexServiceInstance e) {
            this.logger.debug((Object)("There is no record with id = " + id));
            return null;
        }
    }

    public Search_Response getRecords(int daysToExpireForResumptionToken) {
        try {
            List availableDatasources = client.getCompleteCollectionInfo("", scope);
            Query query = new Query();
            for (CollectionInfo colInfo : availableDatasources) {
                query.add_SearchTerm(colInfo.getId(), "*");
            }
            query.setSearchMode(Query.SearchMode.SCROLL);
            query.setSize_paging(this.limit);
            query.setScrollId(null);
            query.setTimeLimit((long)daysToExpireForResumptionToken);
            Search_Response searchResponce = client.search(query, scope);
            return searchResponce;
        }
        catch (NoAvailableIndexServiceInstance e) {
            this.logger.debug((Object)"There are no records");
            return null;
        }
    }

    public Search_Response getScrolledRecords(String scrollId, int daysToExpireForResumptionToken) {
        Query query = new Query();
        query.setScrollId(scrollId);
        query.setSearchMode(Query.SearchMode.SCROLL);
        query.setTimeLimit((long)daysToExpireForResumptionToken);
        try {
            Search_Response searchResponce = client.search(query, scope);
            return searchResponce;
        }
        catch (NoAvailableIndexServiceInstance e) {
            this.logger.debug((Object)"There are no records");
            return null;
        }
    }

    public Search_Response getRecords(String datasourceId, int daysToExpireForResumptionToken) {
        Query query = new Query();
        query.add_SearchTerm(datasourceId, "*");
        query.setSearchMode(Query.SearchMode.SCROLL);
        query.setSize_paging(this.limit);
        query.setScrollId(null);
        query.setTimeLimit((long)daysToExpireForResumptionToken);
        try {
            Search_Response searchResponce = client.search(query, scope);
            return searchResponce;
        }
        catch (NoAvailableIndexServiceInstance e) {
            this.logger.debug((Object)"There are no records");
            return null;
        }
    }

    public Search_Response getRecords(String datasourceId, String scrollId, int daysToExpireForResumptionToken) {
        Query query = new Query();
        query.setScrollId(scrollId);
        query.setSearchMode(Query.SearchMode.SCROLL);
        query.setTimeLimit((long)daysToExpireForResumptionToken);
        try {
            Search_Response searchResponce = client.search(query, scope);
            return searchResponce;
        }
        catch (NoAvailableIndexServiceInstance e) {
            this.logger.debug((Object)"There are no records");
            return null;
        }
    }

    public long getRecordsNumber() {
        try {
            List availableDatasources = client.getCompleteCollectionInfo("", scope);
            Query query = new Query();
            for (CollectionInfo colInfo : availableDatasources) {
                query.add_SearchTerm(colInfo.getId(), "*");
            }
            query.setPosition_paging(0);
            query.setSize_paging(this.limit);
            Search_Response searchResponce = client.search(query, scope);
            return searchResponce.getTotalHits();
        }
        catch (NoAvailableIndexServiceInstance e) {
            this.logger.debug((Object)"There are no records");
            return 0L;
        }
    }

    public long getRecordsNumber(String datasourceId) {
        Query query = new Query();
        query.add_SearchTerm(datasourceId, "*");
        query.setPosition_paging(0);
        query.setSize_paging(this.limit);
        try {
            Search_Response searchResponce = client.search(query, scope);
            return searchResponce.getTotalHits();
        }
        catch (NoAvailableIndexServiceInstance e) {
            this.logger.debug((Object)"There are no records");
            return 0L;
        }
    }

    public List<CollectionInfo> getDatasources() {
        try {
            return client.getCompleteCollectionInfo("", scope);
        }
        catch (NoAvailableIndexServiceInstance e) {
            this.logger.debug((Object)"There are no datasources");
            return null;
        }
    }

    public CollectionInfo getDatasource(String datasourceId) {
        try {
            return (CollectionInfo)client.getCompleteCollectionInfo(datasourceId, scope).get(0);
        }
        catch (NoAvailableIndexServiceInstance e) {
            this.logger.debug((Object)"There are no datasources");
            return null;
        }
    }

    public Map<String, Map<String, String>> getMapAliases() {
        try {
            return client.getCollectionFieldsAlias("", false, scope);
        }
        catch (NoAvailableIndexServiceInstance e) {
            this.logger.debug((Object)"There are no aliases available");
            return null;
        }
    }
}

