/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.index.publisher.oaipmh.repository;

import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.gcube.rest.index.publisher.oaipmh.metadata.Metadata;
import org.gcube.rest.index.publisher.oaipmh.repository.SetSpec;
import org.gcube.rest.index.publisher.oaipmh.utils.UTCDatetime;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Record {
    protected static Logger logger = Logger.getLogger((String)Record.class.getName());
    private final String id;
    private final String metadataPrefix;
    private Metadata metadata;
    private UTCDatetime datetime;
    private boolean isDeleted = false;
    private List<SetSpec> setSpecs = new ArrayList();
    private Document xmlDocument;
    public Element aboutElement = null;

    public Record(String id, String metadataPrefix) {
        this.id = id;
        this.metadataPrefix = metadataPrefix;
        this.initXML();
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public String getId() {
        return this.id;
    }

    public List<SetSpec> getSetSpecs() {
        return this.setSpecs;
    }

    public void setSetSpecs(List<SetSpec> setSpecs) {
        this.setSpecs = setSpecs;
    }

    public UTCDatetime getDatetime() {
        if (this.datetime == null) {
            this.datetime = new UTCDatetime(UTCDatetime.now());
            return this.datetime;
        }
        return this.datetime;
    }

    public void setDatetime(UTCDatetime datetime) {
        this.datetime = datetime;
    }

    public String getMetadataPrefix() {
        return this.metadataPrefix;
    }

    private void initXML() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.xmlDocument = builder.newDocument();
        }
        catch (ParserConfigurationException e) {
            logger.error((Object)e);
        }
    }

    public Element getXMLElement() {
        logger.debug((Object)"getXMLElement");
        Element recordElement = this.xmlDocument.createElement("record");
        recordElement.appendChild(this.getHeaderAsXMLElement());
        Element metadataElement = this.xmlDocument.createElement("metadata");
        try {
            metadataElement.appendChild(this.xmlDocument.importNode(this.metadata.getXMLElement(), true));
        }
        catch (DOMException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        recordElement.appendChild(metadataElement);
        if (this.aboutElement != null) {
            recordElement.appendChild(this.aboutElement);
        }
        return recordElement;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public void setDeleted(boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    public Element getHeaderAsXMLElement() {
        logger.debug((Object)"getHeaderAsXMLElement");
        Element headerElement = this.xmlDocument.createElement("header");
        if (this.isDeleted) {
            headerElement.setAttribute("status", "deleted");
        }
        Element idElement = this.xmlDocument.createElement("identifier");
        idElement.setTextContent(this.id);
        headerElement.appendChild(idElement);
        Element datestampElement = this.xmlDocument.createElement("datestamp");
        datestampElement.setTextContent(this.getDatetime().getDatetimeAsString());
        headerElement.appendChild(datestampElement);
        for (SetSpec setSpec : this.setSpecs) {
            Element setElement = this.xmlDocument.createElement("setSpec");
            setElement.setTextContent(setSpec.toString());
            headerElement.appendChild(setElement);
        }
        return headerElement;
    }
}

