/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.index.publisher.oaipmh.metadata;

import java.io.File;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.gcube.rest.index.publisher.oaipmh.metadata.Metadata;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XSLTMetadata
extends Metadata {
    private final Element elementToTransform;
    private final String XSLTfilename;

    public XSLTMetadata(Element elementToTransform, String XSLTfilename) {
        super("oai_dc", "http://www.openarchives.org/OAI/2.0/OAI-PMH.xsd", "http://www.openarchives.org/OAI/2.0/");
        this.elementToTransform = elementToTransform;
        this.XSLTfilename = XSLTfilename;
    }

    public Element getXMLElement() throws Exception {
        Logger.getLogger((String)XSLTMetadata.class.getName()).log((Priority)Level.DEBUG, (Object)"getXMLElement");
        TransformerFactory factory = TransformerFactory.newInstance();
        StreamSource xslt = new StreamSource(new File(this.XSLTfilename));
        try {
            Transformer transformer = factory.newTransformer(xslt);
            Document element = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            DOMResult result = new DOMResult(element);
            transformer.transform(new DOMSource(this.elementToTransform), result);
            return element.getDocumentElement();
        }
        catch (ParserConfigurationException e) {
            Logger.getLogger((String)XSLTMetadata.class.getName()).log((Priority)Level.ERROR, null, (Throwable)e);
            throw e;
        }
        catch (TransformerConfigurationException e) {
            Logger.getLogger((String)XSLTMetadata.class.getName()).log((Priority)Level.ERROR, null, (Throwable)e);
            throw e;
        }
        catch (TransformerException e) {
            Logger.getLogger((String)XSLTMetadata.class.getName()).log((Priority)Level.ERROR, null, (Throwable)e);
            throw e;
        }
    }
}

