/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.visualization.portlet;

import com.google.common.base.Charsets;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import gr.uoa.di.madgik.visualization.endpoint.EndpointManager;
import gr.uoa.di.madgik.visualization.exceptions.ServiceDiscoveryException;
import gr.uoa.di.madgik.visualization.service.ServiceProfile;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.servlet.http.HttpServletRequest;
import org.gcube.common.portal.PortalContext;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisualizationPortlet
extends GenericPortlet {
    protected String staticEndpoint;
    protected String viewTemplate;
    protected String username;
    protected String user;
    protected String pass;
    private ServiceProfile analyticsProfile;
    private ServiceProfile workspaceProfile;
    private EndpointManager endpointManager;
    private static Logger logger = LoggerFactory.getLogger(VisualizationPortlet.class);
    private static final int HTTP_CONNECTION_TIMEOUT = 15000;

    public void init() {
        this.viewTemplate = this.getInitParameter("view-template");
        this.staticEndpoint = this.getInitParameter("back-end-url");
        this.analyticsProfile = new ServiceProfile();
        this.analyticsProfile.setServiceClass("DataAnalysis");
        this.analyticsProfile.setServiceName("data-analytics-visualization");
        this.analyticsProfile.setPathEndsWith("/");
        this.workspaceProfile = new ServiceProfile();
        this.workspaceProfile.setServiceClass("DataAccess");
        this.workspaceProfile.setServiceName("StorageHub");
        this.workspaceProfile.setPathContains("storagehub/workspace");
        this.endpointManager = new EndpointManager();
        Authenticator.setDefault((Authenticator)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void doView(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        logger.info("Visualization portlet is rendering the main view");
        PortalContext.setUserInSession((RenderRequest)renderRequest);
        PortalContext pContext = PortalContext.getConfiguration();
        HttpServletRequest httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)renderRequest);
        ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long portletGroupId = themeDisplay.getScopeGroupId();
        String scope = pContext.getCurrentScope(String.valueOf(portletGroupId));
        GCubeUser user = pContext.getCurrentUser(httpServletRequest);
        String username = user.getUsername();
        String token = pContext.getCurrentUserToken(scope, username);
        List endpoints = null;
        try {
            endpoints = this.endpointManager.getServiceEndpoints(scope, this.workspaceProfile);
        }
        catch (ServiceDiscoveryException e) {
            e.printStackTrace();
        }
        System.out.println("DoView: " + username + " " + token);
        System.out.println("Endpoints: " + endpoints.toString());
        renderRequest.setAttribute("workspaceEndpoint", endpoints.get(0));
        renderRequest.setAttribute("username", (Object)username);
        renderRequest.setAttribute("token", (Object)token);
        PortalContext.setUserInSession((RenderRequest)renderRequest);
        this.include(this.viewTemplate, renderRequest, renderResponse);
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException, IOException {
        super.processAction(actionRequest, actionResponse);
    }

    public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws PortletException, IOException {
        PortalContext pContext = PortalContext.getConfiguration();
        HttpServletRequest httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)resourceRequest);
        String scope = pContext.getCurrentScope(httpServletRequest);
        logger.info("Serving resource for scope: " + scope);
        logger.info("Is liferay request: " + this.liferayRequests(resourceRequest, resourceResponse));
        if (this.liferayRequests(resourceRequest, resourceResponse)) {
            try {
                List endpoints = this.endpointManager.getServiceEndpoints(scope, this.analyticsProfile);
                System.out.println(endpoints.toString());
                for (String endpoint : endpoints) {
                    logger.info("Trying to contact endpoint: " + endpoint);
                    try {
                        int status = this.doRequest(endpoint, resourceRequest, resourceResponse);
                        if (!this.isOKStatus(status)) continue;
                        break;
                    }
                    catch (Exception e) {
                        this.endpointManager.removeServiceEndpoint(scope, this.analyticsProfile, endpoint);
                        logger.warn("Cannot reach endpoint", (Throwable)e);
                    }
                }
            }
            catch (ServiceDiscoveryException e) {
                logger.error(e.getMessage(), (Throwable)e);
                try {
                    this.doRequest(this.staticEndpoint, resourceRequest, resourceResponse);
                }
                catch (SocketTimeoutException ex) {
                    resourceResponse.getWriter().write("Service is currently unavailable");
                    resourceResponse.setProperty("portlet.http-status-code", "500");
                }
            }
        }
    }

    public int doRequest(String endpoint, ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException {
        PortalContext pContext = PortalContext.getConfiguration();
        HttpServletRequest httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)resourceRequest);
        System.out.println(resourceRequest.toString());
        GCubeUser user = pContext.getCurrentUser(httpServletRequest);
        String username = user.getUsername();
        String email = user.getEmail();
        String initials = this.getInitials(user);
        long id = user.getUserId();
        String uuid = null;
        try {
            uuid = UserLocalServiceUtil.getUserById((long)id).getUserUuid();
        }
        catch (PortalException | SystemException ex) {
            logger.error(ex.getMessage(), ex);
        }
        String scope = pContext.getCurrentScope(httpServletRequest);
        String token = pContext.getCurrentUserToken(scope, username);
        String resourceUrl = this.buildResourceUrl(endpoint, resourceRequest);
        String method = this.getRequestMethod(httpServletRequest, resourceRequest);
        URL url = new URL(resourceUrl);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("gcube-scope", scope);
        connection.setRequestProperty("gcube-token", token);
        connection.setRequestProperty("username", username);
        connection.setRequestProperty("email", email);
        connection.setRequestProperty("initials", initials);
        connection.setRequestProperty("useruuid", uuid);
        connection.setRequestProperty("Content-Type", resourceRequest.getContentType());
        connection.setRequestProperty("charset", resourceRequest.getCharacterEncoding());
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setInstanceFollowRedirects(false);
        connection.setRequestMethod(method);
        connection.setUseCaches(false);
        connection.setConnectTimeout(15000);
        InputStream is = resourceRequest.getPortletInputStream();
        byte[] postData = ByteStreams.toByteArray((InputStream)is);
        is.close();
        if (postData.length > 0) {
            connection.setRequestProperty("Content-Length", Integer.toString(postData.length));
            DataOutputStream wr = new DataOutputStream(connection.getOutputStream());
            wr.write(postData);
        }
        int status = 500;
        try {
            connection.connect();
            status = connection.getResponseCode();
            resourceResponse.setProperty("portlet.http-status-code", Integer.toString(status));
            int responseCode = connection.getResponseCode();
            if (!this.isOKStatus(responseCode)) {
                String response = CharStreams.toString((Readable)new InputStreamReader(connection.getErrorStream(), Charsets.UTF_8));
                logger.debug("Service response:" + response);
                resourceResponse.getWriter().write(response);
            } else {
                logger.debug("Back end service returned with status " + responseCode + ": " + connection.getContentLength() + " bytes");
                resourceResponse.setCharacterEncoding(connection.getContentEncoding());
                resourceResponse.setContentLength(connection.getContentLength());
                if (connection.getContentType() != null) {
                    resourceResponse.setContentType(connection.getContentType());
                }
                if (connection.getHeaderField("Content-Disposition") != null) {
                    resourceResponse.setProperty("Content-Disposition", connection.getHeaderField("Content-Disposition"));
                }
                if (connection.getHeaderField("filename") != null) {
                    resourceResponse.setProperty("filename", connection.getHeaderField("filename"));
                }
                ByteStreams.copy((InputStream)connection.getInputStream(), (OutputStream)resourceResponse.getPortletOutputStream());
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return status;
    }

    protected String buildResourceUrl(String endpoint, ResourceRequest resourceRequest) {
        StringBuilder resourceUrl = new StringBuilder(endpoint);
        logger.info("ResourceUrl no parameters: " + resourceUrl);
        logger.info("Is get: " + resourceRequest.getMethod().toUpperCase().equals("GET"));
        resourceUrl.append(resourceRequest.getResourceID());
        if (resourceRequest.getMethod().toUpperCase().equals("GET")) {
            HttpServletRequest httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)resourceRequest);
            Enumeration parameterNames = httpServletRequest.getParameterNames();
            while (parameterNames.hasMoreElements()) {
                String param = (String)parameterNames.nextElement();
                logger.info("Parameter name -> " + param);
                logger.info("Parameter value -> " + httpServletRequest.getParameterValues(param));
                String[] ids = httpServletRequest.getParameterValues(param);
                for (int j = 0; j < ids.length; ++j) {
                    resourceUrl.append(param + "=" + ids[j]);
                    if (j + 1 >= ids.length) continue;
                    resourceUrl.append("&");
                }
                if (!parameterNames.hasMoreElements()) continue;
                resourceUrl.append("&");
            }
            System.out.println("SIZE:" + resourceRequest.getParameterMap().size());
        }
        String resource = resourceUrl.toString();
        logger.info("ResourceUrl with parameters: " + resource);
        return resource;
    }

    protected void addQueryParameters(StringBuilder resourceUrl, ResourceRequest resourceRequest) {
        if (!resourceUrl.toString().contains("?")) {
            resourceUrl.append("?");
        }
        resourceRequest.getParameterMap().entrySet().stream().forEach(entry -> resourceUrl.append("&" + (String)entry.getKey() + "=" + ((String[])entry.getValue())[0]));
    }

    protected void doDispatch(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        super.doDispatch(request, response);
    }

    protected void include(String path, RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        String url = null;
        url = renderRequest.getParameter("jspPage") == null || renderRequest.getParameter("jspPage").equals("./") ? path : path + renderRequest.getParameter("jspPage");
        PortletRequestDispatcher portletRequestDispatcher = this.getPortletContext().getRequestDispatcher(url);
        if (portletRequestDispatcher == null) {
            logger.error(url + " is not a valid include");
        } else {
            portletRequestDispatcher.include(renderRequest, renderResponse);
        }
    }

    private String getInitials(GCubeUser user) {
        return user.getFirstName().substring(0, 1) + (user.getMiddleName() != null && user.getMiddleName().length() > 0 ? user.getMiddleName().substring(0, 1) : "") + user.getLastName().substring(0, 1);
    }

    public boolean liferayRequests(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException {
        boolean getLocale = ParamUtil.getBoolean((PortletRequest)resourceRequest, (String)"getLocale");
        if (getLocale) {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
            jsonObject.put("locale", PortalUtil.getHttpServletRequest((PortletRequest)resourceRequest).getLocale().toString());
            resourceResponse.getWriter().println(jsonObject);
            return false;
        }
        return true;
    }

    private String getRequestMethod(HttpServletRequest httpServletRequest, ResourceRequest resourceRequest) {
        Enumeration e = httpServletRequest.getHeaderNames();
        while (e.hasMoreElements()) {
            String header = (String)e.nextElement();
            logger.info("Header " + header + " - " + httpServletRequest.getHeader(header));
        }
        String method = httpServletRequest.getHeader("gcube-request-method");
        return method == null || method.isEmpty() ? resourceRequest.getMethod() : method;
    }

    private boolean isOKStatus(int status) {
        return status == 200 || status == 201;
    }
}

