/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.json;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.gcube.vremanagement.executor.plugin.PluginDeclaration;
import org.gcube.vremanagement.executor.plugin.PluginStateEvolution;
import org.gcube.vremanagement.executor.plugin.Ref;
import org.gcube.vremanagement.executor.plugin.RunOn;

public class SEMapper {
    protected static final ObjectMapper mapper = new ObjectMapper();
    public static final String CLASS_PROPERTY = "@class";

    public static ObjectMapper getObjectMapper() {
        return mapper;
    }

    public static void registerSubtypes(Class<?> classes) {
        mapper.registerSubtypes(classes);
    }

    public static <T extends OutputStream, O> T marshal(O object, T stream) throws JsonGenerationException, JsonMappingException, IOException {
        mapper.writeValue(stream, object);
        return stream;
    }

    public static <T extends Writer, O> T marshal(O object, T writer) throws JsonGenerationException, JsonMappingException, IOException {
        mapper.writeValue(writer, object);
        return writer;
    }

    public static <O> String marshal(O object) throws JsonProcessingException {
        return mapper.writeValueAsString(object);
    }

    public static <O> String marshal(List<O> list) throws JsonProcessingException {
        CollectionType type = mapper.getTypeFactory().constructCollectionType(List.class, Object.class);
        return mapper.writerFor(type).writeValueAsString(list);
    }

    public static <O> String marshal(O[] array) throws JsonProcessingException {
        return mapper.writeValueAsString(array);
    }

    public static <O> O unmarshal(Class<O> clz, Reader reader) throws JsonParseException, JsonMappingException, IOException {
        return mapper.readValue(reader, clz);
    }

    public static <O> O unmarshal(Class<O> clz, InputStream stream) throws JsonParseException, JsonMappingException, IOException {
        return mapper.readValue(stream, clz);
    }

    public static <O> O unmarshal(Class<O> clz, String string) throws JsonParseException, JsonMappingException, IOException {
        return mapper.readValue(string, clz);
    }

    public static <O> List<O> unmarshalList(Class<O> clz, String string) throws JsonParseException, JsonMappingException, IOException {
        CollectionType type = mapper.getTypeFactory().constructCollectionType(ArrayList.class, clz);
        return (List)mapper.readValue(string, (JavaType)type);
    }

    public static <O> List<O> unmarshalList(String string) throws JsonParseException, JsonMappingException, IOException {
        CollectionType type = mapper.getTypeFactory().constructCollectionType(ArrayList.class, Object.class);
        return (List)mapper.readValue(string, (JavaType)type);
    }

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.registerSubtypes(RunOn.class);
        mapper.registerSubtypes(Ref.class);
        mapper.registerSubtypes(PluginDeclaration.class);
        mapper.registerSubtypes(PluginStateEvolution.class);
    }
}

