/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.memory;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.cotrix.action.Action;
import org.cotrix.common.Utils;
import org.cotrix.domain.memory.IdentifiedMS;
import org.cotrix.domain.trait.Status;
import org.cotrix.domain.user.Role;
import org.cotrix.domain.user.User;

public class UserMS
extends IdentifiedMS
implements User.State {
    private String userName;
    private String fullName;
    private String email;
    private Set<Action> permissions = new LinkedHashSet<Action>();
    private Set<Role> roles = new LinkedHashSet<Role>();

    public UserMS() {
    }

    public UserMS(String id) {
        super(id);
    }

    public UserMS(String id, Status status) {
        super(id, status);
    }

    @Override
    public void name(String name) {
        Utils.valid((String)"full name", (String)name);
        this.userName = name;
    }

    @Override
    public String name() {
        return this.userName;
    }

    @Override
    public String email() {
        return this.email;
    }

    @Override
    public void email(String email) {
        Utils.validEmail((String)email);
        this.email = email;
    }

    @Override
    public String fullName() {
        return this.fullName;
    }

    @Override
    public void fullName(String name) {
        Utils.valid((String)"username", (String)name);
        this.fullName = name;
    }

    @Override
    public void permissions(Collection<Action> permissions) {
        Utils.notNull((String)"permissions", permissions);
        this.permissions = new HashSet<Action>(permissions);
    }

    @Override
    public Collection<Action> permissions() {
        return this.permissions;
    }

    public void add(Role role) {
        Utils.notNull((String)"role", (Object)role);
        this.roles.add(role);
    }

    public void remove(Role role) {
        Utils.notNull((String)"role", (Object)role);
        this.roles.remove(role);
    }

    @Override
    public void roles(Collection<Role> roles) {
        Utils.notNull((String)"roles", roles);
        this.roles.clear();
        for (Role role : roles) {
            this.add(role);
        }
    }

    @Override
    public Collection<Role> roles() {
        return this.roles;
    }

    @Override
    public User.Private entity() {
        return new User.Private(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof User.State)) {
            return false;
        }
        User.State other = (User.State)obj;
        if (this.email == null ? other.email() != null : !this.email.equals(other.email())) {
            return false;
        }
        if (this.fullName == null ? other.fullName() != null : !this.fullName.equals(other.fullName())) {
            return false;
        }
        if (this.permissions == null ? other.permissions() != null : !this.permissions.equals(other.permissions())) {
            return false;
        }
        if (this.roles == null ? other.roles() != null : !this.roles.equals(other.roles())) {
            return false;
        }
        return !(this.userName == null ? other.name() != null : !this.userName.equals(other.name()));
    }
}

