/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.trait;

import org.cotrix.common.Utils;
import org.cotrix.domain.trait.Status;

public interface Identified {
    public String id();

    public static abstract class Abstract<SELF extends Abstract<SELF, S>, S extends State>
    implements Identified {
        private S state;

        public Abstract(S state) {
            Utils.notNull((String)"state", state);
            this.state = state;
        }

        public S state() {
            return this.state;
        }

        @Override
        public String id() {
            return this.state.id();
        }

        public boolean isChangeset() {
            return this.status() != null;
        }

        public Status status() {
            return this.state.status();
        }

        public void update(SELF changeset) throws IllegalArgumentException, IllegalStateException {
            Utils.notNull((String)(this.getClass().getCanonicalName() + "'s changeset"), changeset);
            if (this.isChangeset()) {
                throw new IllegalStateException("entity " + this.state.id() + "(" + this.getClass().getCanonicalName() + ") is a changeset and cannot be updated");
            }
            if (((Abstract)changeset).status() == null || ((Abstract)changeset).status() != Status.MODIFIED) {
                throw new IllegalArgumentException("entity " + this.state.id() + "(" + this.getClass().getCanonicalName() + ") cannot be updated with a " + (((Abstract)changeset).status() == null ? "NEW" : ((Abstract)changeset).status()) + " object");
            }
            if (!this.id().equals(((Abstract)changeset).id())) {
                throw new IllegalArgumentException("changeset " + ((Abstract)changeset).id() + "(" + changeset.getClass().getCanonicalName() + ") is not a changeset for entity " + this.id());
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Abstract)) {
                return false;
            }
            Abstract other = (Abstract)obj;
            return !(this.state == null ? other.state != null : !this.state.equals(other.state));
        }
    }

    public static interface State {
        public String id();

        public Status status();
    }
}

