/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.memory;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.cotrix.common.Utils;
import org.cotrix.domain.common.Attribute;
import org.cotrix.domain.common.NamedStateContainer;
import org.cotrix.domain.memory.AttributeMS;
import org.cotrix.domain.memory.IdentifiedMS;
import org.cotrix.domain.trait.Attributed;
import org.cotrix.domain.trait.Status;
import org.cotrix.domain.utils.Constants;

public class AttributedMS
extends IdentifiedMS
implements Attributed.State {
    private NamedStateContainer<Attribute.State> attributes = new NamedStateContainer.Default<Attribute.State>();

    public AttributedMS() {
        this.attributes.add(this.timestamp(Constants.CREATION_TIME));
    }

    public AttributedMS(String id, Status status) {
        super(id, status);
    }

    public AttributedMS(Attributed.State other) {
        for (Attribute.State state : other.attributes()) {
            this.attributes.add(new AttributeMS(state));
        }
    }

    private Attribute.State timestamp(QName name) {
        AttributeMS state = new AttributeMS();
        state.name(name);
        String value = DateFormat.getDateTimeInstance().format(Calendar.getInstance().getTime());
        state.value(value);
        state.type(Constants.SYSTEM_TYPE);
        return state;
    }

    @Override
    public NamedStateContainer<Attribute.State> attributes() {
        return this.attributes;
    }

    public void attributes(Collection<Attribute.State> attributes) {
        Utils.notNull((String)"attributes", attributes);
        for (Attribute.State a : attributes) {
            this.attributes.add(a);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Attributed.State)) {
            return false;
        }
        Attributed.State other = (Attributed.State)obj;
        return !(this.attributes == null ? other.attributes() != null : !this.attributes.equals(other.attributes()));
    }
}

