/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.common;

import java.util.ArrayList;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.cotrix.domain.common.StateContainer;
import org.cotrix.domain.trait.Identified;
import org.cotrix.domain.trait.Named;

public interface NamedStateContainer<S>
extends StateContainer<S> {
    public boolean contains(QName var1);

    public boolean contains(Named var1);

    public Collection<S> getAll(QName var1);

    public S lookup(QName var1) throws IllegalStateException;

    public S lookup(Named var1) throws IllegalStateException;

    public static class Default<S extends Identified.State & Named.State>
    extends StateContainer.Default<S>
    implements NamedStateContainer<S> {
        public Default() {
        }

        public Default(Collection<S> elements) {
            super(elements);
        }

        @Override
        public boolean contains(QName name) {
            return !this.getAll(name).isEmpty();
        }

        @Override
        public boolean contains(Named named) {
            return this.contains(named.name());
        }

        @Override
        public Collection<S> getAll(QName name) {
            ArrayList<Identified.State> matches = new ArrayList<Identified.State>();
            for (Identified.State state : this.elements()) {
                if (!name.equals(((Named.State)state).name())) continue;
                matches.add(state);
            }
            return matches;
        }

        @Override
        public S lookup(QName name) throws IllegalStateException {
            Collection<S> matches = this.getAll(name);
            if (matches.size() == 1) {
                return (S)((Identified.State)matches.iterator().next());
            }
            throw new IllegalStateException("zero or more than one element with name " + name);
        }

        @Override
        public S lookup(Named named) throws IllegalStateException {
            return (S)this.lookup(named.name());
        }
    }
}

