/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.validation;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.cotrix.common.Utils;
import org.cotrix.domain.validation.Constraint;
import org.cotrix.domain.validation.Validator;

public enum Validators implements Validator
{
    max_length("$value.length <= %s", "length"),
    min_length("$value.length >= %s", "length"),
    number(String.format("!isNaN(%s)", "$value"), new String[0]),
    atleast(String.format("!isNaN(%1$s) && %1$s >= %2$s", "$value", "%s"), "number"),
    greater(String.format("!isNaN(%1$s) && %1$s > %2$s", "$value", "%s"), "number"),
    atmost(String.format("!isNaN(%1$s) && %1$s <= %2$s", "$value", "%s"), "number"),
    smaller(String.format("!isNaN(%1$s) && %1$s < %2$s", "$value", "%s"), "number"),
    between(String.format("!isNaN(%1$s) && %1$s >= %2$s && %1$s <= %2$s", "$value", "%s"), "min", "max"),
    date(String.format("!isNaN(new Date(%s).getTime())", "$value"), new String[0]),
    before(String.format("!isNaN(new Date(%1$s).getTime()) && (new Date(%1$s).getTime() < new Date('%2$s').getTime())", "$value", "%s"), "date"),
    after(String.format("!isNaN(new Date(%1$s).getTime()) && (new Date(%1$s).getTime() > new Date('%2$s').getTime())", "$value", "%s"), "date"),
    between_dates(String.format("!isNaN(new Date(%1$s).getTime()) && (new Date(%1$s).getTime() > new Date('%2$s').getTime())&& (new Date(%1$s).getTime() < new Date('%2$s').getTime())", "$value", "%s"), "start", "end"),
    regexp("/%s/.test($value)", "expression"),
    custom("%s", "expression");

    private final List<String> names;
    private final String template;
    private static final String paramErrorMsg = "wrong number of parameters for validator %s: expected %s, found %s (%s)";

    private Validators(String template, String ... params) {
        this.template = template;
        this.names = Arrays.asList(params);
    }

    @Override
    public Constraint instance(Object ... params) throws IllegalArgumentException {
        Utils.valid((String)"validator's parameters", (Object[])params);
        int size = this.names.size();
        if (params.length != size) {
            String msg = String.format(paramErrorMsg, this.name(), size, params.length, Arrays.asList(params));
            throw new IllegalArgumentException(msg);
        }
        String expression = String.format(this.template, params);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        for (int i = 0; i < this.names.size(); ++i) {
            paramMap.put(this.names.get(i), params[i].toString());
        }
        return new Constraint(this.name(), expression, paramMap);
    }

    @Override
    public List<String> parameterNames() {
        return this.names;
    }
}

