/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.utils;

import javax.xml.namespace.QName;
import org.cotrix.common.CommonUtils;
import org.cotrix.domain.attributes.Attribute;
import org.cotrix.domain.dsl.Data;
import org.cotrix.domain.utils.DomainConstants;

public class AttributeTemplate {
    private final Attribute template;

    public AttributeTemplate(Attribute template) {
        CommonUtils.notNull((String)"template", (Object)template);
        if (Data.reveal(template).isChangeset()) {
            throw new IllegalArgumentException("attribute template cannot be a changeset");
        }
        this.template = template;
    }

    public QName name() {
        return this.template.qname();
    }

    public QName type() {
        return this.template.type();
    }

    public String language() {
        return this.template.language();
    }

    public boolean matches(Attribute attribute) {
        return this.matches((Attribute.Bean)Data.reveal(attribute).bean());
    }

    public boolean matches(Attribute.Bean attribute) {
        return this.matches(this.template.qname(), attribute.qname()) && this.matches(this.template.type(), attribute.type()) && this.matches(this.template.language(), attribute.language());
    }

    private boolean matches(Object template, Object val) {
        return template == null || template.equals(DomainConstants.NULL_QNAME) || template.equals("__ignore__") || template.equals(val);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.template == null ? 0 : this.template.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AttributeTemplate other = (AttributeTemplate)obj;
        return !(this.template == null ? other.template != null : !this.template.equals(other.template));
    }
}

