/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.codelist;

import java.util.HashMap;
import org.cotrix.domain.common.Container;
import org.cotrix.domain.common.Containers;
import org.cotrix.domain.common.Status;
import org.cotrix.domain.links.Link;
import org.cotrix.domain.memory.MContainer;
import org.cotrix.domain.memory.MLink;
import org.cotrix.domain.trait.BeanOf;
import org.cotrix.domain.trait.Described;
import org.cotrix.domain.trait.Identified;
import org.cotrix.domain.trait.Named;

public interface Code
extends Identified,
Named,
Described {
    public Containers.Links links();

    public static final class Private
    extends Described.Private<Private, Bean>
    implements Code {
        public Private(Bean bean) {
            super(bean);
        }

        @Override
        public Containers.Links links() {
            return new Containers.Links(((Bean)this.bean()).links());
        }

        @Override
        public void update(Private changeset) throws IllegalArgumentException, IllegalStateException {
            super.update(changeset);
            this.updateLinksWithGroupSemantics(changeset);
        }

        private void updateLinksWithGroupSemantics(Private changeset) {
            HashMap<String, Bean> redirected = new HashMap<String, Bean>();
            for (Link.Bean change : ((Bean)changeset.bean()).links()) {
                if (change.target() == null) continue;
                redirected.put(change.id(), change.target());
            }
            if (redirected.isEmpty()) {
                this.links().update(changeset.links());
                return;
            }
            HashMap<String, Bean> targetUpdates = new HashMap<String, Bean>();
            for (Link.Bean link : ((Bean)this.bean()).links()) {
                if (!redirected.containsKey(link.id())) continue;
                Bean update = (Bean)redirected.get(link.id());
                String current = link.target().id();
                Bean knownUpdate = (Bean)targetUpdates.get(current);
                if (knownUpdate == null) {
                    targetUpdates.put(current, update);
                    continue;
                }
                if (knownUpdate.id().equals(update.id())) continue;
                throw new IllegalArgumentException("invalid changeset: two links with the same target must change it consistently");
            }
            this.links().update(changeset.links());
            MContainer<Link.Bean> changes = new MContainer<Link.Bean>();
            for (Link.Bean link : ((Bean)this.bean()).links()) {
                String target = link.target().id();
                if (!targetUpdates.containsKey(target)) continue;
                MLink change = new MLink(link.id(), Status.MODIFIED);
                change.target((Bean)targetUpdates.get(target));
                changes.add(change);
            }
            this.links().update(new Containers.Links((Container.Bean<Link.Bean>)changes));
        }

        public String toString() {
            return "Code [id=" + this.id() + ", name=" + this.qname() + ", attributes=" + this.attributes() + ", links=" + this.links() + "]";
        }
    }

    public static interface Bean
    extends Described.Bean,
    BeanOf<Private> {
        public Container.Bean<Link.Bean> links();
    }
}

