/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.attributes;

import javax.xml.namespace.QName;
import org.cotrix.domain.attributes.Facet;
import org.cotrix.domain.trait.BeanOf;
import org.cotrix.domain.trait.Definition;
import org.cotrix.domain.utils.DomainConstants;
import org.cotrix.domain.values.ValueType;

public interface AttributeDefinition
extends Definition {
    public QName type();

    public boolean is(QName var1);

    public boolean is(Facet var1);

    public String language();

    public ValueType valueType();

    public boolean isShared();

    public static class Private
    extends Definition.Private<Private, Bean>
    implements AttributeDefinition {
        public Private(Bean bean) {
            super(bean);
        }

        @Override
        public boolean isShared() {
            return ((Bean)this.bean()).isShared();
        }

        @Override
        public QName type() {
            return ((Bean)this.bean()).type();
        }

        @Override
        public boolean is(QName name) {
            return ((Bean)this.bean()).is(name);
        }

        @Override
        public boolean is(Facet facet) {
            return ((Bean)this.bean()).is(facet);
        }

        @Override
        public String language() {
            return ((Bean)this.bean()).language();
        }

        @Override
        public ValueType valueType() {
            return ((Bean)this.bean()).valueType();
        }

        @Override
        public void update(Private changeset) throws IllegalArgumentException, IllegalStateException {
            ValueType newtype;
            super.update(changeset);
            if (changeset.qname() == DomainConstants.NULL_QNAME) {
                throw new IllegalArgumentException("attribute name " + this.qname() + " cannot be erased");
            }
            if (changeset.qname() != null) {
                ((Bean)this.bean()).qname(changeset.qname());
            }
            if (changeset.type() == DomainConstants.NULL_QNAME) {
                throw new IllegalArgumentException("attribute type " + this.type() + " cannot be erased");
            }
            if (changeset.type() != null) {
                ((Bean)this.bean()).type(changeset.type());
            }
            if (changeset.language() != null) {
                ((Bean)this.bean()).language(changeset.language() == "__ignore__" ? null : changeset.language());
            }
            if ((newtype = changeset.valueType()) != null) {
                ((Bean)this.bean()).valueType(newtype);
            }
        }

        public String toString() {
            return "def [id=" + this.id() + ", shared=" + this.isShared() + ", name=" + this.qname() + ", range=" + this.range() + ", valueType=" + this.valueType() + ", language=" + this.language() + (this.type() == null ? "" : ", type=" + this.type()) + (this.status() == null ? "" : " (" + (Object)((Object)this.status()) + ") ") + "]";
        }
    }

    public static interface Bean
    extends Definition.Bean,
    BeanOf<Private> {
        public QName type();

        public void type(QName var1);

        public String language();

        public void language(String var1);

        public ValueType valueType();

        public void valueType(ValueType var1);

        public boolean isShared();

        public boolean is(QName var1);

        public boolean is(Facet var1);
    }
}

