/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.links;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.cotrix.domain.codelist.Code;
import org.cotrix.domain.links.LinkDefinition;
import org.cotrix.domain.trait.BeanOf;
import org.cotrix.domain.trait.Defined;
import org.cotrix.domain.trait.Described;
import org.cotrix.domain.trait.Identified;
import org.cotrix.domain.trait.Named;
import org.cotrix.domain.values.ValueFunction;

public interface Link
extends Identified,
Named,
Described,
Defined<LinkDefinition> {
    public Code target();

    public List<Object> value();

    public String valueAsString();

    public static class Private
    extends Described.Private<Private, Bean>
    implements Link {
        public Private(Bean bean) {
            super(bean);
        }

        @Override
        public QName qname() {
            LinkDefinition.Bean def = (LinkDefinition.Bean)((Bean)this.bean()).definition();
            return def == null ? null : def.qname();
        }

        @Override
        public String valueAsString() {
            List<Object> linkval = this.value();
            if (linkval.isEmpty()) {
                return null;
            }
            if (linkval.size() == 1) {
                Object val = linkval.get(0);
                return val == null ? null : val.toString();
            }
            return linkval.toString();
        }

        @Override
        public List<Object> value() {
            return Private.resolve((Bean)this.bean(), (LinkDefinition.Bean)this.definition().bean(), new ArrayList<String>());
        }

        @Override
        public Code target() {
            return new Code.Private(((Bean)this.bean()).target());
        }

        @Override
        public LinkDefinition.Private definition() {
            return new LinkDefinition.Private((LinkDefinition.Bean)((Bean)this.bean()).definition());
        }

        @Override
        public void update(Private changeset) throws IllegalArgumentException, IllegalStateException {
            super.update(changeset);
            Code.Bean newtarget = ((Bean)changeset.bean()).target();
            if (newtarget != null) {
                ((Bean)this.bean()).target(newtarget);
            }
        }

        public static List<Object> resolve(Bean link, LinkDefinition.Bean type, List<String> ids) {
            if (ids.contains(link.id())) {
                StringBuilder cycle = new StringBuilder();
                for (String id : ids) {
                    cycle.append(id + "->");
                }
                cycle.append(link.id());
                throw new IllegalStateException("cycle detected:" + cycle);
            }
            ids.add(link.id());
            if (link.target() == null) {
                return Collections.emptyList();
            }
            List<Object> values = type.valueType().valueIn(link.id(), link.target(), ids);
            ArrayList<Object> results = new ArrayList<Object>();
            ValueFunction function = type.function();
            for (Object value : values) {
                Object result = null;
                if (value instanceof QName) {
                    QName name = (QName)value;
                    result = new QName(name.getNamespaceURI(), function.apply(name.getLocalPart()));
                } else {
                    String val = (String)value;
                    result = function.apply(val);
                }
                results.add(result);
            }
            return results;
        }

        public String toString() {
            return "Codelink [id=" + this.id() + ", definition=" + ((Bean)this.bean()).definition() + " :--> " + ((Bean)this.bean()).target().id() + "]";
        }
    }

    public static interface Bean
    extends Described.Bean,
    Defined.Bean<LinkDefinition.Bean>,
    BeanOf<Private> {
        public Code.Bean target();

        public void target(Code.Bean var1);
    }
}

