/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.memory;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.cotrix.action.Action;
import org.cotrix.common.CommonUtils;
import org.cotrix.domain.common.Status;
import org.cotrix.domain.memory.MIdentified;
import org.cotrix.domain.user.Role;
import org.cotrix.domain.user.User;

public class MUser
extends MIdentified
implements User.State {
    private String userName;
    private String fullName;
    private String email;
    private Set<Action> permissions = new HashSet<Action>();
    private Set<Role> roles = new HashSet<Role>();

    public MUser() {
    }

    public MUser(String id) {
        super(id);
    }

    public MUser(String id, Status status) {
        super(id, status);
    }

    @Override
    public void name(String name) {
        CommonUtils.valid((String)"full name", (String)name);
        this.userName = name;
    }

    @Override
    public String name() {
        return this.userName;
    }

    @Override
    public String email() {
        return this.email;
    }

    @Override
    public void email(String email) {
        CommonUtils.validEmail((String)email);
        this.email = email;
    }

    @Override
    public String fullName() {
        return this.fullName;
    }

    @Override
    public void fullName(String name) {
        CommonUtils.valid((String)"username", (String)name);
        this.fullName = name;
    }

    @Override
    public void permissions(Collection<Action> permissions) {
        CommonUtils.notNull((String)"permissions", permissions);
        this.permissions = new HashSet<Action>(permissions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Action> permissions() {
        Set<Action> set = this.permissions;
        synchronized (set) {
            return new HashSet<Action>(this.permissions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Action permission) {
        CommonUtils.notNull((String)"permission", (Object)permission);
        Set<Action> set = this.permissions;
        synchronized (set) {
            this.permissions.add(permission);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Role role) {
        CommonUtils.notNull((String)"role", (Object)role);
        Set<Role> set = this.roles;
        synchronized (set) {
            this.roles.add(role);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Role role) {
        CommonUtils.notNull((String)"role", (Object)role);
        Set<Role> set = this.roles;
        synchronized (set) {
            this.roles.remove(role);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Action permission) {
        CommonUtils.notNull((String)"role", (Object)permission);
        Set<Action> set = this.permissions;
        synchronized (set) {
            this.permissions.remove(permission);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void roles(Collection<Role> roles) {
        CommonUtils.notNull((String)"roles", roles);
        Collection<Role> collection = roles;
        synchronized (collection) {
            this.roles.clear();
        }
        for (Role role : roles) {
            this.add(role);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Role> roles() {
        Set<Role> set = this.roles;
        synchronized (set) {
            return new HashSet<Role>(this.roles);
        }
    }

    @Override
    public User.Private entity() {
        return new User.Private(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof User.State)) {
            return false;
        }
        User.State other = (User.State)obj;
        if (this.email == null ? other.email() != null : !this.email.equals(other.email())) {
            return false;
        }
        if (this.fullName == null ? other.fullName() != null : !this.fullName.equals(other.fullName())) {
            return false;
        }
        if (this.permissions == null ? other.permissions() != null : !this.permissions.equals(other.permissions())) {
            return false;
        }
        if (this.roles == null ? other.roles() != null : !this.roles.equals(other.roles())) {
            return false;
        }
        return !(this.userName == null ? other.name() != null : !this.userName.equals(other.name()));
    }
}

