/*
 * Decompiled with CFR 0.152.
 */
package lombok.core;

import java.io.InputStream;

public class Version {
    private static final String VERSION = "1.14.8";
    private static final String RELEASE_NAME = "Branching Cobra";

    private Version() {
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            System.out.printf("Lombok %s\n", Version.getFullVersion());
        } else {
            System.out.println(VERSION);
        }
    }

    public static String getVersion() {
        return VERSION;
    }

    public static String getReleaseName() {
        return RELEASE_NAME;
    }

    public static String getFullVersion() {
        String version = String.format("v%s \"%s\"", VERSION, RELEASE_NAME);
        if (!Version.isEdgeRelease()) {
            return version;
        }
        InputStream in = Version.class.getResourceAsStream("/release-timestamp.txt");
        if (in == null) {
            return version;
        }
        try {
            int r;
            byte[] data = new byte[65536];
            for (int p = 0; p < data.length && (r = in.read(data, p, data.length - p)) != -1; p += r) {
            }
            String timestamp = new String(data, "UTF-8").trim();
            return version + " - " + timestamp;
        }
        catch (Exception e) {
            try {
                in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return version;
        }
    }

    public static boolean isEdgeRelease() {
        int lastIdx = VERSION.lastIndexOf(46);
        if (lastIdx == -1) {
            return false;
        }
        try {
            return Integer.parseInt(VERSION.substring(lastIdx + 1)) % 2 == 1;
        }
        catch (Exception e) {
            return false;
        }
    }
}

