/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.transport.backend;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoException;
import com.mongodb.gridfs.GridFS;
import com.mongodb.gridfs.GridFSDBFile;
import com.mongodb.gridfs.GridFSInputFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.bson.types.ObjectId;
import org.gcube.contentmanagement.blobstorage.resource.MemoryType;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.resource.OperationDefinition;
import org.gcube.contentmanagement.blobstorage.resource.StorageObject;
import org.gcube.contentmanagement.blobstorage.transport.TransportManager;
import org.gcube.contentmanagement.blobstorage.transport.backend.MongoIO;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.gcube.contentmanagement.blobstorage.transport.backend.util.DateUtils;
import org.gcube.contentmanagement.blobstorage.transport.backend.util.MongoOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMongoClient
extends TransportManager {
    final Logger logger = LoggerFactory.getLogger(DefaultMongoClient.class);
    private MongoClient mongo;
    private MongoIO io;
    private MemoryType memoryType;

    public DefaultMongoClient(String[] server, String user, String password, MemoryType memoryType) {
        try {
            this.memoryType = memoryType;
            this.io = new MongoIO(server, user, password, memoryType);
            this.io.clean();
            DBCollection coll = this.io.getMetaDataCollection();
            coll.createIndex(new BasicDBObject("filename", (Object)1));
            coll.createIndex(new BasicDBObject("dir", (Object)1));
            coll.createIndex(new BasicDBObject("owner", (Object)1));
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (MongoException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void initBackend(String[] server, String user, String pass, MemoryType memoryType) {
        try {
            this.io = new MongoIO(server, user, pass, memoryType);
            this.io.clean();
            DBCollection coll = this.io.getMetaDataCollection();
            coll.createIndex(new BasicDBObject("filename", (Object)1));
            coll.createIndex(new BasicDBObject("dir", (Object)1));
            coll.createIndex(new BasicDBObject("owner", (Object)1));
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (MongoException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Object get(MyFile resource, String serverLocation, Class<? extends Object> type) throws IOException {
        OperationDefinition op = resource.getOperationDefinition();
        this.logger.info("MongoClient get method: " + op.toString());
        DB db = this.getDB(resource);
        GridFS gfs = new GridFS(db);
        GridFSDBFile f = this.io.retrieveRemoteObject(serverLocation, true);
        Object id = null;
        if (f != null) {
            id = f.getId();
            String lock = (String)f.get("lock");
            if (lock == null || lock.isEmpty() || this.isTTLUnlocked(f)) {
                if (f.containsField("lock") && f.get("lock") != null) {
                    f.put("lock", null);
                    f.save();
                }
                this.download(gfs, resource, f, false);
            } else {
                this.checkTTL(f);
            }
        } else {
            this.close();
            throw new FileNotFoundException("REMOTE FILE NOT FOUND: WRONG PATH OR WRONG OBJECT ID");
        }
        return id;
    }

    @Override
    public String lock(MyFile resource, String serverLocation, Class<? extends Object> type) throws IOException {
        GridFSDBFile f;
        OperationDefinition op = resource.getOperationDefinition();
        if (resource.getLocalPath() != null && !resource.getLocalPath().isEmpty()) {
            resource.setOperation(OperationDefinition.OPERATION.DOWNLOAD);
            this.get(resource, serverLocation, type);
            resource.setOperation(op);
            this.close();
            this.mongo = null;
        }
        this.logger.info("MongoClient lock method: " + op.toString());
        String key = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("MongoDB - pathServer: " + serverLocation);
        }
        if ((f = this.io.retrieveRemoteObject(serverLocation, true)) != null) {
            String lock = (String)f.get("lock");
            if (lock == null || lock.isEmpty() || this.isTTLUnlocked(f)) {
                key = f.getId() + "" + System.currentTimeMillis();
                f.put("lock", key);
                f.put("timestamp", System.currentTimeMillis());
                this.updateCommonFields(f, resource, OperationDefinition.OPERATION.LOCK);
                f.save();
            } else {
                this.checkTTL(f);
            }
        } else {
            this.close();
            throw new FileNotFoundException("REMOTE FILE NOT FOUND: WRONG PATH OR WRONG OBJECT ID");
        }
        return key;
    }

    @Override
    public String put(Object resource, String bucket, String key, boolean replace) throws UnknownHostException {
        OperationDefinition op = ((MyFile)resource).getOperationDefinition();
        this.logger.info("MongoClient put method: " + op.toString());
        String dir = ((MyFile)resource).getRemoteDir();
        String name = ((MyFile)resource).getName();
        ObjectId id = null;
        ObjectId oldId = null;
        GridFSDBFile fold = this.io.retrieveRemoteObject(bucket, false);
        if (fold != null) {
            this.logger.info("a file is already present at: " + bucket);
            oldId = (ObjectId)fold.getId();
            this.logger.info("get old id: " + oldId);
            oldId = this.removeFile(resource, key, replace, oldId, fold);
            if (!replace) {
                return oldId.toString();
            }
        }
        this.logger.info("create new file " + bucket);
        id = this.createNewFile(resource, bucket, dir, name, oldId);
        return ((Object)id).toString();
    }

    public String safePut(Object resource, String bucket, String key, boolean replace) throws UnknownHostException {
        OperationDefinition op = ((MyFile)resource).getOperationDefinition();
        this.logger.info("MongoClient put method: " + op.toString());
        String dir = ((MyFile)resource).getRemoteDir();
        String name = ((MyFile)resource).getName();
        ObjectId id = null;
        ObjectId oldId = null;
        GridFSDBFile fold = this.io.retrieveRemoteObject(bucket, false);
        if (fold != null) {
            this.logger.info("a file is already present at: " + bucket);
            oldId = (ObjectId)fold.getId();
            this.logger.info("get old id: " + oldId);
            id = this.createNewFile(resource, bucket, dir, name, null);
            oldId = this.removeFile(resource, key, replace, oldId, fold);
            id = this.updateId(id, oldId);
        } else {
            id = this.createNewFile(resource, bucket, dir, name, oldId);
        }
        return id.toString();
    }

    private ObjectId updateId(ObjectId oldId, ObjectId newId) throws UnknownHostException {
        this.logger.info("retrieve object with id: " + oldId);
        this.updateChunksCollection(oldId, newId);
        this.replaceObjectIDOnMetaCollection(oldId, newId);
        return newId;
    }

    private void replaceObjectIDOnMetaCollection(ObjectId oldId, ObjectId newId) throws UnknownHostException {
        BasicDBObject oldIdQuery = new BasicDBObject();
        oldIdQuery.put("_id", oldId);
        String collectionName = "fs.files";
        DBCollection dbc = this.io.getCollection(null, collectionName);
        DBObject obj = this.io.findCollectionObject(dbc, oldIdQuery);
        obj.put("_id", newId);
        if (this.memoryType != MemoryType.VOLATILE) {
            dbc.remove(oldIdQuery, MongoIO.DEFAULT_WRITE_TYPE);
            dbc.insert(obj, MongoIO.DEFAULT_WRITE_TYPE);
        } else {
            dbc.remove(oldIdQuery);
            dbc.insert(obj);
        }
    }

    private void updateChunksCollection(ObjectId oldId, ObjectId newId) throws UnknownHostException {
        this.logger.info("update chunks collection. Change file_id from " + oldId + " to " + newId);
        BasicDBObject queryOldFileId = new BasicDBObject();
        queryOldFileId.put("files_id", oldId);
        BasicDBObject queryNewFileId = new BasicDBObject();
        queryNewFileId.put("files_id", newId);
        String chunksCollectionName = "fs.chunks";
        DBCollection dbc = this.io.getCollection(null, chunksCollectionName);
        if (this.memoryType != MemoryType.VOLATILE) {
            dbc.update(queryOldFileId, queryNewFileId, true, true, MongoIO.DEFAULT_WRITE_TYPE);
        } else {
            dbc.update(queryOldFileId, queryNewFileId, true, true);
        }
    }

    @Override
    public void close() {
        this.io.close();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public String unlock(Object resource, String bucket, String key, String key4unlock) throws FileNotFoundException, UnknownHostException {
        GridFSDBFile f;
        String id = null;
        OperationDefinition op = ((MyFile)resource).getOperationDefinition();
        this.logger.info("MongoClient unlock method: " + op.toString());
        if (((MyFile)resource).getLocalPath() != null && !((MyFile)resource).getLocalPath().isEmpty()) {
            ((MyFile)resource).setOperation(OperationDefinition.OPERATION.UPLOAD);
            id = this.put(resource, bucket, key4unlock, true);
            this.close();
            this.mongo = null;
            ((MyFile)resource).setOperation(op);
        }
        String dir = ((MyFile)resource).getRemoteDir();
        String name = ((MyFile)resource).getName();
        String path = bucket;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("DIR: " + dir + " name: " + name + " fullPath " + path + " bucket: " + bucket);
        }
        if ((f = this.io.retrieveRemoteObject(path, false)) == null) {
            this.close();
            throw new FileNotFoundException(path);
        }
        String oldir = (String)f.get("dir");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("old dir  found " + oldir);
        }
        if (!oldir.equalsIgnoreCase(((MyFile)resource).getRemoteDir()) && ((MyFile)resource).getRemoteDir() != null) {
            this.close();
            throw new FileNotFoundException(path);
        }
        String lock = (String)f.get("lock");
        if (lock != null && !lock.isEmpty()) {
            String lck = (String)f.get("lock");
            if (lck.equalsIgnoreCase(key4unlock)) {
                f.put("lock", null);
                f.put("timestamp", null);
                this.updateCommonFields(f, (MyFile)resource, OperationDefinition.OPERATION.UNLOCK);
                f.save();
                return id;
            }
            this.close();
            throw new IllegalAccessError("bad key for unlock");
        }
        this.updateCommonFields(f, (MyFile)resource, OperationDefinition.OPERATION.UNLOCK);
        f.save();
        return id;
    }

    @Override
    public Map<String, StorageObject> getValues(MyFile resource, String bucket, Class<? extends Object> type) {
        HashMap<String, StorageObject> map = null;
        try {
            OperationDefinition op = resource.getOperationDefinition();
            this.logger.info("MongoClient getValues method: " + op.toString());
            DB db = this.io.getDB(resource.getWriteConcern(), resource.getReadPreference());
            GridFS gfs = new GridFS(db);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Mongo get values of dir: " + bucket);
            }
            BasicDBObject query = new BasicDBObject();
            query.put("dir", bucket);
            List<GridFSDBFile> list = gfs.find(query);
            list = this.io.patchRemoteDirPathVersion1(bucket, gfs, query, list);
            this.logger.info("find all object (files/dirs) in the directory " + bucket);
            for (GridFSDBFile f : list) {
                if (map == null) {
                    map = new HashMap<String, StorageObject>();
                }
                StorageObject s_obj = null;
                if (f.get("type") == null || f.get("type").toString().equalsIgnoreCase("file")) {
                    String creationTime;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("found object: " + f.get("name") + "    type:  " + f.get("type"));
                    }
                    s_obj = new StorageObject(f.get("name").toString(), "file");
                    String owner = (String)f.get("owner");
                    if (owner != null) {
                        s_obj.setOwner(owner);
                    }
                    if ((creationTime = (String)f.get("creationTime")) != null) {
                        s_obj.setCreationTime(creationTime);
                    }
                    s_obj.setId(f.getId().toString());
                } else {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("found directory: " + f.get("name") + "    type:  " + f.get("type"));
                    }
                    BasicDBObject queryDir = new BasicDBObject();
                    queryDir.put("dir", f.get("dir").toString() + f.get("name").toString());
                    List<GridFSDBFile> listDir = gfs.find(queryDir);
                    if (listDir != null && listDir.size() > 0) {
                        s_obj = new StorageObject(f.get("name").toString(), "dir");
                    } else {
                        BasicDBObject queryFile = new BasicDBObject();
                        queryFile.put("filename", Pattern.compile(f.get("dir").toString() + "*"));
                        this.logger.info("find all files in the directory " + f.get("name"));
                        List<GridFSDBFile> listFile = gfs.find(queryFile);
                        this.logger.info("search completed");
                        s_obj = listFile != null && listFile.size() > 0 ? new StorageObject(f.get("name").toString(), "dir") : null;
                    }
                }
                if (s_obj == null) continue;
                map.put(f.get("name").toString(), s_obj);
            }
            this.logger.info("search completed");
        }
        catch (Exception e) {
            this.close();
            throw new RemoteBackendException("problem to retrieve objects in the folder: " + bucket + " exception message: " + e.getMessage());
        }
        this.close();
        return map;
    }

    @Override
    public void removeRemoteFile(String bucket, MyFile resource) throws UnknownHostException {
        GridFSDBFile f;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Mongo delete bucket: " + bucket);
        }
        if ((f = this.io.retrieveRemoteObject(bucket, true)) != null) {
            this.checkAndRemove(f, resource);
        } else {
            ObjectId id;
            GridFSDBFile fID;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("File Not Found. Try to delete by ObjectID");
            }
            if (bucket.length() > 23 && (fID = this.io.findGFSCollectionObject(id = new ObjectId(bucket))) != null) {
                this.checkAndRemove(fID, resource);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("object deleted by ID");
                }
            }
        }
        this.close();
    }

    @Override
    public void removeDir(String remoteDir, MyFile resource) {
        ArrayList<String> dirs = new ArrayList<String>();
        dirs.add(remoteDir);
        if (remoteDir.contains("/home/null/") || remoteDir.contains("/public/")) {
            if (remoteDir.contains("/home/null/")) {
                String remoteDirV1 = remoteDir.replace("/home/null/", "/public/");
                dirs.add(remoteDirV1);
            } else {
                String remoteDirV2 = remoteDir.replace("/public/", "/home/null/");
                dirs.add(remoteDirV2);
                String remoteDirV2patch = "/" + remoteDirV2;
                dirs.add(remoteDirV2patch);
            }
        }
        DB db = this.io.getDB(resource.getWriteConcern(), resource.getReadPreference());
        GridFS gfs = new GridFS(db);
        for (String directory : dirs) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Mongo start operation delete bucket: " + directory);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("remove subfolders of folder: " + directory);
            }
            BasicDBObject query = new BasicDBObject();
            String regex = directory + "*";
            query.put("dir", Pattern.compile(regex));
            this.removeObject(gfs, query, resource);
            query = new BasicDBObject();
            String[] dir = directory.split("/");
            StringBuffer parentDir = new StringBuffer();
            for (int i = 0; i < dir.length - 1; ++i) {
                parentDir.append(dir[i] + "/");
            }
            String name = dir[dir.length - 1];
            query.put("dir", parentDir.toString());
            query.put("name", name);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("now remove the folder: " + name + " from folder " + parentDir);
            }
            this.removeObject(gfs, query, resource);
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug("Mongo end operation delete bucket: " + directory);
        }
        this.close();
    }

    @Override
    public long getSize(String remotePath) {
        GridFSDBFile f;
        long length = -1L;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("MongoDB - get Size for pathServer: " + remotePath);
        }
        if ((f = this.io.retrieveRemoteObject(remotePath, true)) != null) {
            length = f.getLength();
        }
        this.close();
        return length;
    }

    @Override
    public long getTTL(String remotePath) throws UnknownHostException {
        GridFSDBFile f;
        long timestamp = -1L;
        long currentTTL = -1L;
        long remainsTTL = -1L;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("MongoDB - pathServer: " + remotePath);
        }
        if ((f = this.io.retrieveRemoteObject(remotePath, true)) != null && (timestamp = ((Long)f.get("timestamp")).longValue()) > 0L) {
            currentTTL = System.currentTimeMillis() - timestamp;
            remainsTTL = 180000L - currentTTL;
        }
        this.close();
        return remainsTTL;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public long renewTTL(MyFile resource) throws UnknownHostException, IllegalAccessException {
        String lock;
        long ttl = -1L;
        MyFile file = resource;
        String key = file.getLockedKey();
        String remotePath = file.getRemotePath();
        GridFSDBFile f = this.io.retrieveRemoteObject(remotePath, true);
        if (f != null && (lock = (String)f.get("lock")) != null && !lock.isEmpty()) {
            String lck = (String)f.get("lock");
            if (!lck.equalsIgnoreCase(key)) {
                this.close();
                throw new IllegalAccessError("bad key for unlock");
            }
            if (f.containsField("countRenew") && f.get("countRenew") != null) {
                int count = (Integer)f.get("countRenew");
                if (count >= 5) {
                    this.close();
                    throw new IllegalAccessException("The number max of TTL renew reached. The number max is: 5");
                }
                f.put("countRenew", count + 1);
            } else {
                f.put("countRenew", 1);
            }
            f.put("timestamp", System.currentTimeMillis());
            f.save();
            ttl = 180000L;
        }
        this.close();
        return ttl;
    }

    @Override
    public String link(MyFile resource, String sourcePath, String destinationPath) throws UnknownHostException {
        GridFSInputFile destinationFile;
        boolean replace = true;
        String source = sourcePath;
        String destination = destinationPath;
        String dir = resource.getRemoteDir();
        String name = resource.getName();
        String destinationId = null;
        String sourceId = null;
        this.logger.debug("link operation on Mongo backend, parameters: source path: " + source + " destination path: " + destination);
        if (source != null && !source.isEmpty() && destination != null && !destination.isEmpty()) {
            int count;
            GridFSDBFile f = this.io.retrieveRemoteObject(source, false);
            if (f != null) {
                count = 1;
                if (f.containsField("linkCount") && f.get("linkCount") != null) {
                    count = (Integer)f.get("linkCount");
                    ++count;
                }
            } else {
                this.close();
                throw new IllegalArgumentException(" source remote file not found at: " + source);
            }
            f.put("linkCount", count);
            this.updateCommonFields(f, resource, OperationDefinition.OPERATION.LINK);
            sourceId = f.getId().toString();
            f.save();
            GridFSDBFile fold = this.io.retrieveRemoteObject(destinationPath, true);
            if (fold != null) {
                String oldir = (String)fold.get("dir");
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("old dir  found " + oldir);
                }
                if (oldir.equalsIgnoreCase(resource.getRemoteDir())) {
                    String lock;
                    ObjectId oldId = (ObjectId)fold.getId();
                    if (!replace) {
                        return oldId.toString();
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("remove id: " + oldId);
                    }
                    if ((lock = (String)fold.get("lock")) != null && !lock.isEmpty() && !this.isTTLUnlocked(fold)) {
                        this.close();
                        throw new IllegalAccessError("The file is locked");
                    }
                    this.io.removeGFSFile(fold, oldId);
                }
            }
            destinationFile = null;
            byte[] data = new byte[1];
            destinationFile = resource.getGcubeMemoryType() == MemoryType.VOLATILE ? this.io.createGFSFileObject(data) : this.io.createGFSFileObject(data, resource.getWriteConcern(), resource.getReadPreference());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Directory: " + dir);
            }
            this.setGenericProperties(resource, destinationPath, dir, destinationFile, name);
            destinationFile.put("link", sourceId);
            destinationId = destinationFile.getId().toString();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("ObjectId: " + destinationId);
            }
        } else {
            this.close();
            throw new IllegalArgumentException(" invalid argument: source: " + source + " dest: " + destination + " the values must be not null and not empty");
        }
        this.io.buildDirTree(this.io.getMetaDataCollection(null), dir);
        destinationFile.save();
        this.close();
        return destinationId.toString();
    }

    @Override
    public String copy(MyFile resource, String sourcePath, String destinationPath) throws UnknownHostException {
        String source = sourcePath;
        String destination = destinationPath;
        String dir = resource.getRemoteDir();
        String name = resource.getName();
        String destinationId = null;
        this.logger.debug("copy operation on Mongo backend, parameters: source path: " + source + " destination path: " + destination);
        if (source != null && !source.isEmpty() && destination != null && !destination.isEmpty()) {
            GridFSDBFile f = this.io.retrieveRemoteObject(source, true);
            if (f != null) {
                f = this.io.retrieveLinkPayload(f);
                InputStream is = f.getInputStream();
                GridFSDBFile dest = this.io.retrieveRemoteObject(destination, false);
                GridFSInputFile destinationFile = this.io.createGFSFileObject(is, resource.getWriteConcern(), resource.getReadPreference());
                if (dest != null) {
                    this.checkAndRemove(dest, resource);
                    this.setGenericProperties(resource, destination, dir, destinationFile, destination.substring(destination.lastIndexOf("/") + 1));
                    this.io.buildDirTree(this.io.getMetaDataCollection(null), dir);
                } else {
                    BasicDBObject query = new BasicDBObject();
                    query.put("dir", destination);
                    List<GridFSDBFile> folder = this.io.retrieveRemoteObjects(query);
                    if (folder != null && folder.size() > 0) {
                        destination = this.appendFileSeparator(destination);
                        this.setGenericProperties(resource, destination + name, destination, destinationFile, name);
                        this.io.buildDirTree(this.io.getMetaDataCollection(null), destination);
                    } else if (destination.lastIndexOf("/") == destination.length() - 1) {
                        this.setGenericProperties(resource, destination + name, destination, destinationFile, name);
                        this.io.buildDirTree(this.io.getMetaDataCollection(null), destination);
                    } else {
                        String newName = destination.substring(destination.lastIndexOf("/") + 1);
                        this.setGenericProperties(resource, destination, dir, destinationFile, newName);
                        this.io.buildDirTree(this.io.getMetaDataCollection(null), dir);
                    }
                }
                destinationId = destinationFile.getId().toString();
                destinationFile.save();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("ObjectId: " + destinationId);
                }
                this.close();
            } else {
                this.close();
                throw new RemoteBackendException(" the source path is wrong. There isn't a file at " + source);
            }
        }
        return destinationId.toString();
    }

    @Override
    public String move(MyFile resource, String sourcePath, String destinationPath) throws UnknownHostException {
        String source = sourcePath;
        String destination = destinationPath;
        resource.setLocalPath(sourcePath);
        String dir = resource.getRemoteDir();
        String name = resource.getName();
        String destinationId = null;
        String sourceId = null;
        this.logger.info("move operation on Mongo backend, parameters: source path: " + source + " destination path: " + destination);
        this.logger.debug("MOVE OPERATION operation defined: " + (Object)((Object)resource.getOperationDefinition().getOperation()));
        if (source != null && !source.isEmpty() && destination != null && !destination.isEmpty()) {
            BasicDBObject sourcePathMetaCollection = this.io.findMetaCollectionObject(source);
            if (sourcePathMetaCollection != null) {
                sourceId = sourcePathMetaCollection.get("_id").toString();
                sourcePathMetaCollection = this.setCommonFields(sourcePathMetaCollection, resource, OperationDefinition.OPERATION.MOVE);
                BasicDBObject queryDestPath = new BasicDBObject();
                queryDestPath.put("filename", destinationPath);
                DBCollection metaCollectionInstance = null;
                metaCollectionInstance = this.memoryType != MemoryType.VOLATILE ? this.io.getMetaDataCollection(this.io.getDB(resource.getWriteConcern(), resource.getReadPreference())) : this.io.getMetaDataCollection(this.io.getDB());
                DBObject destPathMetaCollection = this.io.executeQuery(metaCollectionInstance, queryDestPath);
                BasicDBObject querySourcePath = new BasicDBObject();
                querySourcePath.put("filename", sourcePath);
                BasicDBObject updateQuery = new BasicDBObject();
                updateQuery.put("$set", sourcePathMetaCollection);
                if (this.memoryType != MemoryType.VOLATILE) {
                    metaCollectionInstance.update(querySourcePath, updateQuery, false, true, MongoIO.DEFAULT_WRITE_TYPE);
                } else {
                    metaCollectionInstance.update(querySourcePath, updateQuery, false, true);
                }
                if (destPathMetaCollection != null) {
                    destinationId = destPathMetaCollection.get("_id").toString();
                }
                if (destPathMetaCollection != null && destinationId != null && !destinationId.equals(sourceId)) {
                    this.io.printObject(destPathMetaCollection);
                    destinationId = destPathMetaCollection.get("_id").toString();
                    this.logger.info("file in destination path already present with id : " + destinationId);
                    GridFS gfs = new GridFS(this.io.getDB(resource.getWriteConcern(), resource.getReadPreference()));
                    GridFSDBFile fNewFSPath = gfs.findOne(queryDestPath);
                    this.checkAndRemove(fNewFSPath, resource);
                    this.logger.debug("Changing filename metadata from:" + sourcePathMetaCollection.get("filename") + "\n  to: " + destinationPath);
                    this.logger.debug("original objects:\n  ");
                    this.logger.debug("source object: ");
                    this.io.printObject(sourcePathMetaCollection);
                    this.logger.info("destination object: ");
                    this.io.printObject(destPathMetaCollection);
                    this.io.buildDirTree(this.io.getMetaDataCollection(this.io.getDB(resource.getWriteConcern(), resource.getReadPreference())), dir);
                    sourcePathMetaCollection = new BasicDBObject();
                    sourcePathMetaCollection.put("$set", new BasicDBObject().append("dir", dir).append("filename", destinationPath).append("name", name).append("owner", resource.getOwner()));
                    this.logger.info("new object merged ");
                    this.io.printObject(sourcePathMetaCollection);
                    if (this.memoryType != MemoryType.VOLATILE) {
                        metaCollectionInstance.update(querySourcePath, sourcePathMetaCollection, false, true, MongoIO.DEFAULT_WRITE_TYPE);
                    } else {
                        metaCollectionInstance.update(querySourcePath, sourcePathMetaCollection, false, true);
                    }
                    this.logger.info("update metadata done ");
                    this.logger.info("check update ");
                    DBObject newDestPathMetaCollection = this.io.executeQuery(metaCollectionInstance, queryDestPath);
                    this.io.printObject(newDestPathMetaCollection);
                } else if (destinationId != null && destinationId.equals(sourceId)) {
                    this.logger.warn("the destination id and the source id are the same id. skip operation. ");
                } else {
                    queryDestPath = new BasicDBObject();
                    queryDestPath.put("dir", destination);
                    DBObject folder = metaCollectionInstance.findOne(queryDestPath);
                    if (folder != null) {
                        destination = this.appendFileSeparator(destination);
                        sourcePathMetaCollection = this.setGenericMoveProperties(resource, destination + name, destination, name, sourcePathMetaCollection);
                        destinationId = sourcePathMetaCollection.get("_id").toString();
                        this.io.buildDirTree(metaCollectionInstance, destination);
                    } else {
                        if (destination.lastIndexOf("/") == destination.length() - 1) {
                            sourcePathMetaCollection = this.setGenericMoveProperties(resource, destination + name, destination, name, sourcePathMetaCollection);
                            destinationId = sourcePathMetaCollection.get("_id").toString();
                            this.io.buildDirTree(metaCollectionInstance, destination);
                        } else {
                            String newName = destination.substring(destination.lastIndexOf("/") + 1);
                            sourcePathMetaCollection = this.setGenericMoveProperties(resource, destination, dir, newName, sourcePathMetaCollection);
                            destinationId = sourcePathMetaCollection.get("_id").toString();
                            this.io.buildDirTree(metaCollectionInstance, dir);
                        }
                        queryDestPath = new BasicDBObject();
                        queryDestPath.put("filename", sourcePath);
                        updateQuery = new BasicDBObject();
                        updateQuery.put("$set", sourcePathMetaCollection);
                        if (this.memoryType != MemoryType.VOLATILE) {
                            metaCollectionInstance.update(queryDestPath, updateQuery, true, true, MongoIO.DEFAULT_WRITE_TYPE);
                        } else {
                            metaCollectionInstance.update(queryDestPath, updateQuery, true, true);
                        }
                    }
                }
                this.close();
                return destinationId;
            }
            this.close();
            throw new RemoteBackendException(" the source path is wrong. There isn't a file at this path: " + source);
        }
        this.close();
        throw new IllegalArgumentException("parameters not completed, source: " + source + ", destination: " + destination);
    }

    private ObjectId removeFile(Object resource, String key, boolean replace, ObjectId oldId, GridFSDBFile fold) throws IllegalAccessError, UnknownHostException {
        String oldir = (String)fold.get("dir");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("old dir  found " + oldir);
        }
        this.logger.info("remove old object if replace is true and the file is not locked");
        if (oldir != null && oldir.equalsIgnoreCase(((MyFile)resource).getRemoteDir())) {
            String lock;
            if (!replace) {
                return oldId;
            }
            if (fold.containsField("countLink") && fold.get("countLink") != null) {
                this.close();
                throw new RemoteBackendException("The file cannot be replaced because is linked from another remote file");
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("remove id: " + oldId);
            }
            if (!((lock = (String)fold.get("lock")) == null || lock.isEmpty() || this.isTTLUnlocked(fold) || lock.equalsIgnoreCase(key))) {
                this.close();
                throw new IllegalAccessError("The file is locked");
            }
            oldId = this.checkAndRemove(fold, (MyFile)resource);
        } else if (oldir == null && !replace && oldId != null) {
            return oldId;
        }
        return oldId;
    }

    private ObjectId createNewFile(Object resource, String bucket, String dir, String name, ObjectId oldId) throws UnknownHostException {
        this.io.buildDirTree(this.io.getMetaDataCollection(null), dir);
        GridFSInputFile f2 = this.writePayload(resource, 0, bucket, name, dir, oldId);
        ObjectId id = (ObjectId)f2.getId();
        this.logger.info("new file created with id: " + id);
        return id;
    }

    private ObjectId checkAndRemove(GridFSDBFile f, MyFile resource) {
        String idToRemove = f.getId().toString();
        this.logger.info("check and remove object with id " + idToRemove + " and path: " + f.get("filename"));
        ObjectId idFile = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("fileFound\t remove file");
        }
        this.updateCommonFields(f, resource, OperationDefinition.OPERATION.REMOVE);
        if (f != null && f.containsField("linkCount") && f.get("linkCount") != null) {
            String filename = (String)f.get("filename");
            f.put("onScope", filename);
            f.put("dir", null);
            f.put("filename", null);
            f.put("name", null);
            f.put("onDeleting", "true");
            f.save();
        } else if (f.containsField("link") && f.get("link") != null) {
            while (f != null && f.containsField("link") && f.get("link") != null) {
                ObjectId oId;
                String id = (String)f.get("link");
                GridFSDBFile fLink = this.io.findGFSCollectionObject(new ObjectId(id));
                int linkCount = (Integer)fLink.get("linkCount");
                if (--linkCount == 0) {
                    if (fLink.get("name") == null && fLink.get("filename") == null && fLink.get("dir") == null) {
                        ObjectId idLink;
                        ObjectId idF;
                        idFile = idF = (ObjectId)f.getId();
                        this.io.removeGFSFile(f, idF);
                        if (fLink.containsField("link") && fLink.get("link") != null) {
                            id = (String)fLink.get("link");
                            f = this.io.findGFSCollectionObject(new ObjectId(id));
                        } else {
                            f = null;
                        }
                        idFile = idLink = (ObjectId)fLink.getId();
                        this.io.removeGFSFile(fLink, idLink);
                        continue;
                    }
                    fLink.put("linkCount", null);
                    fLink.save();
                    idFile = oId = (ObjectId)f.getId();
                    this.io.removeGFSFile(f, oId);
                    f = null;
                    continue;
                }
                fLink.put("linkCount", linkCount);
                fLink.save();
                oId = (ObjectId)f.getId();
                this.io.removeGFSFile(f, oId);
                f = null;
            }
        } else {
            this.logger.debug("");
            idFile = new ObjectId(idToRemove);
            this.io.removeGFSFile(f, new ObjectId(idToRemove));
        }
        return idFile;
    }

    private GridFSInputFile writePayload(Object resource, int count, String bucket, String name, String dir, ObjectId idFile) {
        GridFSInputFile f2 = null;
        this.io.clean();
        try {
            if (((MyFile)resource).getInputStream() != null) {
                f2 = this.writeByInputStream(resource, bucket, name, dir, idFile);
                f2.save();
            } else if (((MyFile)resource).getType() != null && ((MyFile)resource).getType().equals("output")) {
                f2 = this.writeByOutputStream(resource, bucket, name, dir, idFile);
            } else {
                f2 = this.writeByLocalFilePath(resource, bucket, name, dir, idFile);
                f2.save();
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Directory: " + dir);
            }
            Object id = f2.getId();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("ObjectId: " + id);
            }
            if (((MyFile)resource).getType() == null || !((MyFile)resource).getType().equals("output")) {
                this.close();
            }
        }
        catch (IOException e1) {
            this.logger.error("Connection error. " + e1.getMessage());
            if (count < 5) {
                this.logger.info(" Retry : #" + ++count);
                this.writePayload(resource, count, bucket, name, dir, idFile);
            }
            this.logger.error("max number of retry completed ");
            this.close();
            throw new RemoteBackendException(e1);
        }
        return f2;
    }

    private GridFSInputFile writeByLocalFilePath(Object resource, String bucket, String name, String dir, ObjectId idFile) throws IOException {
        GridFSInputFile f2 = this.memoryType != MemoryType.VOLATILE ? this.io.createGFSFileObject(new File(((MyFile)resource).getLocalPath()), ((MyFile)resource).getWriteConcern(), ((MyFile)resource).getReadPreference()) : this.io.createGFSFileObject(new File(((MyFile)resource).getLocalPath()));
        this.fillInputFile(resource, bucket, name, dir, f2, idFile);
        this.io.saveGFSFileObject(f2);
        return f2;
    }

    private GridFSInputFile writeByOutputStream(Object resource, String bucket, String name, String dir, ObjectId idFile) throws IOException {
        GridFSInputFile f2 = this.memoryType != MemoryType.VOLATILE ? this.io.createGFSFileObject(((MyFile)resource).getName(), ((MyFile)resource).getWriteConcern(), ((MyFile)resource).getReadPreference()) : this.io.createGFSFileObject(((MyFile)resource).getName());
        this.fillInputFile(resource, bucket, name, dir, f2, idFile);
        ((MyFile)resource).setOutputStream(new MongoOutputStream(this.mongo, f2.getOutputStream()));
        return f2;
    }

    private GridFSInputFile writeByInputStream(Object resource, String bucket, String name, String dir, ObjectId idFile) throws IOException {
        GridFSInputFile f2 = this.memoryType != MemoryType.VOLATILE ? this.io.createGFSFileObject(((MyFile)resource).getInputStream(), ((MyFile)resource).getWriteConcern(), ((MyFile)resource).getReadPreference()) : this.io.createGFSFileObject(((MyFile)resource).getInputStream());
        this.fillInputFile(resource, bucket, name, dir, f2, idFile);
        this.io.saveGFSFileObject(f2);
        ((MyFile)resource).getInputStream().close();
        ((MyFile)resource).setInputStream(null);
        return f2;
    }

    private void fillInputFile(Object resource, String bucket, String name, String dir, GridFSInputFile f2, ObjectId id) {
        String mime;
        if (id != null) {
            f2.put("_id", new ObjectId(id.toString()));
        }
        if (bucket.contains("/")) {
            f2.put("filename", bucket);
        }
        f2.put("type", "file");
        if (name != null) {
            f2.put("name", name);
        }
        if (dir != null) {
            f2.put("dir", dir);
        }
        if (((MyFile)resource).getOwner() != null) {
            f2.put("owner", ((MyFile)resource).getOwner());
        }
        if ((mime = ((MyFile)resource).getMimeType()) != null) {
            f2.put("mimetype", mime);
        }
        f2.put("creationTime", DateUtils.now("dd MM yyyy 'at' hh:mm:ss z"));
        this.updateCommonFields(f2, (MyFile)resource, null);
    }

    private void download(GridFS gfs, MyFile resource, GridFSDBFile f, boolean isLock) throws IOException {
        OperationDefinition op = resource.getOperationDefinition();
        this.logger.info("MongoClient download method: " + op.toString());
        while (f != null && f.containsField("link") && f.get("link") != null) {
            BasicDBObject query = new BasicDBObject();
            query.put("_id", new ObjectId((String)f.get("link")));
            f = gfs.findOne(query);
        }
        this.updateCommonFields(f, resource, OperationDefinition.OPERATION.DOWNLOAD);
        f.save();
        if (resource.getLocalPath() != null && !resource.getLocalPath().isEmpty()) {
            this.io.readByPath(resource, f, isLock, 0);
            this.close();
        } else if (resource.getOutputStream() != null) {
            this.io.readByOutputStream(resource, f, isLock, 0);
            this.close();
        }
        if (resource != null && resource.getType() != null && resource.getType().equalsIgnoreCase("input")) {
            this.io.readByInputStream(resource, f, isLock, 0);
        }
    }

    private void removeObject(GridFS gfs, BasicDBObject query, MyFile resource) {
        List<GridFSDBFile> list = gfs.find(query);
        for (GridFSDBFile f : list) {
            if (f != null) {
                this.checkAndRemove(f, resource);
                continue;
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug("File Not Found");
        }
    }

    private void setGenericProperties(MyFile resource, String destination, String dir, GridFSInputFile destinationFile, String name) {
        this.updateCommonFields(destinationFile, resource, null);
        destinationFile.put("filename", destination);
        destinationFile.put("type", "file");
        destinationFile.put("name", name);
        destinationFile.put("dir", dir);
        destinationFile.put("owner", resource.getOwner());
        destinationFile.put("mimetype", resource.getMimeType());
        destinationFile.put("creationTime", DateUtils.now("dd MM yyyy 'at' hh:mm:ss z"));
    }

    private BasicDBObject setGenericMoveProperties(MyFile resource, String filename, String dir, String name, BasicDBObject f) {
        f.append("filename", filename).append("type", "file").append("name", name).append("dir", dir);
        return f;
    }

    @Override
    public String getName() {
        return "MongoDB";
    }

    @Override
    public List<String> copyDir(MyFile resource, String sourcePath, String destinationPath) throws UnknownHostException {
        String source = sourcePath;
        source = this.appendFileSeparator(source);
        String destination = destinationPath;
        destination = this.appendFileSeparator(destination);
        String parentFolder = this.extractParent(source);
        String destinationId = null;
        ArrayList<String> idList = null;
        this.logger.debug("copyDir operation on Mongo backend, parameters: source path: " + source + " destination path: " + destination);
        if (source != null && !source.isEmpty() && destination != null && !destination.isEmpty()) {
            DB db = this.getDB(resource);
            GridFS gfs = new GridFS(db);
            BasicDBObject query = new BasicDBObject();
            query.put("dir", new BasicDBObject("$regex", source + "*"));
            List<GridFSDBFile> folder = gfs.find(query);
            if (folder != null) {
                idList = new ArrayList<String>(folder.size());
                for (GridFSDBFile f : folder) {
                    if (!f.get("type").equals("file")) continue;
                    String oldFilename = (String)f.get("filename");
                    String oldDir = (String)f.get("dir");
                    f = this.io.retrieveLinkPayload(f);
                    InputStream is = f.getInputStream();
                    int relativePathIndex = source.length();
                    String relativeDirTree = parentFolder + "/" + oldDir.substring(relativePathIndex);
                    String relativePath = parentFolder + "/" + oldFilename.substring(relativePathIndex);
                    String filename = destination + relativePath;
                    String dir = destination + relativeDirTree;
                    GridFSInputFile destinationFile = gfs.createFile(is);
                    destinationFile.put("filename", filename);
                    destinationFile.put("type", "file");
                    destinationFile.put("dir", dir);
                    this.updateCommonFields(destinationFile, resource, OperationDefinition.OPERATION.COPY_DIR);
                    idList.add(destinationFile.getId().toString());
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("ObjectId: " + destinationId);
                    }
                    this.io.buildDirTree(this.io.getMetaDataCollection(db), dir);
                    destinationFile.save();
                }
            }
            this.close();
        }
        return idList;
    }

    private DB getDB(MyFile resource) {
        DB db = null;
        db = resource.getGcubeMemoryType() == MemoryType.VOLATILE ? this.io.getDB() : this.io.getDB(resource.getWriteConcern(), resource.getReadPreference());
        return db;
    }

    @Override
    public List<String> moveDir(MyFile resource, String sourcePath, String destinationPath) throws UnknownHostException {
        String source = sourcePath;
        source = this.appendFileSeparator(source);
        String parentFolder = this.extractParent(source);
        String destination = destinationPath;
        destination = this.appendFileSeparator(destination);
        ArrayList<String> idList = null;
        this.logger.debug("moveDir operation on Mongo backend, parameters: source path: " + source + " destination path: " + destination);
        if (source != null && !source.isEmpty() && destination != null && !destination.isEmpty()) {
            DB db = this.io.getDB(resource.getWriteConcern(), resource.getReadPreference());
            DBCollection meta = this.io.getMetaDataCollection(db);
            BasicDBObject query = new BasicDBObject();
            query.put("dir", new BasicDBObject("$regex", source + "*"));
            DBCursor folderCursor = meta.find(query);
            if (folderCursor != null) {
                idList = new ArrayList<String>();
                while (folderCursor.hasNext()) {
                    DBObject f = folderCursor.next();
                    if (!f.get("type").equals("file")) continue;
                    String oldFilename = (String)f.get("filename");
                    String oldDir = (String)f.get("dir");
                    int relativePathIndex = source.length();
                    String relativeDirTree = parentFolder + "/" + oldDir.substring(relativePathIndex);
                    String relativePath = parentFolder + "/" + oldFilename.substring(relativePathIndex);
                    String filename = destination + relativePath;
                    String dir = destination + relativeDirTree;
                    f.put("filename", filename);
                    f.put("dir", dir);
                    this.updateCommonFields(f, resource, OperationDefinition.OPERATION.MOVE_DIR);
                    String id = f.get("_id").toString();
                    idList.add(id);
                    query = new BasicDBObject();
                    query.put("_id", new ObjectId(id));
                    if (this.memoryType != MemoryType.VOLATILE) {
                        meta.update(query, f, true, false, MongoIO.DEFAULT_WRITE_TYPE);
                    } else {
                        meta.update(query, f, true, false);
                    }
                    this.io.buildDirTree(meta, dir);
                }
            }
        } else {
            this.close();
            throw new IllegalArgumentException("parameters not completed, source: " + source + ", destination: " + destination);
        }
        this.close();
        return idList;
    }

    private String extractParent(String source) {
        source = source.substring(0, source.length() - 1);
        String parent = source.substring(source.lastIndexOf("/") + 1);
        this.logger.debug("parent folder extracted: " + parent);
        return parent;
    }

    private String appendFileSeparator(String source) {
        if (source.lastIndexOf("/") != source.length() - 1) {
            source = source + "/";
        }
        return source;
    }

    @Override
    public String getFileProperty(String remotePath, String property) {
        GridFSDBFile f = this.io.retrieveRemoteObject(remotePath, false);
        if (f != null) {
            String value = (String)f.get(property);
            this.close();
            return value;
        }
        this.close();
        throw new RemoteBackendException("remote file not found at path: " + remotePath);
    }

    @Override
    public String setFileProperty(String remotePath, String propertyField, String propertyValue) {
        this.logger.trace("setting field " + propertyField + " with value: " + propertyValue);
        try {
            this.logger.debug("find object...");
            BasicDBObject remoteMetaCollectionObject = this.io.findMetaCollectionObject(remotePath);
            if (remoteMetaCollectionObject != null) {
                this.logger.debug("object found");
                remoteMetaCollectionObject.put(propertyField, propertyValue);
                this.logger.info("set query field: " + propertyField + " with value: " + propertyValue);
                BasicDBObject updateQuery = new BasicDBObject();
                updateQuery.put("$set", remoteMetaCollectionObject);
                BasicDBObject querySourceObject = new BasicDBObject();
                this.logger.debug("check identifier object: " + remotePath);
                if (ObjectId.isValid(remotePath)) {
                    this.logger.debug("object is a valid id");
                    querySourceObject.put("_id", new ObjectId(remotePath));
                } else {
                    this.logger.debug("object is a remotepath");
                    querySourceObject.put("filename", remotePath);
                }
                this.logger.debug("get Collection ");
                DBCollection metaCollectionInstance = this.io.getMetaDataCollection(this.io.getDB(null, null));
                this.logger.debug("update Collection ");
                if (this.memoryType != MemoryType.VOLATILE) {
                    metaCollectionInstance.update(querySourceObject, updateQuery, false, true, MongoIO.DEFAULT_WRITE_TYPE);
                } else {
                    metaCollectionInstance.update(querySourceObject, updateQuery, false, true);
                }
                this.logger.info("update completed");
                this.close();
                return null;
            }
            this.logger.debug("object not found");
            this.close();
            throw new RemoteBackendException("remote file not found at path: " + remotePath);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            throw new RemoteBackendException("UnknownHostException:  " + e.getMessage());
        }
    }

    @Override
    public long getFolderTotalItems(String folderPath) {
        this.logger.debug("getFolderTotalItems for folder " + folderPath);
        long totalItems = 0L;
        try {
            List<GridFSDBFile> list = this.retrieveRemoteFileObject(folderPath);
            totalItems = this.getCount(list);
            this.logger.info("getFolderTotalItems found " + list.size() + " objects for folder " + folderPath);
        }
        catch (Exception e) {
            this.close();
            throw new RemoteBackendException(e.getMessage());
        }
        return totalItems;
    }

    @Override
    public long getFolderTotalVolume(String folderPath) {
        this.logger.debug("getFolderTotalVolume for folder " + folderPath);
        long totalVolume = 0L;
        try {
            List<GridFSDBFile> list = this.retrieveRemoteFileObject(folderPath);
            totalVolume = this.getVolume(list);
            this.logger.info("getFolderTotalVolume  " + totalVolume + " for folder " + folderPath);
        }
        catch (Exception e) {
            this.close();
            throw new RemoteBackendException(e.getMessage());
        }
        return totalVolume;
    }

    @Override
    public String getUserTotalVolume(String user) {
        this.logger.debug("getUserTotalVolume for folder " + user);
        long volume = 0L;
        try {
            List<GridFSDBFile> list = this.retrieveUsersFileObject(user);
            volume = this.getVolume(list);
            this.logger.info("getUserTotalVolume found " + volume + " for user " + user);
        }
        catch (Exception e) {
            this.close();
            throw new RemoteBackendException(e.getMessage());
        }
        return "" + volume;
    }

    @Override
    public String getUserTotalItems(String user) {
        this.logger.debug("getUserTotalItems for folder " + user);
        long count = 0L;
        try {
            List<GridFSDBFile> list = this.retrieveUsersFileObject(user);
            this.logger.info("getUserTotalItems found " + list.size() + " objects for user " + user);
            count = this.getCount(list);
        }
        catch (Exception e) {
            this.close();
            throw new RemoteBackendException(e.getMessage());
        }
        return "" + count;
    }

    private List<GridFSDBFile> retrieveRemoteFileObject(String folderPath) {
        GridFS gfs = new GridFS(this.io.getDB(null, null));
        BasicDBObject queryFile = new BasicDBObject();
        queryFile.put("dir", Pattern.compile(folderPath + "*"));
        List<GridFSDBFile> list = gfs.find(queryFile);
        this.logger.info("retrieveRemoteFileObject found " + list.size() + " objects ");
        this.close();
        return list;
    }

    private List<GridFSDBFile> retrieveUsersFileObject(String username) {
        GridFS gfs = new GridFS(this.io.getDB(null, null));
        BasicDBObject queryFile = new BasicDBObject();
        queryFile.put("owner", username);
        List<GridFSDBFile> list = gfs.find(queryFile);
        this.logger.info("retrieveUsersFileObjectfound " + list.size() + " objects ");
        this.close();
        return list;
    }

    private long getCount(List<GridFSDBFile> list) {
        return list.size();
    }

    private long getVolume(List<GridFSDBFile> list) {
        long partialVolume = 0L;
        for (GridFSDBFile f : list) {
            long fileVolume = f.getLength();
            partialVolume += fileVolume;
        }
        return partialVolume;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public String getId(String path, boolean forceCreation) {
        GridFSDBFile f;
        ObjectId id = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("MongoDB - pathServer: " + path);
        }
        if ((f = this.io.retrieveRemoteObject(path, true)) != null) {
            id = (ObjectId)f.getId();
        } else {
            if (!forceCreation) {
                this.close();
                throw new RemoteBackendException("the file " + path + " is not present on storage. The uri is not created ");
            }
            this.logger.warn("The remote file doesn't exist. An empty file will be created");
            if (ObjectId.isValid(path)) {
                this.logger.error("Cannot force creation of smp uri without a remote path. The input parameter is not a remotePath valid: " + path);
                this.close();
                throw new RemoteBackendException("The uri is not created. Cannot force creation of smp uri without a remote path. The input parameter is not a remotePath:  " + path);
            }
            byte[] data = new byte[1];
            GridFSInputFile f2 = null;
            f2 = path.startsWith("/VOLATILE") ? this.io.createGFSFileObject(data) : this.io.createGFSFileObject(data, null, null);
            int indexName = path.lastIndexOf("/");
            String name = path.substring(indexName + 1);
            String dir = path.substring(0, indexName + 1);
            f2.put("filename", path);
            f2.put("name", name);
            f2.put("dir", dir);
            id = (ObjectId)f2.getId();
            f2.save();
            this.close();
        }
        this.close();
        return id.toString();
    }

    @Override
    public boolean isValidId(String id) {
        return ObjectId.isValid(id);
    }

    @Override
    public String getField(String remoteIdentifier, String fieldName) throws UnknownHostException {
        GridFSDBFile f;
        String fieldValue = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("MongoDB - pathServer: " + remoteIdentifier);
        }
        if ((f = this.io.retrieveRemoteObject(remoteIdentifier, true)) != null) {
            fieldValue = f.get(fieldName).toString();
        }
        this.close();
        return fieldValue;
    }

    private BasicDBObject setCommonFields(BasicDBObject f, MyFile resource, OperationDefinition.OPERATION op) {
        String owner = resource.getOwner();
        if (op == null) {
            op = resource.getOperationDefinition().getOperation();
        }
        this.logger.info("set last operation: " + (Object)((Object)op));
        String from = null;
        if (op.toString().equalsIgnoreCase(OperationDefinition.OPERATION.MOVE.toString())) {
            from = resource.getLocalPath();
        }
        String address = null;
        try {
            address = InetAddress.getLocalHost().getCanonicalHostName().toString();
            f.put("callerIP", address);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (from == null) {
            f.append("lastAccess", DateUtils.now("dd MM yyyy 'at' hh:mm:ss z")).append("lastUser", owner).append("lastOperation", op.toString()).append("callerIP", address);
        } else {
            f.append("lastAccess", DateUtils.now("dd MM yyyy 'at' hh:mm:ss z")).append("lastUser", owner).append("lastOperation", op.toString()).append("callerIP", address).append("from", from);
        }
        return f;
    }

    private void updateCommonFields(DBObject f, MyFile resource, OperationDefinition.OPERATION op) {
        f.put("lastAccess", DateUtils.now("dd MM yyyy 'at' hh:mm:ss z"));
        String owner = resource.getOwner();
        f.put("lastUser", owner);
        if (op == null) {
            op = resource.getOperationDefinition().getOperation();
        }
        this.logger.info("set last operation: " + (Object)((Object)op));
        f.put("lastOperation", op.toString());
        if (op.toString().equalsIgnoreCase(OperationDefinition.OPERATION.MOVE.toString())) {
            f.put("from", resource.getLocalPath());
        }
        String address = null;
        try {
            address = InetAddress.getLocalHost().getCanonicalHostName().toString();
            f.put("callerIP", address);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    private void checkTTL(GridFSDBFile f) throws IllegalAccessError {
        if (f.containsField("timestamp") && f.get("timestamp") != null) {
            long timestamp = (Long)f.get("timestamp");
            long currentTTL = System.currentTimeMillis() - timestamp;
            this.close();
            throw new IllegalAccessError("the file is locked currentTTL: " + currentTTL + "TTL bound " + 180000L);
        }
        this.checkTTL(f);
    }

    private boolean isTTLUnlocked(GridFSDBFile f) {
        if (f.get("timestamp") == null) {
            return true;
        }
        long timestamp = (Long)f.get("timestamp");
        this.logger.debug("timestamp found: " + timestamp);
        if (timestamp != 0L) {
            long currentTTL = System.currentTimeMillis() - timestamp;
            this.logger.debug("currentTTL: " + currentTTL + " TTL stabilito: " + 180000L);
            if (180000L < currentTTL) {
                f.put("timestamp", null);
                return true;
            }
            return false;
        }
        return true;
    }
}

