/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.io.FilenameUtils;
import org.apache.jackrabbit.util.ISO9075;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.MetadataProperty;
import org.gcube.common.homelibary.model.items.SearchItemDelegate;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.gcube.common.homelibary.model.items.type.WorkspaceItemType;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceInternalLink;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.accessmanager.ACLType;
import org.gcube.common.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongItemTypeException;
import org.gcube.common.homelibrary.home.workspace.folder.FolderBulkCreator;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItem;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalFile;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalImage;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalPDFFile;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalUrl;
import org.gcube.common.homelibrary.home.workspace.folder.items.Query;
import org.gcube.common.homelibrary.home.workspace.folder.items.QueryType;
import org.gcube.common.homelibrary.home.workspace.folder.items.Report;
import org.gcube.common.homelibrary.home.workspace.folder.items.ReportTemplate;
import org.gcube.common.homelibrary.home.workspace.folder.items.ts.TimeSeries;
import org.gcube.common.homelibrary.jcr.repository.external.GCUBEStorage;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceItem;
import org.gcube.common.homelibrary.jcr.workspace.accessmanager.JCRPrivilegesInfo;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryDisabledPublicAccess;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryEnabledPublicAccess;
import org.gcube.common.homelibrary.jcr.workspace.servlet.JCRSession;
import org.gcube.common.homelibrary.jcr.workspace.servlet.wrapper.DelegateManager;
import org.gcube.common.homelibrary.jcr.workspace.util.MetaInfo;
import org.gcube.common.homelibrary.jcr.workspace.util.WorkspaceItemUtil;
import org.gcube.common.homelibrary.model.exceptions.RepositoryException;

public abstract class JCRAbstractWorkspaceFolder
extends JCRWorkspaceItem
implements WorkspaceFolder {
    protected static final String GUEST = "guest";

    public JCRAbstractWorkspaceFolder(JCRWorkspace workspace, ItemDelegate delegate) throws RepositoryException {
        super(workspace, delegate);
    }

    public JCRAbstractWorkspaceFolder(JCRWorkspace workspace, ItemDelegate node, String name, String description) throws RepositoryException {
        super(workspace, node, name, description);
    }

    @Override
    public String getRemotePath() throws InternalErrorException {
        String remotePath = null;
        List<WorkspaceItem> children = this.getChildren();
        for (WorkspaceItem child : children) {
            if (child.isFolder()) continue;
            String path = child.getRemotePath();
            remotePath = path.substring(0, path.lastIndexOf(47) + 1);
            break;
        }
        return remotePath;
    }

    public JCRWorkspace getWorkspace() {
        return this.workspace;
    }

    @Override
    public abstract WorkspaceItemType getType();

    @Override
    public boolean exists(String name) throws InternalErrorException {
        if (!JCRPrivilegesInfo.canReadNode(this.getOwner().getPortalLogin(), this.workspace.getOwner().getPortalLogin(), this.getAbsolutePath())) {
            throw new InternalErrorException("Insufficient Privileges to READ the node " + this.getAbsolutePath() + " for user " + this.workspace.getOwner().getPortalLogin());
        }
        try {
            return this.workspace.exists(name, this.getId());
        }
        catch (ItemNotFoundException e) {
            throw new InternalErrorException(e);
        }
        catch (WrongItemTypeException e) {
            throw new InternalErrorException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkspaceItem find(String name) throws InternalErrorException {
        if (!JCRPrivilegesInfo.canReadNode(this.getOwner().getPortalLogin(), this.workspace.getOwner().getPortalLogin(), this.getAbsolutePath())) {
            throw new InternalErrorException("Insufficient Privileges to READ the node " + this.getAbsolutePath() + " for user " + this.workspace.getOwner().getPortalLogin());
        }
        JCRSession servlets = null;
        try {
            servlets = new JCRSession(this.getOwner().getPortalLogin(), false);
            DelegateManager wrap = new DelegateManager(this.getDelegate(), this.getOwner().getPortalLogin());
            ItemDelegate node = wrap.getNode(name);
            JCRWorkspaceItem jCRWorkspaceItem = this.workspace.getWorkspaceItem(node);
            return jCRWorkspaceItem;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException(e);
        }
        catch (ItemNotFoundException e) {
            WorkspaceItem workspaceItem = null;
            return workspaceItem;
        }
        finally {
            servlets.releaseSession();
        }
    }

    @Override
    public List<WorkspaceItem> getHiddenChildren() throws InternalErrorException {
        if (!JCRPrivilegesInfo.canReadNode(this.getOwner().getPortalLogin(), this.workspace.getOwner().getPortalLogin(), this.getAbsolutePath())) {
            throw new InternalErrorException("Insufficient Privileges to READ the node " + this.getAbsolutePath() + " for user " + this.workspace.getOwner().getPortalLogin());
        }
        ArrayList<WorkspaceItem> children = new ArrayList<WorkspaceItem>();
        JCRSession servlets = null;
        try {
            servlets = new JCRSession(this.workspace.getOwner().getPortalLogin(), false);
            List<ItemDelegate> folderNode = servlets.GetHiddenItemsById(this.getId());
            for (ItemDelegate itemDelegate : folderNode) {
                JCRWorkspaceItem item = this.workspace.getWorkspaceItem(itemDelegate);
                children.add(item);
            }
        }
        catch (Exception e) {
            throw new InternalErrorException("No nodes retrieved", e);
        }
        finally {
            servlets.releaseSession();
        }
        return children;
    }

    @Override
    public List<WorkspaceItem> getChildren() throws InternalErrorException {
        return this.getChildren(false);
    }

    @Override
    public List<WorkspaceItem> getChildren(boolean showHidden) throws InternalErrorException {
        if (!JCRPrivilegesInfo.canReadNode(this.getOwner().getPortalLogin(), this.workspace.getOwner().getPortalLogin(), this.getAbsolutePath())) {
            throw new InternalErrorException("Insufficient Privileges to READ the node " + this.getAbsolutePath() + " for user " + this.workspace.getOwner().getPortalLogin());
        }
        ArrayList<WorkspaceItem> children = new ArrayList<WorkspaceItem>();
        JCRSession servlets = null;
        try {
            servlets = new JCRSession(this.workspace.getOwner().getPortalLogin(), false);
            List<ItemDelegate> folderNode = servlets.getChildrenById(this.getId(), showHidden);
            for (ItemDelegate itemDelegate : folderNode) {
                JCRWorkspaceItem item = this.workspace.getWorkspaceItem(itemDelegate);
                children.add(item);
            }
        }
        catch (Exception e) {
            throw new InternalErrorException("No children retrieved for path " + this.getAbsolutePath(), e);
        }
        finally {
            if (servlets != null) {
                servlets.releaseSession();
            }
        }
        return children;
    }

    @Override
    public WorkspaceFolder createFolder(String name, String description) throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        if (!JCRPrivilegesInfo.canAddChildren(this.getOwner().getPortalLogin(), this.workspace.getOwner().getPortalLogin(), this.getAbsolutePath())) {
            throw new InternalErrorException("Insufficient Privileges to ADD nodes on " + this.getAbsolutePath() + " for user " + this.workspace.getOwner().getPortalLogin());
        }
        try {
            return this.workspace.createFolder(name, description, this.getId());
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException(e);
        }
        catch (ItemNotFoundException e) {
            throw new InternalErrorException(e);
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException(e);
        }
    }

    public ExternalFile createExternalFileItem(String name, String description, MetaInfo info, Map<String, String> properties) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        try {
            return this.workspace.createExternalFile(name, description, info, this.getDelegate(), properties);
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException(e);
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException(e);
        }
    }

    public ExternalImage createExternalImageItem(String name, String description, MetaInfo info, Map<String, String> properties) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        try {
            return this.workspace.createExternalImage(name, description, info, this.getDelegate(), properties);
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException(e);
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException(e);
        }
    }

    public ExternalPDFFile createExternalPDFFileItem(String name, String description, MetaInfo info, Map<String, String> properties) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        try {
            return this.workspace.createExternalPDFFile(name, description, info, this.getDelegate(), properties);
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException(e);
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException(e);
        }
    }

    @Override
    public ExternalImage createExternalImageItem(String name, String description, String mimeType, InputStream imageData) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        MetaInfo info = null;
        try {
            info = WorkspaceItemUtil.getMetadataInfo(imageData, this.workspace.getStorage(), this.getAbsolutePath() + "/" + name, name);
        }
        catch (IOException e1) {
            throw new InternalErrorException("A problem occured getting metadata of " + this.getAbsolutePath() + "/" + name);
        }
        return this.createExternalImageItem(name, description, info, new HashMap<String, String>());
    }

    @Override
    public ExternalImage createExternalImageItem(String name, String description, String mimeType, File imageData) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        FileInputStream is = null;
        ExternalImage image = null;
        try {
            is = new FileInputStream(imageData);
            image = this.createExternalImageItem(name, description, mimeType, is);
            ((InputStream)is).close();
        }
        catch (FileNotFoundException e) {
            throw new InternalErrorException("File not found " + e);
        }
        catch (IOException e) {
            throw new InternalErrorException(e);
        }
        return image;
    }

    @Override
    public ExternalFile createExternalFileItem(String name, String description, String mimeType, InputStream fileData) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        try {
            return this.workspace.createExternalFile(name, description, mimeType, fileData, this.getId());
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException(e);
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException(e);
        }
    }

    @Override
    public FolderItem createExternalFileItem(String name, String description, String storageId, String mimeType) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        FolderItem file;
        InputStream is = null;
        try {
            is = this.workspace.getStorage().getRemoteFile(storageId);
            file = this.createExternalGenericItem(name, description, is, null, mimeType, 0L);
        }
        catch (Exception e) {
            throw new InternalErrorException("A problem occured creting external file item " + this.getAbsolutePath() + "/" + name);
        }
        return file;
    }

    @Override
    public ExternalPDFFile createExternalPDFFileItem(String name, String description, String mimeType, InputStream fileData) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        MetaInfo info = null;
        try {
            info = WorkspaceItemUtil.getMetadataInfo(fileData, this.workspace.getStorage(), this.getAbsolutePath() + "/" + name, name);
        }
        catch (IOException e1) {
            throw new InternalErrorException("A problem occured getting metadata of " + this.getAbsolutePath() + "/" + name);
        }
        return this.createExternalPDFFileItem(name, description, info, new HashMap<String, String>());
    }

    @Override
    public ExternalUrl createExternalUrlItem(String name, String description, String url) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        try {
            return this.workspace.createExternalUrl(name, description, url, this.getId());
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException(e);
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException(e);
        }
    }

    @Override
    public ExternalUrl createExternalUrlItem(String name, String description, InputStream is) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        try {
            return this.workspace.createExternalUrl(name, description, is, this.getId());
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException(e);
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException(e);
        }
    }

    @Override
    public FolderBulkCreator getNewFolderBulkCreator() throws InternalErrorException {
        try {
            return this.workspace.getNewFolderBulkCreator(this.getId());
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException(e);
        }
        catch (WrongItemTypeException e) {
            throw new InternalErrorException(e);
        }
    }

    @Override
    public void removeChild(WorkspaceItem child) throws InternalErrorException, InsufficientPrivilegesException {
        try {
            this.workspace.removeItem(child.getId());
        }
        catch (ItemNotFoundException e) {
            throw new InternalErrorException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getUniqueName(String filename, boolean copy) throws InternalErrorException {
        block15: {
            JCRSession servlets = null;
            try {
                int i;
                servlets = new JCRSession(this.workspace.getOwner().getPortalLogin(), false);
                ItemDelegate folderNode = servlets.getItemById(this.getId());
                WorkspaceItem item = null;
                boolean isFolder = false;
                String ext = null;
                try {
                    item = this.getNode(folderNode, filename);
                    isFolder = item.isFolder();
                    if (!isFolder) {
                        ext = FilenameUtils.getExtension(filename);
                        filename = FilenameUtils.removeExtension(filename);
                    }
                }
                catch (Exception e) {
                    String string = filename;
                    servlets.releaseSession();
                    return string;
                }
                String name = null;
                if (item == null) break block15;
                if (copy) {
                    i = 1;
                    while (item != null) {
                        name = i == 1 ? filename + " (copy)" : filename + " (copy " + i + ")";
                        if (!isFolder) {
                            name = name + "." + ext;
                        }
                        item = this.getNode(folderNode, name);
                        ++i;
                    }
                } else {
                    i = 0;
                    while (item != null) {
                        name = filename + " (" + i + ")";
                        if (!isFolder) {
                            name = name + "." + ext;
                        }
                        item = this.getNode(folderNode, name);
                        ++i;
                    }
                }
                String string = name;
                return string;
            }
            catch (Exception e) {
                logger.error("problem creating a unique name for " + filename);
            }
            finally {
                servlets.releaseSession();
            }
        }
        return filename;
    }

    private WorkspaceItem getNode(ItemDelegate folderNode, String initialName) throws RepositoryException {
        WorkspaceItem item = null;
        DelegateManager wrap = new DelegateManager(folderNode, this.workspace.getOwner().getPortalLogin());
        try {
            ItemDelegate node = wrap.getNode(initialName);
            item = this.workspace.getItem(node.getId());
        }
        catch (Exception e) {
            logger.info("No item found with name \"" + initialName + "\" in folder " + folderNode.getPath());
            return null;
        }
        return item;
    }

    @Override
    public int getCount() throws InternalErrorException {
        String remotePath = null;
        try {
            remotePath = this.getRemotePath();
        }
        catch (Exception e) {
            logger.error("Impossible to get total items count of " + this.getName());
        }
        if (remotePath != null) {
            return this.workspace.getStorage().getFolderTotalItems(remotePath);
        }
        return 0;
    }

    @Override
    public long getSize() throws InternalErrorException {
        String remotePath = null;
        try {
            remotePath = this.getRemotePath();
        }
        catch (Exception e) {
            logger.error("Impossible to get total size of " + this.getName());
        }
        if (remotePath != null) {
            return this.workspace.getStorage().getFolderTotalVolume(remotePath);
        }
        return 0L;
    }

    @Override
    public List<WorkspaceItem> getLastItems(int limit) throws InternalErrorException {
        if (!JCRPrivilegesInfo.canReadNode(this.getOwner().getPortalLogin(), this.workspace.getOwner().getPortalLogin(), this.getAbsolutePath())) {
            throw new InternalErrorException("Insufficient Privileges to READ the node " + this.getAbsolutePath() + " for user " + this.workspace.getOwner().getPortalLogin());
        }
        JCRSession servlets = null;
        LinkedList<WorkspaceItem> list = null;
        ArrayList<String> ids = null;
        try {
            servlets = new JCRSession(this.workspace.getOwner().getPortalLogin(), false);
            String path = this.getPath();
            String query = "/jcr:root/Home/" + this.workspace.getOwner().getPortalLogin() + ISO9075.encodePath(path) + "//element(*,nthl:workspaceItem) order by @jcr:lastModified descending";
            logger.info("Query: " + query);
            List<SearchItemDelegate> itemDelegateList = null;
            try {
                itemDelegateList = servlets.executeQuery(query, "xpath", limit);
            }
            catch (HttpException e) {
                throw new InternalErrorException(e);
            }
            catch (IOException e) {
                throw new InternalErrorException(e);
            }
            list = new LinkedList<WorkspaceItem>();
            ids = new ArrayList<String>();
            int i = 0;
            for (SearchItemDelegate searchItem : itemDelegateList) {
                if (i >= limit) continue;
                String type = searchItem.getPrimaryType();
                try {
                    String id;
                    if (type.equals("nthl:workspaceItem") || type.equals("nthl:workspaceSharedItem") || type.equals("nthl:trashItem") || ids.contains(id = searchItem.getId())) continue;
                    list.add(this.workspace.getItem(id));
                    ids.add(id);
                    ++i;
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            logger.error("Error getLastItems ", (Throwable)e);
            throw new InternalErrorException(e);
        }
        finally {
            servlets.releaseSession();
        }
        return list;
    }

    @Override
    public ReportTemplate createReportTemplateItem(String name, String description, Calendar created, Calendar lastEdit, String author, String lastEditBy, int numberOfSections, String status, InputStream templateData) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        try {
            return this.workspace.createReportTemplate(name, description, created, lastEdit, author, lastEditBy, numberOfSections, status, templateData, this.getId());
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException(e);
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException(e);
        }
    }

    @Override
    public Report createReportItem(String name, String description, Calendar created, Calendar lastEdit, String author, String lastEditBy, String templateName, int numberOfSections, String status, InputStream reportData) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        try {
            return this.workspace.createReport(name, description, created, lastEdit, author, lastEditBy, templateName, numberOfSections, status, reportData, this.getId());
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException(e);
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException(e);
        }
    }

    @Override
    public Query createQueryItem(String name, String description, String query, QueryType queryType) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        try {
            return this.workspace.createQuery(name, description, query, queryType, this.getId());
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException(e);
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException(e);
        }
    }

    @Override
    public Query createQueryItem(String name, String description, InputStream query, QueryType queryType) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        try {
            return this.workspace.createQuery(name, description, query, queryType, this.getId());
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException(e);
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException(e);
        }
    }

    @Override
    public TimeSeries createTimeSeries(String name, String description, String timeseriesId, String title, String creator, String timeseriesDescription, String timeseriesCreationDate, String publisher, String sourceId, String sourceName, String rights, long dimension, List<String> headerLabels, InputStream compressedCSV) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        try {
            return this.workspace.createTimeSeries(name, description, timeseriesId, title, creator, timeseriesDescription, timeseriesCreationDate, publisher, sourceId, sourceName, rights, dimension, headerLabels, compressedCSV, this.getId());
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException(e);
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException(e);
        }
    }

    @Override
    public ExternalFile createExternalFileItem(String name, String description, String mimeType, File fileData) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        FileInputStream is = null;
        ExternalFile file = null;
        try {
            is = new FileInputStream(fileData);
            file = this.createExternalFileItem(name, description, mimeType, is);
            ((InputStream)is).close();
        }
        catch (FileNotFoundException e) {
            throw new InternalErrorException("File not found " + e);
        }
        catch (IOException e) {
            throw new InternalErrorException(e);
        }
        return file;
    }

    @Override
    public ExternalPDFFile createExternalPDFFileItem(String name, String description, String mimeType, File fileData) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        FileInputStream is = null;
        ExternalPDFFile pdf = null;
        try {
            is = new FileInputStream(fileData);
            pdf = this.createExternalPDFFileItem(name, description, mimeType, is);
            ((InputStream)is).close();
        }
        catch (FileNotFoundException e) {
            throw new InternalErrorException("File not found " + e);
        }
        catch (IOException e) {
            throw new InternalErrorException(e);
        }
        return pdf;
    }

    @Override
    public ExternalUrl createExternalUrlItem(String name, String description, File fileData) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        FileInputStream is = null;
        ExternalUrl url = null;
        try {
            is = new FileInputStream(fileData);
            url = this.createExternalUrlItem(name, description, is);
            ((InputStream)is).close();
        }
        catch (FileNotFoundException e) {
            throw new InternalErrorException("File not found " + e);
        }
        catch (IOException e) {
            throw new InternalErrorException(e);
        }
        return url;
    }

    @Override
    public FolderItem createExternalGenericItem(String name, String description, InputStream is) throws InsufficientPrivilegesException, ItemAlreadyExistException, InternalErrorException {
        return this.createExternalGenericItem(name, description, is, null, null, 0L);
    }

    @Override
    public FolderItem createExternalGenericItem(String name, String description, InputStream is, Map<String, String> properties) throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        MetaInfo info = null;
        try {
            info = WorkspaceItemUtil.getMetadataInfo(is, this.workspace.getStorage(), this.getAbsolutePath() + "/" + name, name);
        }
        catch (IOException e1) {
            throw new InternalErrorException("A problem occurred getting metadata of " + this.getAbsolutePath());
        }
        FolderItem fileItem = this.createItemInJackrabbit(name, description, info, properties, is);
        return fileItem;
    }

    @Override
    public FolderItem createExternalGenericItem(String name, String description, InputStream is, Map<String, String> properties, String mimetype, long size) throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        MetaInfo info = null;
        try {
            info = WorkspaceItemUtil.getMetadataInfo(is, this.workspace.getStorage(), this.getAbsolutePath() + "/" + name, name, mimetype, size);
        }
        catch (IOException e1) {
            throw new InternalErrorException("A problem occurred getting metadata of " + this.getAbsolutePath());
        }
        FolderItem fileItem = this.createItemInJackrabbit(name, description, info, properties, is);
        return fileItem;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private FolderItem createItemInJackrabbit(String name, String description, MetaInfo info, Map<String, String> properties, InputStream is) throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        long start01 = System.currentTimeMillis();
        if (info.getStorageId() == null) throw new InternalErrorException("A problem occurred saving the file into storage. The file cannot be created.");
        try {
            String mimeType = info.getMimeType();
            if (mimeType == null) return this.createExternalFileItem(name, description, info, properties);
            if (mimeType.startsWith("image")) {
                return this.createExternalImageItem(name, description, info, properties);
            }
            if (mimeType.equals("application/pdf")) {
                return this.createExternalPDFFileItem(name, description, info, properties);
            }
            if (!mimeType.equals("text/uri-list")) return this.createExternalFileItem(name, description, info, properties);
            return this.createExternalUrlItem(name, description, is);
        }
        catch (Exception e) {
            throw new InternalErrorException(e);
        }
    }

    @Override
    public FolderItem createExternalGenericItem(String name, String description, String storageId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        return this.createExternalGenericItem(name, description, storageId, null, null, 0L);
    }

    @Override
    public FolderItem createExternalGenericItem(String name, String description, String storageId, String mimetype) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        return this.createExternalGenericItem(name, description, storageId, null, mimetype, 0L);
    }

    @Override
    public FolderItem createExternalGenericItem(String name, String description, String storageId, Map<String, String> properties) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        return this.createExternalGenericItem(name, description, storageId, properties, null, 0L);
    }

    @Override
    public FolderItem createExternalGenericItem(String name, String description, String storageId, Map<String, String> properties, String mimeType, long size) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        InputStream is;
        GCUBEStorage storage = this.workspace.getStorage();
        try {
            is = storage.getRemoteFile(storageId);
        }
        catch (Exception e) {
            logger.error("Storage Id " + storageId + " not found");
            throw new InternalErrorException(e);
        }
        return this.createExternalGenericItem(name, description, is, properties, mimeType, size);
    }

    @Override
    public void setSystemFolder(boolean systemFolder) throws InternalErrorException {
        this.delegate.getProperties().put(NodeProperty.IS_SYSTEM_FOLDER, new XStream().toXML(systemFolder));
        try {
            this.save();
        }
        catch (RepositoryException e) {
            throw new InternalErrorException("Impossible to set systemFolder to " + systemFolder + " to item " + this.delegate.getPath());
        }
    }

    @Override
    public boolean isSystemFolder() throws InternalErrorException {
        Boolean isSystemFolder = false;
        try {
            isSystemFolder = (Boolean)new XStream().fromXML(this.delegate.getProperties().get((Object)NodeProperty.IS_SYSTEM_FOLDER));
        }
        catch (Exception e) {
            return false;
        }
        return isSystemFolder;
    }

    @Override
    public boolean isReferenced() throws InternalErrorException {
        List<String> references = this.getReferences();
        return references != null && references.size() > 0;
    }

    @Override
    public List<String> getReferences() throws InternalErrorException {
        List<String> references = null;
        JCRSession servlets = null;
        try {
            servlets = new JCRSession(this.workspace.getOwner().getPortalLogin(), false);
            references = servlets.getReferences(this.getId());
        }
        catch (RepositoryException e) {
            throw new InternalErrorException(e);
        }
        catch (Exception e) {
            throw new InternalErrorException(e);
        }
        finally {
            if (servlets != null) {
                servlets.releaseSession();
            }
        }
        return references;
    }

    @Override
    public WorkspaceInternalLink copyAsLink(String destinationFolderId) throws InternalErrorException {
        return this.workspace.copyAsLink(this.getId(), destinationFolderId);
    }

    @Override
    public boolean isPublic() throws InternalErrorException {
        boolean isPublic = false;
        if (this.getProperties().hasProperty(MetadataProperty.IS_PUBLIC.toString())) {
            isPublic = (Boolean)new XStream().fromXML(this.getProperties().getPropertyValue(MetadataProperty.IS_PUBLIC.toString()));
        }
        return isPublic;
    }

    @Override
    public void setPublic(boolean flag) throws InternalErrorException {
        logger.trace("Set " + this.getAbsolutePath() + " as public " + flag);
        ArrayList<String> users = new ArrayList<String>();
        users.add(GUEST);
        Calendar now = Calendar.getInstance();
        JCRSession session = null;
        try {
            session = new JCRSession(this.workspace.getOwner().getPortalLogin(), false);
            if (flag) {
                this.setACL(users, ACLType.READ_ONLY);
                logger.debug("Set ENABLED PUBLIC ACCESS accounting entry to destination folder " + this.getAbsolutePath());
                JCRAccountingEntryEnabledPublicAccess entryAdd = new JCRAccountingEntryEnabledPublicAccess(this.getId(), this.getOwner().getPortalLogin(), now, this.getName());
                entryAdd.save(session);
            } else {
                this.setACL(users, ACLType.NONE);
                logger.debug("Set ENABLED PUBLIC ACCESS accounting entry to destination folder " + this.getAbsolutePath());
                JCRAccountingEntryDisabledPublicAccess entryAdd = new JCRAccountingEntryDisabledPublicAccess(this.getId(), this.getOwner().getPortalLogin(), now, this.getName());
                entryAdd.save(session);
            }
            this.setItemDelegateAsPublic(flag);
        }
        catch (RepositoryException e) {
            throw new InternalErrorException(e);
        }
        catch (Exception e) {
            throw new InternalErrorException(e);
        }
        finally {
            if (session != null) {
                session.releaseSession();
            }
        }
    }

    private void setItemDelegateAsPublic(boolean flag) throws InternalErrorException {
        JCRSession servlets = null;
        try {
            servlets = new JCRSession(this.workspace.getOwner().getPortalLogin(), false);
            this.getProperties().addProperty(MetadataProperty.IS_PUBLIC.toString(), new XStream().toXML(flag));
        }
        catch (RepositoryException e) {
            throw new InternalErrorException(e);
        }
        catch (Exception e) {
            throw new InternalErrorException(e);
        }
        finally {
            servlets.releaseSession();
        }
    }
}

