/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.aggregator.plugin;

import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.view.ViewQuery;
import com.couchbase.client.java.view.ViewResult;
import com.couchbase.client.java.view.ViewRow;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.gcube.accounting.aggregator.configuration.Constant;
import org.gcube.accounting.aggregator.madeaggregation.Aggregation;
import org.gcube.accounting.aggregator.madeaggregation.AggregationType;
import org.gcube.accounting.aggregator.plugin.DesignID;
import org.gcube.accounting.aggregator.plugin.Utility;
import org.gcube.common.homelibrary.home.Home;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.HomeManager;
import org.gcube.common.homelibrary.home.HomeManagerFactory;
import org.gcube.common.homelibrary.home.User;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkSpaceManagement {
    public static Logger logger = LoggerFactory.getLogger(Aggregation.class);

    protected static boolean onSaveBackupFile(Bucket accountingBucket, String bucket, String scope, String startKeyString, String endKeyString, AggregationType aggType) throws Exception {
        String nameFile = "complete.json";
        String nameFileZip = "complete.zip";
        String namePathFile = Constant.PATH_DIR_BACKUP + "/" + nameFile;
        String namePathFileZip = Constant.PATH_DIR_BACKUP + "/" + nameFileZip;
        String subFolderName = "";
        subFolderName = scope == null ? endKeyString.replace(",", "-") + "_" + startKeyString.replace(",", "-") : scope.replace("/", "") + "_" + endKeyString.replace(",", "-") + "_" + startKeyString.replace(",", "-");
        try {
            int len;
            ViewResult viewResult;
            WorkspaceFolder wsRootDir = WorkSpaceManagement.init(Constant.user);
            WorkspaceFolder folderBucketName = WorkSpaceManagement.createFolder(Constant.user, wsRootDir.getId(), bucket, "Backup Folder");
            WorkspaceFolder folderTypeName = WorkSpaceManagement.createFolder(Constant.user, folderBucketName.getId(), aggType.name(), "Backup Folder");
            WorkspaceFolder folderStartTimeName = WorkSpaceManagement.createFolder(Constant.user, folderTypeName.getId(), subFolderName, "Backup Folder");
            DesignID designid = DesignID.valueOf(bucket);
            String designDocId = designid.getNameDesign();
            String viewName = "";
            viewName = scope != null ? designid.getNameViewScope() : designid.getNameView();
            JsonArray startKey = Utility.generateKey(scope, startKeyString);
            JsonArray endKey = Utility.generateKey(scope, endKeyString);
            ViewQuery query = ViewQuery.from((String)designDocId, (String)viewName);
            query.startKey(startKey);
            query.endKey(endKey);
            query.reduce(false);
            query.inclusiveEnd(false);
            try {
                viewResult = accountingBucket.query(query);
            }
            catch (Exception e) {
                logger.error(e.getLocalizedMessage());
                throw e;
            }
            BufferedWriter filebackup = null;
            File logFile = new File(namePathFile);
            logFile.delete();
            Thread.sleep(500L);
            filebackup = new BufferedWriter(new FileWriter(logFile));
            for (ViewRow row : viewResult) {
                if (row.document() == null || ((JsonObject)row.document().content()).toString().isEmpty()) continue;
                filebackup.write(((JsonObject)row.document().content()).toString());
                filebackup.newLine();
            }
            filebackup.close();
            byte[] buffer = new byte[1024];
            FileOutputStream fos = new FileOutputStream(namePathFileZip);
            ZipOutputStream zos = new ZipOutputStream(fos);
            ZipEntry ze = new ZipEntry(nameFile);
            zos.putNextEntry(ze);
            FileInputStream in = new FileInputStream(namePathFile);
            while ((len = in.read(buffer)) > 0) {
                zos.write(buffer, 0, len);
            }
            in.close();
            zos.closeEntry();
            zos.close();
            FileInputStream fileZipStream = new FileInputStream(namePathFileZip);
            WorkSpaceManagement.saveItemOnWorkspace(Constant.user, fileZipStream, "complete.zip", "Description", folderStartTimeName.getId());
            logger.trace("Save a backup file into workspace; bucket{},scope:{}, startkey:{},endkey:{}, aggregation type:{}", new Object[]{bucket, scope, startKeyString, endKeyString, aggType.toString()});
            logFile.delete();
            File logFileZip = new File(namePathFileZip);
            logFileZip.delete();
            return true;
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage());
            logger.error(e.getMessage());
            logger.error("onSaveBackupFile excepiton:{}", (Throwable)e);
            throw e;
        }
    }

    protected static WorkspaceFolder init(String user) throws Exception {
        try {
            HomeManagerFactory factory = HomeLibrary.getHomeManagerFactory();
            HomeManager manager = factory.getHomeManager();
            User userWS = manager.createUser(user);
            Home home = manager.getHome(userWS);
            Workspace ws = home.getWorkspace();
            WorkspaceFolder root = ws.getRoot();
            return root;
        }
        catch (Exception e) {
            logger.error("init excepiton:{}", (Throwable)e);
            throw e;
        }
    }

    protected static WorkspaceFolder createFolder(String user, String parentId, String folderName, String folderDescription) throws Exception {
        try {
            Workspace ws = HomeLibrary.getUserWorkspace((String)user);
            WorkspaceFolder projectTargetFolder = !ws.exists(folderName, parentId) ? ws.createFolder(folderName, folderDescription, parentId) : (WorkspaceFolder)ws.find(folderName, parentId);
            return projectTargetFolder;
        }
        catch (Exception e) {
            logger.error("createFolder:{}", (Throwable)e);
            throw e;
        }
    }

    protected static void saveItemOnWorkspace(String user, InputStream inputStream, String name, String description, String folderId) throws Exception {
        try {
            Workspace ws = HomeLibrary.getUserWorkspace((String)user);
            WorkspaceItem workSpaceItem = ws.getItem(folderId);
            if (!workSpaceItem.isFolder()) {
                throw new Exception("Destination is not a folder!");
            }
            WorkspaceItem projectItem = ws.find(name, folderId);
            logger.trace("Save Item on WorkSpace Folder:{}, name:{},description:{}, folderID:{}", new Object[]{projectItem, name, description, folderId});
            if (projectItem == null) {
                ws.createExternalFile(name, description, null, inputStream, folderId);
            } else {
                ws.remove(name, folderId);
                Thread.sleep(2000L);
                ws.createExternalFile(name, description, null, inputStream, folderId);
            }
            return;
        }
        catch (Exception e) {
            logger.error("saveItemOnWorkspace:{}", (Throwable)e);
            throw e;
        }
    }
}

