/*
 * Decompiled with CFR 0.152.
 */
package org.jfile.util;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import org.jfile.model.MagicSection;

public class MagicUtil {
    public static boolean match(RandomAccessFile raf, MagicSection section) throws IOException {
        int len = section.getLength();
        int rangeLength = section.getRangeLength();
        byte[] buf = new byte[len + rangeLength];
        raf.seek(section.getOffset());
        int bytesRead = raf.read(buf, 0, len + rangeLength);
        rangeLength = bytesRead - len + 1;
        int range = 0;
        while (range < rangeLength) {
            if (MagicUtil.match(section.getValue(), buf, len, section.getMask(), range)) {
                if (section.getSubSections() == null || section.getSubSections().isEmpty()) {
                    return true;
                }
                ArrayList<MagicSection> subSections = section.getSubSections();
                for (MagicSection subSection : subSections) {
                    if (!MagicUtil.match(raf, subSection)) continue;
                    return true;
                }
            }
            ++range;
        }
        return false;
    }

    public static boolean match(byte[] b1, byte[] b2, int len, byte[] mask, int offset) {
        int i = 0;
        while (i < len) {
            if ((b1[i] & mask[i]) != (b2[i + offset] & mask[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

