/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.env;

import com.couchbase.client.core.ClusterFacade;
import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.env.CoreScheduler;
import com.couchbase.client.core.env.KeyValueServiceConfig;
import com.couchbase.client.core.env.QueryServiceConfig;
import com.couchbase.client.core.env.SearchServiceConfig;
import com.couchbase.client.core.env.ViewServiceConfig;
import com.couchbase.client.core.env.WaitStrategyFactory;
import com.couchbase.client.core.env.resources.IoPoolShutdownHook;
import com.couchbase.client.core.env.resources.NettyShutdownHook;
import com.couchbase.client.core.env.resources.NoOpShutdownHook;
import com.couchbase.client.core.env.resources.ShutdownHook;
import com.couchbase.client.core.event.CouchbaseEvent;
import com.couchbase.client.core.event.DefaultEventBus;
import com.couchbase.client.core.event.EventBus;
import com.couchbase.client.core.event.EventType;
import com.couchbase.client.core.event.consumers.LoggingConsumer;
import com.couchbase.client.core.event.system.TooManyEnvironmentsEvent;
import com.couchbase.client.core.logging.CouchbaseLogLevel;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.metrics.DefaultLatencyMetricsCollectorConfig;
import com.couchbase.client.core.metrics.DefaultMetricsCollectorConfig;
import com.couchbase.client.core.metrics.LatencyMetricsCollectorConfig;
import com.couchbase.client.core.metrics.MetricsCollector;
import com.couchbase.client.core.metrics.MetricsCollectorConfig;
import com.couchbase.client.core.metrics.NetworkLatencyMetricsCollector;
import com.couchbase.client.core.metrics.RuntimeMetricsCollector;
import com.couchbase.client.core.node.DefaultMemcachedHashingStrategy;
import com.couchbase.client.core.node.MemcachedHashingStrategy;
import com.couchbase.client.core.retry.BestEffortRetryStrategy;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.time.Delay;
import com.couchbase.client.core.utils.Blocking;
import com.couchbase.client.deps.com.lmax.disruptor.BlockingWaitStrategy;
import com.couchbase.client.deps.com.lmax.disruptor.WaitStrategy;
import com.couchbase.client.deps.io.netty.channel.EventLoopGroup;
import com.couchbase.client.deps.io.netty.channel.nio.NioEventLoopGroup;
import com.couchbase.client.deps.io.netty.util.concurrent.DefaultThreadFactory;
import java.security.KeyStore;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Scheduler;
import rx.Subscription;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Func1;
import rx.functions.Func2;

public class DefaultCoreEnvironment
implements CoreEnvironment {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(CoreEnvironment.class);
    public static final boolean DCP_ENABLED = false;
    public static final boolean SSL_ENABLED = false;
    public static final String SSL_KEYSTORE_FILE = null;
    public static final String SSL_KEYSTORE_PASSWORD = null;
    public static final KeyStore SSL_KEYSTORE = null;
    public static final boolean BOOTSTRAP_HTTP_ENABLED = true;
    public static final boolean BOOTSTRAP_CARRIER_ENABLED = true;
    public static final int BOOTSTRAP_HTTP_DIRECT_PORT = 8091;
    public static final int BOOTSTRAP_HTTP_SSL_PORT = 18091;
    public static final int BOOTSTRAP_CARRIER_DIRECT_PORT = 11210;
    public static final int BOOTSTRAP_CARRIER_SSL_PORT = 11207;
    public static final int REQUEST_BUFFER_SIZE = 16384;
    public static final int RESPONSE_BUFFER_SIZE = 16384;
    public static final int DCP_CONNECTION_BUFFER_SIZE = 0x1400000;
    public static final double DCP_CONNECTION_BUFFER_ACK_THRESHOLD = 0.2;
    public static final String DCP_CONNECTION_NAME = "dcp/core-io";
    public static final int IO_POOL_SIZE = Runtime.getRuntime().availableProcessors();
    public static final int COMPUTATION_POOL_SIZE = Runtime.getRuntime().availableProcessors();
    public static final int KEYVALUE_ENDPOINTS = 1;
    public static final int VIEW_ENDPOINTS = 12;
    public static final int QUERY_ENDPOINTS = 12;
    public static final int SEARCH_ENDPOINTS = 12;
    public static final Delay OBSERVE_INTERVAL_DELAY = Delay.exponential(TimeUnit.MICROSECONDS, 100000L, 10L);
    public static final Delay RECONNECT_DELAY = Delay.exponential(TimeUnit.MILLISECONDS, 4096L, 32L);
    public static final Delay RETRY_DELAY = Delay.exponential(TimeUnit.MICROSECONDS, 100000L, 100L);
    public static final RetryStrategy RETRY_STRATEGY = BestEffortRetryStrategy.INSTANCE;
    public static final long MAX_REQUEST_LIFETIME = TimeUnit.SECONDS.toMillis(75L);
    public static final long KEEPALIVEINTERVAL = TimeUnit.SECONDS.toMillis(30L);
    public static final long AUTORELEASE_AFTER = TimeUnit.SECONDS.toMillis(2L);
    public static final boolean BUFFER_POOLING_ENABLED = true;
    public static final boolean TCP_NODELAY_ENALED = true;
    public static final boolean MUTATION_TOKENS_ENABLED = false;
    public static final int SOCKET_CONNECT_TIMEOUT = 1000;
    public static final boolean CALLBACKS_ON_IO_POOL = false;
    public static final long DISCONNECT_TIMEOUT = TimeUnit.SECONDS.toMillis(25L);
    public static final MemcachedHashingStrategy MEMCACHED_HASHING_STRATEGY = DefaultMemcachedHashingStrategy.INSTANCE;
    public static String CORE_VERSION;
    public static String CORE_GIT_VERSION;
    public static String PACKAGE_NAME_AND_VERSION;
    public static String USER_AGENT;
    private static final String NAMESPACE = "com.couchbase.";
    static final int MIN_POOL_SIZE = 3;
    private static final String VERSION_PROPERTIES = "com.couchbase.client.core.properties";
    private final boolean dcpEnabled;
    private final boolean sslEnabled;
    private final String sslKeystoreFile;
    private final String sslKeystorePassword;
    private final KeyStore sslKeystore;
    private final boolean bootstrapHttpEnabled;
    private final boolean bootstrapCarrierEnabled;
    private final int bootstrapHttpDirectPort;
    private final int bootstrapHttpSslPort;
    private final int bootstrapCarrierDirectPort;
    private final int bootstrapCarrierSslPort;
    private final int ioPoolSize;
    private final int computationPoolSize;
    private final int responseBufferSize;
    private final int requestBufferSize;
    private final int dcpConnectionBufferSize;
    private final double dcpConnectionBufferAckThreshold;
    private final String dcpConnectionName;
    private final int kvServiceEndpoints;
    private final int viewServiceEndpoints;
    private final int queryServiceEndpoints;
    private final int searchServiceEndpoints;
    private final Delay observeIntervalDelay;
    private final Delay reconnectDelay;
    private final Delay retryDelay;
    private final String userAgent;
    private final String packageNameAndVersion;
    private final RetryStrategy retryStrategy;
    private final long maxRequestLifetime;
    private final long keepAliveInterval;
    private final long autoreleaseAfter;
    private final boolean bufferPoolingEnabled;
    private final boolean tcpNodelayEnabled;
    private final boolean mutationTokensEnabled;
    private final int socketConnectTimeout;
    private final boolean callbacksOnIoPool;
    private final long disconnectTimeout;
    private final WaitStrategyFactory requestBufferWaitStrategy;
    private final MemcachedHashingStrategy memcachedHashingStrategy;
    private static final int MAX_ALLOWED_INSTANCES = 1;
    private static volatile int instanceCounter;
    private final EventLoopGroup ioPool;
    private final EventLoopGroup kvIoPool;
    private final EventLoopGroup queryIoPool;
    private final EventLoopGroup viewIoPool;
    private final EventLoopGroup searchIoPool;
    private final Scheduler coreScheduler;
    private final EventBus eventBus;
    private final ShutdownHook ioPoolShutdownHook;
    private final ShutdownHook kvIoPoolShutdownHook;
    private final ShutdownHook queryIoPoolShutdownHook;
    private final ShutdownHook viewIoPoolShutdownHook;
    private final ShutdownHook searchIoPoolShutdownHook;
    private final KeyValueServiceConfig keyValueServiceConfig;
    private final QueryServiceConfig queryServiceConfig;
    private final ViewServiceConfig viewServiceConfig;
    private final SearchServiceConfig searchServiceConfig;
    private final ShutdownHook nettyShutdownHook;
    private final ShutdownHook coreSchedulerShutdownHook;
    private final MetricsCollector runtimeMetricsCollector;
    private final NetworkLatencyMetricsCollector networkLatencyMetricsCollector;
    private final Subscription metricsCollectorSubscription;

    protected DefaultCoreEnvironment(Builder builder) {
        boolean emitEnvWarnMessage = false;
        if (++instanceCounter > 1) {
            LOGGER.warn("More than 1 Couchbase Environments found (" + instanceCounter + "), this can have severe impact on performance and stability. Reuse environments!");
            emitEnvWarnMessage = true;
        }
        this.dcpEnabled = this.booleanPropertyOr("dcpEnabled", builder.dcpEnabled);
        this.sslEnabled = this.booleanPropertyOr("sslEnabled", builder.sslEnabled);
        this.sslKeystoreFile = this.stringPropertyOr("sslKeystoreFile", builder.sslKeystoreFile);
        this.sslKeystorePassword = this.stringPropertyOr("sslKeystorePassword", builder.sslKeystorePassword);
        this.bootstrapHttpEnabled = this.booleanPropertyOr("bootstrapHttpEnabled", builder.bootstrapHttpEnabled);
        this.bootstrapHttpDirectPort = this.intPropertyOr("bootstrapHttpDirectPort", builder.bootstrapHttpDirectPort);
        this.bootstrapHttpSslPort = this.intPropertyOr("bootstrapHttpSslPort", builder.bootstrapHttpSslPort);
        this.bootstrapCarrierEnabled = this.booleanPropertyOr("bootstrapCarrierEnabled", builder.bootstrapCarrierEnabled);
        this.bootstrapCarrierDirectPort = this.intPropertyOr("bootstrapCarrierDirectPort", builder.bootstrapCarrierDirectPort);
        this.bootstrapCarrierSslPort = this.intPropertyOr("bootstrapCarrierSslPort", builder.bootstrapCarrierSslPort);
        int ioPoolSize = this.intPropertyOr("ioPoolSize", builder.ioPoolSize);
        int computationPoolSize = this.intPropertyOr("computationPoolSize", builder.computationPoolSize);
        this.responseBufferSize = this.intPropertyOr("responseBufferSize", builder.responseBufferSize);
        this.requestBufferSize = this.intPropertyOr("requestBufferSize", builder.requestBufferSize);
        this.dcpConnectionBufferSize = this.intPropertyOr("dcpConnectionBufferSize", builder.dcpConnectionBufferSize);
        this.dcpConnectionBufferAckThreshold = DefaultCoreEnvironment.doublePropertyOr("dcpConnectionBufferAckThreshold", builder.dcpConnectionBufferAckThreshold);
        this.dcpConnectionName = this.stringPropertyOr("dcpConnectionName", builder.dcpConnectionName);
        this.kvServiceEndpoints = this.intPropertyOr("kvEndpoints", builder.kvEndpoints);
        this.viewServiceEndpoints = this.intPropertyOr("viewEndpoints", builder.viewEndpoints);
        this.queryServiceEndpoints = this.intPropertyOr("queryEndpoints", builder.queryEndpoints);
        this.searchServiceEndpoints = this.intPropertyOr("searchEndpoints", builder.searchEndpoints);
        this.packageNameAndVersion = this.stringPropertyOr("packageNameAndVersion", builder.packageNameAndVersion);
        this.userAgent = this.stringPropertyOr("userAgent", builder.userAgent);
        this.observeIntervalDelay = builder.observeIntervalDelay;
        this.reconnectDelay = builder.reconnectDelay;
        this.retryDelay = builder.retryDelay;
        this.retryStrategy = builder.retryStrategy;
        this.maxRequestLifetime = DefaultCoreEnvironment.longPropertyOr("maxRequestLifetime", builder.maxRequestLifetime);
        this.keepAliveInterval = DefaultCoreEnvironment.longPropertyOr("keepAliveInterval", builder.keepAliveInterval);
        this.autoreleaseAfter = DefaultCoreEnvironment.longPropertyOr("autoreleaseAfter", builder.autoreleaseAfter);
        this.bufferPoolingEnabled = this.booleanPropertyOr("bufferPoolingEnabled", builder.bufferPoolingEnabled);
        this.tcpNodelayEnabled = this.booleanPropertyOr("tcpNodelayEnabled", builder.tcpNodelayEnabled);
        this.mutationTokensEnabled = this.booleanPropertyOr("mutationTokensEnabled", builder.mutationTokensEnabled);
        this.socketConnectTimeout = this.intPropertyOr("socketConnectTimeout", builder.socketConnectTimeout);
        this.callbacksOnIoPool = this.booleanPropertyOr("callbacksOnIoPool", builder.callbacksOnIoPool);
        this.disconnectTimeout = DefaultCoreEnvironment.longPropertyOr("disconnectTimeout", builder.disconnectTimeout);
        this.sslKeystore = builder.sslKeystore;
        this.memcachedHashingStrategy = builder.memcachedHashingStrategy;
        if (ioPoolSize < 3) {
            LOGGER.info("ioPoolSize is less than {} ({}), setting to: {}", 3, ioPoolSize, 3);
            this.ioPoolSize = 3;
        } else {
            this.ioPoolSize = ioPoolSize;
        }
        if (computationPoolSize < 3) {
            LOGGER.info("computationPoolSize is less than {} ({}), setting to: {}", 3, computationPoolSize, 3);
            this.computationPoolSize = 3;
        } else {
            this.computationPoolSize = computationPoolSize;
        }
        if (builder.ioPool == null) {
            this.ioPool = new NioEventLoopGroup(this.ioPoolSize(), new DefaultThreadFactory("cb-io", true));
            this.ioPoolShutdownHook = new IoPoolShutdownHook(this.ioPool);
        } else {
            this.ioPool = builder.ioPool;
            ShutdownHook shutdownHook = this.ioPoolShutdownHook = builder.ioPoolShutdownHook == null ? new NoOpShutdownHook() : builder.ioPoolShutdownHook;
        }
        if (builder.kvIoPool != null) {
            this.kvIoPool = builder.kvIoPool;
            this.kvIoPoolShutdownHook = builder.kvIoPoolShutdownHook == null ? new NoOpShutdownHook() : builder.kvIoPoolShutdownHook;
        } else {
            this.kvIoPool = null;
            this.kvIoPoolShutdownHook = new NoOpShutdownHook();
        }
        if (builder.queryIoPool != null) {
            this.queryIoPool = builder.queryIoPool;
            this.queryIoPoolShutdownHook = builder.queryIoPoolShutdownHook == null ? new NoOpShutdownHook() : builder.queryIoPoolShutdownHook;
        } else {
            this.queryIoPool = null;
            this.queryIoPoolShutdownHook = new NoOpShutdownHook();
        }
        if (builder.viewIoPool != null) {
            this.viewIoPool = builder.viewIoPool;
            this.viewIoPoolShutdownHook = builder.viewIoPoolShutdownHook == null ? new NoOpShutdownHook() : builder.viewIoPoolShutdownHook;
        } else {
            this.viewIoPool = null;
            this.viewIoPoolShutdownHook = new NoOpShutdownHook();
        }
        if (builder.searchIoPool != null) {
            this.searchIoPool = builder.searchIoPool;
            this.searchIoPoolShutdownHook = builder.searchIoPoolShutdownHook == null ? new NoOpShutdownHook() : builder.searchIoPoolShutdownHook;
        } else {
            this.searchIoPool = null;
            this.searchIoPoolShutdownHook = new NoOpShutdownHook();
        }
        this.nettyShutdownHook = !(this.ioPoolShutdownHook instanceof NoOpShutdownHook) ? new NettyShutdownHook() : this.ioPoolShutdownHook;
        if (builder.scheduler == null) {
            CoreScheduler managed = new CoreScheduler(this.computationPoolSize());
            this.coreScheduler = managed;
            this.coreSchedulerShutdownHook = managed;
        } else {
            this.coreScheduler = builder.scheduler;
            this.coreSchedulerShutdownHook = builder.schedulerShutdownHook == null ? new NoOpShutdownHook() : builder.schedulerShutdownHook;
        }
        this.eventBus = builder.eventBus == null ? new DefaultEventBus(this.coreScheduler) : builder.eventBus;
        this.runtimeMetricsCollector = new RuntimeMetricsCollector(this.eventBus, this.coreScheduler, builder.runtimeMetricsCollectorConfig == null ? DefaultMetricsCollectorConfig.create() : builder.runtimeMetricsCollectorConfig);
        this.networkLatencyMetricsCollector = new NetworkLatencyMetricsCollector(this.eventBus, this.coreScheduler, builder.networkLatencyMetricsCollectorConfig == null ? DefaultLatencyMetricsCollectorConfig.create() : builder.networkLatencyMetricsCollectorConfig);
        this.metricsCollectorSubscription = builder.defaultMetricsLoggingConsumer != null ? this.eventBus.get().filter(new Func1<CouchbaseEvent, Boolean>(){

            @Override
            public Boolean call(CouchbaseEvent evt) {
                return evt.type().equals((Object)EventType.METRIC);
            }
        }).subscribe(builder.defaultMetricsLoggingConsumer) : null;
        this.requestBufferWaitStrategy = builder.requestBufferWaitStrategy == null ? new WaitStrategyFactory(){

            @Override
            public WaitStrategy newWaitStrategy() {
                return new BlockingWaitStrategy();
            }
        } : builder.requestBufferWaitStrategy;
        this.keyValueServiceConfig = builder.keyValueServiceConfig != null ? builder.keyValueServiceConfig : KeyValueServiceConfig.create(this.kvEndpoints());
        if (builder.viewServiceConfig != null) {
            this.viewServiceConfig = builder.viewServiceConfig;
        } else {
            int minEndpoints = this.viewEndpoints() == 12 ? 0 : this.viewEndpoints();
            this.viewServiceConfig = ViewServiceConfig.create(minEndpoints, this.viewEndpoints());
        }
        if (builder.queryServiceConfig != null) {
            this.queryServiceConfig = builder.queryServiceConfig;
        } else {
            int minEndpoints = this.queryEndpoints() == 12 ? 0 : this.queryEndpoints();
            this.queryServiceConfig = QueryServiceConfig.create(minEndpoints, this.queryEndpoints());
        }
        if (builder.searchServiceConfig != null) {
            this.searchServiceConfig = builder.searchServiceConfig;
        } else {
            int minEndpoints = this.searchEndpoints() == 12 ? 0 : this.searchEndpoints();
            this.searchServiceConfig = SearchServiceConfig.create(minEndpoints, this.searchEndpoints());
        }
        if (emitEnvWarnMessage) {
            this.eventBus.publish(new TooManyEnvironmentsEvent(instanceCounter));
        }
    }

    public static DefaultCoreEnvironment create() {
        return new DefaultCoreEnvironment(DefaultCoreEnvironment.builder());
    }

    public static Builder builder() {
        return new Builder();
    }

    protected boolean booleanPropertyOr(String path, boolean def) {
        String found = System.getProperty(NAMESPACE + path);
        if (found == null) {
            return def;
        }
        return Boolean.parseBoolean(found);
    }

    protected String stringPropertyOr(String path, String def) {
        String found = System.getProperty(NAMESPACE + path);
        return found == null ? def : found;
    }

    protected int intPropertyOr(String path, int def) {
        String found = System.getProperty(NAMESPACE + path);
        if (found == null) {
            return def;
        }
        return Integer.parseInt(found);
    }

    protected static long longPropertyOr(String path, long def) {
        String found = System.getProperty(NAMESPACE + path);
        if (found == null) {
            return def;
        }
        return Integer.parseInt(found);
    }

    protected static double doublePropertyOr(String path, double def) {
        String found = System.getProperty(NAMESPACE + path);
        if (found == null) {
            return def;
        }
        return Double.parseDouble(found);
    }

    @Override
    public EventLoopGroup ioPool() {
        return this.ioPool;
    }

    @Override
    public boolean shutdown() {
        return this.shutdown(this.disconnectTimeout(), TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean shutdown(long timeout, TimeUnit timeUnit) {
        return Blocking.blockForSingle(this.shutdownAsync(), timeout, timeUnit);
    }

    @Override
    public Observable<Boolean> shutdownAsync() {
        if (this.metricsCollectorSubscription != null && !this.metricsCollectorSubscription.isUnsubscribed()) {
            this.metricsCollectorSubscription.unsubscribe();
        }
        Observable<Boolean> result = Observable.merge(this.wrapShutdown(this.ioPoolShutdownHook.shutdown(), "IoPool"), this.wrapBestEffortShutdown(this.nettyShutdownHook.shutdown(), "Netty"), this.wrapShutdown(this.kvIoPoolShutdownHook.shutdown(), "kvIoPool"), this.wrapShutdown(this.viewIoPoolShutdownHook.shutdown(), "viewIoPool"), this.wrapShutdown(this.queryIoPoolShutdownHook.shutdown(), "queryIoPool"), this.wrapShutdown(this.searchIoPoolShutdownHook.shutdown(), "searchIoPool"), this.wrapShutdown(this.coreSchedulerShutdownHook.shutdown(), "Core Scheduler"), this.wrapShutdown(Observable.just(this.runtimeMetricsCollector.shutdown()), "Runtime Metrics Collector"), this.wrapShutdown(Observable.just(this.networkLatencyMetricsCollector.shutdown()), "Latency Metrics Collector")).reduce(true, new Func2<Boolean, ShutdownStatus, Boolean>(){

            @Override
            public Boolean call(Boolean previousStatus, ShutdownStatus currentStatus) {
                return previousStatus != false && currentStatus.success;
            }
        }).doOnTerminate(new Action0(){

            @Override
            public void call() {
                instanceCounter--;
            }
        });
        return result;
    }

    private Observable<ShutdownStatus> wrapBestEffortShutdown(Observable<Boolean> source, final String target) {
        return this.wrapShutdown(source, target).map(new Func1<ShutdownStatus, ShutdownStatus>(){

            @Override
            public ShutdownStatus call(ShutdownStatus original) {
                if (original.cause == null && !original.success) {
                    LOGGER.info(target + " shutdown is best effort, ignoring failure");
                    return new ShutdownStatus(target, true, null);
                }
                return original;
            }
        });
    }

    private Observable<ShutdownStatus> wrapShutdown(Observable<Boolean> source, final String target) {
        return source.reduce(true, new Func2<Boolean, Boolean, Boolean>(){

            @Override
            public Boolean call(Boolean previousStatus, Boolean currentStatus) {
                return previousStatus != false && currentStatus != false;
            }
        }).map(new Func1<Boolean, ShutdownStatus>(){

            @Override
            public ShutdownStatus call(Boolean status) {
                return new ShutdownStatus(target, status, null);
            }
        }).onErrorReturn(new Func1<Throwable, ShutdownStatus>(){

            @Override
            public ShutdownStatus call(Throwable throwable) {
                return new ShutdownStatus(target, false, throwable);
            }
        }).doOnNext(new Action1<ShutdownStatus>(){

            @Override
            public void call(ShutdownStatus shutdownStatus) {
                LOGGER.info(shutdownStatus.toString());
            }
        });
    }

    @Override
    public Scheduler scheduler() {
        return this.coreScheduler;
    }

    @Override
    public boolean sslEnabled() {
        return this.sslEnabled;
    }

    @Override
    public boolean dcpEnabled() {
        return this.dcpEnabled;
    }

    @Override
    public String sslKeystoreFile() {
        return this.sslKeystoreFile;
    }

    @Override
    public String sslKeystorePassword() {
        return this.sslKeystorePassword;
    }

    @Override
    public KeyStore sslKeystore() {
        return this.sslKeystore;
    }

    @Override
    public boolean bootstrapHttpEnabled() {
        return this.bootstrapHttpEnabled;
    }

    @Override
    public boolean bootstrapCarrierEnabled() {
        return this.bootstrapCarrierEnabled;
    }

    @Override
    public int bootstrapHttpDirectPort() {
        return this.bootstrapHttpDirectPort;
    }

    @Override
    public int bootstrapHttpSslPort() {
        return this.bootstrapHttpSslPort;
    }

    @Override
    public int bootstrapCarrierDirectPort() {
        return this.bootstrapCarrierDirectPort;
    }

    @Override
    public int bootstrapCarrierSslPort() {
        return this.bootstrapCarrierSslPort;
    }

    @Override
    public int ioPoolSize() {
        return this.ioPoolSize;
    }

    @Override
    public int computationPoolSize() {
        return this.computationPoolSize;
    }

    @Override
    public int requestBufferSize() {
        return this.requestBufferSize;
    }

    @Override
    public int responseBufferSize() {
        return this.responseBufferSize;
    }

    @Override
    public int dcpConnectionBufferSize() {
        return this.dcpConnectionBufferSize;
    }

    @Override
    public double dcpConnectionBufferAckThreshold() {
        return this.dcpConnectionBufferAckThreshold;
    }

    @Override
    @InterfaceStability.Experimental
    @InterfaceAudience.Public
    public String dcpConnectionName() {
        return this.dcpConnectionName;
    }

    @Override
    public int kvEndpoints() {
        return this.kvServiceEndpoints;
    }

    @Override
    public int viewEndpoints() {
        return this.viewServiceEndpoints;
    }

    @Override
    public int queryEndpoints() {
        return this.queryServiceEndpoints;
    }

    @Override
    public int searchEndpoints() {
        return this.searchServiceEndpoints;
    }

    @Override
    public String coreVersion() {
        return CORE_VERSION;
    }

    @Override
    public String coreBuild() {
        return CORE_GIT_VERSION;
    }

    @Override
    public String userAgent() {
        return this.userAgent;
    }

    @Override
    public String packageNameAndVersion() {
        return this.packageNameAndVersion;
    }

    @Override
    public Delay observeIntervalDelay() {
        return this.observeIntervalDelay;
    }

    @Override
    public Delay reconnectDelay() {
        return this.reconnectDelay;
    }

    @Override
    public Delay retryDelay() {
        return this.retryDelay;
    }

    @Override
    public RetryStrategy retryStrategy() {
        return this.retryStrategy;
    }

    @Override
    public long maxRequestLifetime() {
        return this.maxRequestLifetime;
    }

    @Override
    public long keepAliveInterval() {
        return this.keepAliveInterval;
    }

    @Override
    public EventBus eventBus() {
        return this.eventBus;
    }

    @Override
    public long autoreleaseAfter() {
        return this.autoreleaseAfter;
    }

    @Override
    public boolean bufferPoolingEnabled() {
        return this.bufferPoolingEnabled;
    }

    @Override
    public boolean tcpNodelayEnabled() {
        return this.tcpNodelayEnabled;
    }

    @Override
    public boolean mutationTokensEnabled() {
        return this.mutationTokensEnabled;
    }

    @Override
    public MetricsCollector runtimeMetricsCollector() {
        return this.runtimeMetricsCollector;
    }

    @Override
    public NetworkLatencyMetricsCollector networkLatencyMetricsCollector() {
        return this.networkLatencyMetricsCollector;
    }

    @Override
    public int socketConnectTimeout() {
        return this.socketConnectTimeout;
    }

    @Override
    public boolean callbacksOnIoPool() {
        return this.callbacksOnIoPool;
    }

    @Override
    public long disconnectTimeout() {
        return this.disconnectTimeout;
    }

    @Override
    public WaitStrategyFactory requestBufferWaitStrategy() {
        return this.requestBufferWaitStrategy;
    }

    @Override
    public MemcachedHashingStrategy memcachedHashingStrategy() {
        return this.memcachedHashingStrategy;
    }

    @Override
    public EventLoopGroup kvIoPool() {
        return this.kvIoPool;
    }

    @Override
    public EventLoopGroup viewIoPool() {
        return this.viewIoPool;
    }

    @Override
    public EventLoopGroup queryIoPool() {
        return this.queryIoPool;
    }

    @Override
    public EventLoopGroup searchIoPool() {
        return this.searchIoPool;
    }

    public static int instanceCounter() {
        return instanceCounter;
    }

    @Override
    public KeyValueServiceConfig kvServiceConfig() {
        return this.keyValueServiceConfig;
    }

    @Override
    public QueryServiceConfig queryServiceConfig() {
        return this.queryServiceConfig;
    }

    @Override
    public ViewServiceConfig viewServiceConfig() {
        return this.viewServiceConfig;
    }

    @Override
    public SearchServiceConfig searchServiceConfig() {
        return this.searchServiceConfig;
    }

    protected StringBuilder dumpParameters(StringBuilder sb) {
        sb.append("sslEnabled=").append(this.sslEnabled);
        sb.append(", sslKeystoreFile='").append(this.sslKeystoreFile).append('\'');
        sb.append(", sslKeystorePassword=").append(this.sslKeystorePassword != null && !this.sslKeystorePassword.isEmpty());
        sb.append(", sslKeystore=").append(this.sslKeystore);
        sb.append(", bootstrapHttpEnabled=").append(this.bootstrapHttpEnabled);
        sb.append(", bootstrapCarrierEnabled=").append(this.bootstrapCarrierEnabled);
        sb.append(", bootstrapHttpDirectPort=").append(this.bootstrapHttpDirectPort);
        sb.append(", bootstrapHttpSslPort=").append(this.bootstrapHttpSslPort);
        sb.append(", bootstrapCarrierDirectPort=").append(this.bootstrapCarrierDirectPort);
        sb.append(", bootstrapCarrierSslPort=").append(this.bootstrapCarrierSslPort);
        sb.append(", ioPoolSize=").append(this.ioPoolSize);
        sb.append(", computationPoolSize=").append(this.computationPoolSize);
        sb.append(", responseBufferSize=").append(this.responseBufferSize);
        sb.append(", requestBufferSize=").append(this.requestBufferSize);
        sb.append(", kvServiceEndpoints=").append(this.kvServiceEndpoints);
        sb.append(", viewServiceEndpoints=").append(this.viewServiceEndpoints);
        sb.append(", queryServiceEndpoints=").append(this.queryServiceEndpoints);
        sb.append(", searchServiceEndpoints=").append(this.searchServiceEndpoints);
        sb.append(", ioPool=").append(this.ioPool.getClass().getSimpleName());
        if (this.ioPoolShutdownHook == null || this.ioPoolShutdownHook instanceof NoOpShutdownHook) {
            sb.append("!unmanaged");
        }
        if (this.kvIoPool != null) {
            sb.append(", kvIoPool=").append(this.kvIoPool.getClass().getSimpleName());
            if (this.kvIoPoolShutdownHook == null || this.kvIoPoolShutdownHook instanceof NoOpShutdownHook) {
                sb.append("!unmanaged");
            }
        } else {
            sb.append(", kvIoPool=").append("null");
        }
        if (this.viewIoPool != null) {
            sb.append(", viewIoPool=").append(this.viewIoPool.getClass().getSimpleName());
            if (this.viewIoPoolShutdownHook == null || this.viewIoPoolShutdownHook instanceof NoOpShutdownHook) {
                sb.append("!unmanaged");
            }
        } else {
            sb.append(", viewIoPool=").append("null");
        }
        if (this.searchIoPool != null) {
            sb.append(", searchIoPool=").append(this.searchIoPool.getClass().getSimpleName());
            if (this.searchIoPoolShutdownHook == null || this.searchIoPoolShutdownHook instanceof NoOpShutdownHook) {
                sb.append("!unmanaged");
            }
        } else {
            sb.append(", searchIoPool=").append("null");
        }
        if (this.queryIoPool != null) {
            sb.append(", queryIoPool=").append(this.queryIoPool.getClass().getSimpleName());
            if (this.queryIoPoolShutdownHook == null || this.queryIoPoolShutdownHook instanceof NoOpShutdownHook) {
                sb.append("!unmanaged");
            }
        } else {
            sb.append(", queryIoPool=").append("null");
        }
        sb.append(", coreScheduler=").append(this.coreScheduler.getClass().getSimpleName());
        if (this.coreSchedulerShutdownHook == null || this.coreSchedulerShutdownHook instanceof NoOpShutdownHook) {
            sb.append("!unmanaged");
        }
        sb.append(", memcachedHashingStrategy=").append(this.memcachedHashingStrategy.getClass().getSimpleName());
        sb.append(", eventBus=").append(this.eventBus.getClass().getSimpleName());
        sb.append(", packageNameAndVersion=").append(this.packageNameAndVersion);
        sb.append(", dcpEnabled=").append(this.dcpEnabled);
        sb.append(", retryStrategy=").append(this.retryStrategy);
        sb.append(", maxRequestLifetime=").append(this.maxRequestLifetime);
        sb.append(", retryDelay=").append(this.retryDelay);
        sb.append(", reconnectDelay=").append(this.reconnectDelay);
        sb.append(", observeIntervalDelay=").append(this.observeIntervalDelay);
        sb.append(", keepAliveInterval=").append(this.keepAliveInterval);
        sb.append(", autoreleaseAfter=").append(this.autoreleaseAfter);
        sb.append(", bufferPoolingEnabled=").append(this.bufferPoolingEnabled);
        sb.append(", tcpNodelayEnabled=").append(this.tcpNodelayEnabled);
        sb.append(", mutationTokensEnabled=").append(this.mutationTokensEnabled);
        sb.append(", socketConnectTimeout=").append(this.socketConnectTimeout);
        sb.append(", dcpConnectionBufferSize=").append(this.dcpConnectionBufferSize);
        sb.append(", dcpConnectionBufferAckThreshold=").append(this.dcpConnectionBufferAckThreshold);
        sb.append(", dcpConnectionName=").append(this.dcpConnectionName);
        sb.append(", callbacksOnIoPool=").append(this.callbacksOnIoPool);
        sb.append(", disconnectTimeout=").append(this.disconnectTimeout);
        sb.append(", requestBufferWaitStrategy=").append(this.requestBufferWaitStrategy);
        return sb;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CoreEnvironment: {");
        this.dumpParameters(sb).append('}');
        return sb.toString();
    }

    static {
        USER_AGENT = PACKAGE_NAME_AND_VERSION = "couchbase-jvm-core";
        try {
            Class<ClusterFacade> facadeClass = ClusterFacade.class;
            if (facadeClass == null) {
                throw new IllegalStateException("Could not locate ClusterFacade");
            }
            String version = null;
            String gitVersion = null;
            try {
                Properties versionProp = new Properties();
                versionProp.load(DefaultCoreEnvironment.class.getClassLoader().getResourceAsStream(VERSION_PROPERTIES));
                version = versionProp.getProperty("specificationVersion");
                gitVersion = versionProp.getProperty("implementationVersion");
            }
            catch (Exception e) {
                LOGGER.info("Could not retrieve core version properties, defaulting.", e);
            }
            CORE_VERSION = version == null ? "unknown" : version;
            CORE_GIT_VERSION = gitVersion == null ? "unknown" : gitVersion;
            PACKAGE_NAME_AND_VERSION = String.format("couchbase-jvm-core/%s (git: %s)", CORE_VERSION, CORE_GIT_VERSION);
            USER_AGENT = String.format("%s (%s/%s %s; %s %s)", PACKAGE_NAME_AND_VERSION, System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"), System.getProperty("java.vm.name"), System.getProperty("java.runtime.version"));
        }
        catch (Exception ex) {
            LOGGER.info("Could not set up user agent and packages, defaulting.", ex);
        }
        try {
            if (System.getProperty("com.couchbase.client.deps.io.netty.packagePrefix") == null) {
                System.setProperty("com.couchbase.client.deps.io.netty.packagePrefix", "com.couchbase.client.deps.");
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Could not configure bundled netty's package prefix", ex);
        }
        instanceCounter = 0;
    }

    private static final class ShutdownStatus {
        public final String target;
        public final boolean success;
        public final Throwable cause;

        public ShutdownStatus(String target, boolean success, Throwable cause) {
            this.target = target;
            this.success = success;
            this.cause = cause;
        }

        public String toString() {
            return "Shutdown " + this.target + ": " + (this.success ? "success " : "failure ") + (this.cause == null ? "" : " due to " + this.cause.toString());
        }
    }

    public static class Builder {
        private boolean dcpEnabled = false;
        private boolean sslEnabled = false;
        private String sslKeystoreFile = SSL_KEYSTORE_FILE;
        private String sslKeystorePassword = SSL_KEYSTORE_PASSWORD;
        private KeyStore sslKeystore = SSL_KEYSTORE;
        private String userAgent = USER_AGENT;
        private String packageNameAndVersion = PACKAGE_NAME_AND_VERSION;
        private boolean bootstrapHttpEnabled = true;
        private boolean bootstrapCarrierEnabled = true;
        private int bootstrapHttpDirectPort = 8091;
        private int bootstrapHttpSslPort = 18091;
        private int bootstrapCarrierDirectPort = 11210;
        private int bootstrapCarrierSslPort = 11207;
        private int ioPoolSize = IO_POOL_SIZE;
        private int computationPoolSize = COMPUTATION_POOL_SIZE;
        private int responseBufferSize = 16384;
        private int requestBufferSize = 16384;
        private int dcpConnectionBufferSize = 0x1400000;
        private double dcpConnectionBufferAckThreshold = 0.2;
        private String dcpConnectionName = "dcp/core-io";
        private int kvEndpoints = 1;
        private int viewEndpoints = 12;
        private int queryEndpoints = 12;
        private int searchEndpoints = 12;
        private Delay observeIntervalDelay = OBSERVE_INTERVAL_DELAY;
        private Delay reconnectDelay = RECONNECT_DELAY;
        private Delay retryDelay = RETRY_DELAY;
        private RetryStrategy retryStrategy = RETRY_STRATEGY;
        private EventLoopGroup ioPool;
        private EventLoopGroup kvIoPool;
        private EventLoopGroup viewIoPool;
        private EventLoopGroup queryIoPool;
        private EventLoopGroup searchIoPool;
        private ShutdownHook ioPoolShutdownHook;
        private ShutdownHook kvIoPoolShutdownHook;
        private ShutdownHook viewIoPoolShutdownHook;
        private ShutdownHook queryIoPoolShutdownHook;
        private ShutdownHook searchIoPoolShutdownHook;
        private Scheduler scheduler;
        private ShutdownHook schedulerShutdownHook;
        private EventBus eventBus;
        private long maxRequestLifetime = MAX_REQUEST_LIFETIME;
        private long keepAliveInterval = KEEPALIVEINTERVAL;
        private long autoreleaseAfter = AUTORELEASE_AFTER;
        private boolean bufferPoolingEnabled = true;
        private boolean tcpNodelayEnabled = true;
        private boolean mutationTokensEnabled = false;
        private int socketConnectTimeout = 1000;
        private boolean callbacksOnIoPool = false;
        private long disconnectTimeout = DISCONNECT_TIMEOUT;
        private WaitStrategyFactory requestBufferWaitStrategy;
        private MemcachedHashingStrategy memcachedHashingStrategy = MEMCACHED_HASHING_STRATEGY;
        private MetricsCollectorConfig runtimeMetricsCollectorConfig;
        private LatencyMetricsCollectorConfig networkLatencyMetricsCollectorConfig;
        private LoggingConsumer defaultMetricsLoggingConsumer = LoggingConsumer.create();
        private KeyValueServiceConfig keyValueServiceConfig;
        private QueryServiceConfig queryServiceConfig;
        private ViewServiceConfig viewServiceConfig;
        private SearchServiceConfig searchServiceConfig;

        protected Builder() {
        }

        public Builder dcpEnabled(boolean dcpEnabled) {
            this.dcpEnabled = dcpEnabled;
            return this;
        }

        public Builder sslEnabled(boolean sslEnabled) {
            this.sslEnabled = sslEnabled;
            return this;
        }

        public Builder sslKeystoreFile(String sslKeystoreFile) {
            this.sslKeystoreFile = sslKeystoreFile;
            return this;
        }

        public Builder sslKeystorePassword(String sslKeystorePassword) {
            this.sslKeystorePassword = sslKeystorePassword;
            return this;
        }

        public Builder sslKeystore(KeyStore sslKeystore) {
            this.sslKeystore = sslKeystore;
            return this;
        }

        public Builder bootstrapHttpEnabled(boolean bootstrapHttpEnabled) {
            this.bootstrapHttpEnabled = bootstrapHttpEnabled;
            return this;
        }

        public Builder bootstrapCarrierEnabled(boolean bootstrapCarrierEnabled) {
            this.bootstrapCarrierEnabled = bootstrapCarrierEnabled;
            return this;
        }

        public Builder bootstrapHttpDirectPort(int bootstrapHttpDirectPort) {
            this.bootstrapHttpDirectPort = bootstrapHttpDirectPort;
            return this;
        }

        public Builder bootstrapHttpSslPort(int bootstrapHttpSslPort) {
            this.bootstrapHttpSslPort = bootstrapHttpSslPort;
            return this;
        }

        public Builder bootstrapCarrierDirectPort(int bootstrapCarrierDirectPort) {
            this.bootstrapCarrierDirectPort = bootstrapCarrierDirectPort;
            return this;
        }

        public Builder bootstrapCarrierSslPort(int bootstrapCarrierSslPort) {
            this.bootstrapCarrierSslPort = bootstrapCarrierSslPort;
            return this;
        }

        public Builder ioPoolSize(int ioPoolSize) {
            this.ioPoolSize = ioPoolSize;
            return this;
        }

        public Builder computationPoolSize(int computationPoolSize) {
            this.computationPoolSize = computationPoolSize;
            return this;
        }

        public Builder requestBufferSize(int requestBufferSize) {
            this.requestBufferSize = requestBufferSize;
            return this;
        }

        public Builder responseBufferSize(int responseBufferSize) {
            this.responseBufferSize = responseBufferSize;
            return this;
        }

        public Builder dcpConnectionBufferSize(int dcpConnectionBufferSize) {
            this.dcpConnectionBufferSize = dcpConnectionBufferSize;
            return this;
        }

        public Builder dcpConnectionBufferAckThreshold(double dcpConnectionBufferAckThreshold) {
            this.dcpConnectionBufferAckThreshold = dcpConnectionBufferAckThreshold;
            return this;
        }

        @InterfaceStability.Experimental
        @InterfaceAudience.Public
        public Builder dcpConnectionName(String dcpConnectionName) {
            this.dcpConnectionName = dcpConnectionName;
            return this;
        }

        public Builder kvEndpoints(int kvEndpoints) {
            this.kvEndpoints = kvEndpoints;
            return this;
        }

        public Builder viewEndpoints(int viewEndpoints) {
            this.viewEndpoints = viewEndpoints;
            return this;
        }

        public Builder queryEndpoints(int queryEndpoints) {
            this.queryEndpoints = queryEndpoints;
            return this;
        }

        public Builder searchEndpoints(int searchEndpoints) {
            this.searchEndpoints = searchEndpoints;
            return this;
        }

        public Builder userAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public Builder packageNameAndVersion(String packageNameAndVersion) {
            this.packageNameAndVersion = packageNameAndVersion;
            return this;
        }

        public Builder observeIntervalDelay(Delay observeIntervalDelay) {
            this.observeIntervalDelay = observeIntervalDelay;
            return this;
        }

        public Builder reconnectDelay(Delay reconnectDelay) {
            this.reconnectDelay = reconnectDelay;
            return this;
        }

        public Builder retryDelay(Delay retryDelay) {
            this.retryDelay = retryDelay;
            return this;
        }

        @Deprecated
        public Builder ioPool(EventLoopGroup group) {
            return this.ioPool(group, new NoOpShutdownHook());
        }

        public Builder ioPool(EventLoopGroup group, ShutdownHook shutdownHook) {
            this.ioPool = group;
            this.ioPoolShutdownHook = shutdownHook;
            return this;
        }

        public Builder kvIoPool(EventLoopGroup group, ShutdownHook shutdownHook) {
            this.kvIoPool = group;
            this.kvIoPoolShutdownHook = shutdownHook;
            return this;
        }

        public Builder viewIoPool(EventLoopGroup group, ShutdownHook shutdownHook) {
            this.viewIoPool = group;
            this.viewIoPoolShutdownHook = shutdownHook;
            return this;
        }

        public Builder queryIoPool(EventLoopGroup group, ShutdownHook shutdownHook) {
            this.queryIoPool = group;
            this.queryIoPoolShutdownHook = shutdownHook;
            return this;
        }

        public Builder searchIoPool(EventLoopGroup group, ShutdownHook shutdownHook) {
            this.searchIoPool = group;
            this.searchIoPoolShutdownHook = shutdownHook;
            return this;
        }

        @Deprecated
        public Builder scheduler(Scheduler scheduler) {
            return this.scheduler(scheduler, new NoOpShutdownHook());
        }

        public Builder scheduler(Scheduler scheduler, ShutdownHook shutdownHook) {
            this.scheduler = scheduler;
            this.schedulerShutdownHook = shutdownHook;
            return this;
        }

        public Builder retryStrategy(RetryStrategy retryStrategy) {
            this.retryStrategy = retryStrategy;
            return this;
        }

        public Builder maxRequestLifetime(long maxRequestLifetime) {
            this.maxRequestLifetime = maxRequestLifetime;
            return this;
        }

        public Builder keepAliveInterval(long keepAliveIntervalMilliseconds) {
            this.keepAliveInterval = keepAliveIntervalMilliseconds;
            return this;
        }

        public Builder autoreleaseAfter(long autoreleaseAfter) {
            this.autoreleaseAfter = autoreleaseAfter;
            return this;
        }

        public Builder eventBus(EventBus eventBus) {
            this.eventBus = eventBus;
            return this;
        }

        public Builder bufferPoolingEnabled(boolean bufferPoolingEnabled) {
            this.bufferPoolingEnabled = bufferPoolingEnabled;
            return this;
        }

        public Builder tcpNodelayEnabled(boolean tcpNodelayEnabled) {
            this.tcpNodelayEnabled = tcpNodelayEnabled;
            return this;
        }

        public Builder mutationTokensEnabled(boolean mutationTokensEnabled) {
            this.mutationTokensEnabled = mutationTokensEnabled;
            return this;
        }

        public Builder runtimeMetricsCollectorConfig(MetricsCollectorConfig metricsCollectorConfig) {
            this.runtimeMetricsCollectorConfig = metricsCollectorConfig;
            return this;
        }

        public Builder networkLatencyMetricsCollectorConfig(LatencyMetricsCollectorConfig metricsCollectorConfig) {
            this.networkLatencyMetricsCollectorConfig = metricsCollectorConfig;
            return this;
        }

        public Builder defaultMetricsLoggingConsumer(boolean enabled, CouchbaseLogLevel level, LoggingConsumer.OutputFormat format) {
            this.defaultMetricsLoggingConsumer = enabled ? LoggingConsumer.create(level, format) : null;
            return this;
        }

        public Builder defaultMetricsLoggingConsumer(boolean enabled, CouchbaseLogLevel level) {
            return this.defaultMetricsLoggingConsumer(enabled, level, LoggingConsumer.DEFAULT_FORMAT);
        }

        public Builder socketConnectTimeout(int socketConnectTimeout) {
            this.socketConnectTimeout = socketConnectTimeout;
            return this;
        }

        public Builder callbacksOnIoPool(boolean callbacksOnIoPool) {
            this.callbacksOnIoPool = callbacksOnIoPool;
            return this;
        }

        public Builder disconnectTimeout(long disconnectTimeout) {
            this.disconnectTimeout = disconnectTimeout;
            return this;
        }

        @InterfaceStability.Experimental
        @InterfaceAudience.Public
        public Builder requestBufferWaitStrategy(WaitStrategyFactory waitStrategy) {
            this.requestBufferWaitStrategy = waitStrategy;
            return this;
        }

        public Builder memcachedHashingStrategy(MemcachedHashingStrategy memcachedHashingStrategy) {
            this.memcachedHashingStrategy = memcachedHashingStrategy;
            return this;
        }

        public Builder keyValueServiceConfig(KeyValueServiceConfig keyValueServiceConfig) {
            this.keyValueServiceConfig = keyValueServiceConfig;
            return this;
        }

        public Builder viewServiceConfig(ViewServiceConfig viewServiceConfig) {
            this.viewServiceConfig = viewServiceConfig;
            return this;
        }

        public Builder queryServiceConfig(QueryServiceConfig queryServiceConfig) {
            this.queryServiceConfig = queryServiceConfig;
            return this;
        }

        public Builder searchServiceConfig(SearchServiceConfig searchServiceConfig) {
            this.searchServiceConfig = searchServiceConfig;
            return this;
        }

        public DefaultCoreEnvironment build() {
            return new DefaultCoreEnvironment(this);
        }
    }
}

