/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.gui.Plot;
import ij.gui.ProfilePlot;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.measure.Measurements;
import ij.plugin.filter.Analyzer;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.util.Tools;
import java.awt.Rectangle;

public class ZAxisProfiler
implements PlugInFilter,
Measurements {
    private static String[] choices = new String[]{"time", "z-axis"};
    private static String choice = choices[0];
    private boolean showingDialog;
    private ImagePlus imp;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return 159;
    }

    public void run(ImageProcessor ip) {
        String title;
        if (this.imp.getStackSize() < 2) {
            IJ.error("ZAxisProfiler", "This command requires a stack.");
            return;
        }
        Roi roi = this.imp.getRoi();
        if (roi != null && roi.isLine()) {
            IJ.error("ZAxisProfiler", "This command does not work with line selections.");
            return;
        }
        double minThreshold = ip.getMinThreshold();
        double maxThreshold = ip.getMaxThreshold();
        float[] y = this.imp.isHyperStack() ? this.getHyperstackProfile(roi, minThreshold, maxThreshold) : this.getZAxisProfile(roi, minThreshold, maxThreshold);
        if (y == null) {
            return;
        }
        float[] x = new float[y.length];
        for (int i = 0; i < x.length; ++i) {
            x[i] = i + 1;
        }
        if (roi != null) {
            Rectangle r = this.imp.getRoi().getBounds();
            title = this.imp.getTitle() + "-" + r.x + "-" + r.y;
        } else {
            title = this.imp.getTitle() + "-0-0";
        }
        String xAxisLabel = this.showingDialog && choice.equals(choices[0]) ? "Frame" : "Slice";
        Plot plot = new Plot(title, xAxisLabel, "Mean", x, y);
        double ymin = ProfilePlot.getFixedMin();
        double ymax = ProfilePlot.getFixedMax();
        if (ymin != 0.0 || ymax != 0.0) {
            double[] a = Tools.getMinMax(x);
            double xmin = a[0];
            double xmax = a[1];
            plot.setLimits(xmin, xmax, ymin, ymax);
        }
        plot.show();
    }

    float[] getHyperstackProfile(Roi roi, double minThreshold, double maxThreshold) {
        boolean timeProfile;
        int channels = this.imp.getNChannels();
        int slices = this.imp.getNSlices();
        int frames = this.imp.getNFrames();
        int c = this.imp.getC();
        int z = this.imp.getZ();
        int t = this.imp.getT();
        int size = slices;
        boolean bl = timeProfile = slices == 1 && frames > 1;
        if (slices > 1 && frames > 1) {
            this.showingDialog = true;
            GenericDialog gd = new GenericDialog("Profiler");
            gd.addChoice("Profile", choices, choice);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return null;
            }
            choice = gd.getNextChoice();
            timeProfile = choice.equals(choices[0]);
        }
        size = timeProfile ? frames : slices;
        float[] values = new float[size];
        Analyzer analyzer = new Analyzer(this.imp);
        int measurements = analyzer.getMeasurements();
        boolean showResults = measurements != 0 && measurements != 256;
        measurements |= 2;
        if (showResults) {
            if (!analyzer.resetCounter()) {
                return null;
            }
        }
        for (int i = 1; i <= size; ++i) {
            if (timeProfile) {
                this.imp.setPositionWithoutUpdate(c, z, i);
            } else {
                this.imp.setPositionWithoutUpdate(c, i, t);
            }
            ImageStatistics stats = this.imp.getStatistics(measurements);
            analyzer.saveResults(stats, roi);
            if (showResults) {
                analyzer.displayResults();
            }
            values[i - 1] = (float)stats.mean;
        }
        this.imp.setPositionWithoutUpdate(c, z, t);
        return values;
    }

    float[] getZAxisProfile(Roi roi, double minThreshold, double maxThreshold) {
        ImageStack stack = this.imp.getStack();
        int size = stack.getSize();
        float[] values = new float[size];
        Calibration cal = this.imp.getCalibration();
        Analyzer analyzer = new Analyzer(this.imp);
        int measurements = analyzer.getMeasurements();
        boolean showResults = measurements != 0 && measurements != 256;
        boolean showingLabels = (measurements & 0x400) != 0 || (measurements & 0x100000) != 0;
        measurements |= 2;
        if (showResults) {
            if (!analyzer.resetCounter()) {
                return null;
            }
        }
        int current = this.imp.getCurrentSlice();
        for (int i = 1; i <= size; ++i) {
            if (showingLabels) {
                this.imp.setSlice(i);
            }
            ImageProcessor ip = stack.getProcessor(i);
            if (minThreshold != -808080.0) {
                ip.setThreshold(minThreshold, maxThreshold, 2);
            }
            ip.setRoi(roi);
            ImageStatistics stats = ImageStatistics.getStatistics(ip, measurements, cal);
            analyzer.saveResults(stats, roi);
            if (showResults) {
                analyzer.displayResults();
            }
            values[i - 1] = (float)stats.mean;
        }
        if (showingLabels) {
            this.imp.setSlice(current);
        }
        return values;
    }
}

