/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.kernel;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.jackrabbit.oak.commons.json.JsopTokenizer;

class JsonFilter {
    private static final Pattern EVERYTHING = Pattern.compile(".*");
    private final List<Pattern> nodeIncludes = Lists.newArrayList(EVERYTHING);
    private final List<Pattern> nodeExcludes = Lists.newArrayList();
    private final List<Pattern> propertyIncludes = Lists.newArrayList(EVERYTHING);
    private final List<Pattern> propertyExcludes = Lists.newArrayList();

    JsonFilter(String filter) {
        JsopTokenizer tokenizer = new JsopTokenizer(filter);
        tokenizer.read(123);
        boolean first = true;
        while (!tokenizer.matches(125)) {
            if (!first) {
                tokenizer.read(44);
            }
            String key = tokenizer.readString();
            tokenizer.read(58);
            ArrayList<Pattern> includes = Lists.newArrayList();
            ArrayList<Pattern> excludes = Lists.newArrayList();
            this.readPatterns(tokenizer, includes, excludes);
            if (key.equals("nodes")) {
                this.nodeIncludes.clear();
                this.nodeIncludes.addAll(includes);
                this.nodeExcludes.clear();
                this.nodeExcludes.addAll(excludes);
            } else if (key.equals("properties")) {
                this.propertyIncludes.clear();
                this.propertyIncludes.addAll(includes);
                this.propertyExcludes.clear();
                this.propertyExcludes.addAll(excludes);
            } else {
                throw new IllegalStateException(key);
            }
            first = false;
        }
    }

    private void readPatterns(JsopTokenizer tokenizer, List<Pattern> includes, List<Pattern> excludes) {
        tokenizer.read(91);
        boolean first = true;
        while (!tokenizer.matches(93)) {
            String pattern;
            if (!first) {
                tokenizer.read(44);
            }
            if ((pattern = tokenizer.readString()).startsWith("-")) {
                excludes.add(JsonFilter.glob(pattern.substring(1)));
            } else if (pattern.startsWith("\\-")) {
                includes.add(JsonFilter.glob(pattern.substring(1)));
            } else {
                includes.add(JsonFilter.glob(pattern));
            }
            first = false;
        }
    }

    private static Pattern glob(String pattern) {
        StringBuilder builder = new StringBuilder();
        int star = pattern.indexOf(42);
        while (star != -1) {
            if (star > 0 && pattern.charAt(star - 1) == '\\') {
                builder.append(Pattern.quote(pattern.substring(0, star - 1)));
                builder.append(Pattern.quote("*"));
            } else {
                builder.append(Pattern.quote(pattern.substring(0, star)));
                builder.append(".*");
            }
            pattern = pattern.substring(star + 1);
            star = pattern.indexOf(42);
        }
        builder.append(Pattern.quote(pattern));
        return Pattern.compile(builder.toString());
    }

    boolean includeNode(String name) {
        return this.include(name, this.nodeIncludes, this.nodeExcludes);
    }

    boolean includeProperty(String name) {
        return this.include(name, this.propertyIncludes, this.propertyExcludes);
    }

    private boolean include(String name, List<Pattern> includes, List<Pattern> excludes) {
        for (Pattern include : includes) {
            if (!include.matcher(name).matches()) continue;
            for (Pattern exclude : excludes) {
                if (!exclude.matcher(name).matches()) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

