/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.mk.api.MicroKernelException;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.json.JsopStream;
import org.apache.jackrabbit.oak.commons.json.JsopWriter;
import org.apache.jackrabbit.oak.plugins.document.Branch;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.Collision;
import org.apache.jackrabbit.oak.plugins.document.CollisionHandler;
import org.apache.jackrabbit.oak.plugins.document.DiffCache;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeState;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Commit {
    private static final Logger LOG = LoggerFactory.getLogger(Commit.class);
    private final DocumentNodeStore nodeStore;
    private final Revision baseRevision;
    private final Revision revision;
    private HashMap<String, UpdateOp> operations = new LinkedHashMap<String, UpdateOp>();
    private JsopWriter diff = new JsopStream();
    private Set<Revision> collisions = new LinkedHashSet<Revision>();
    private HashSet<String> modifiedNodes = new HashSet();
    private HashSet<String> addedNodes = new HashSet();
    private HashSet<String> removedNodes = new HashSet();
    private HashSet<String> nodesWithBinaries = Sets.newHashSet();

    Commit(DocumentNodeStore nodeStore, Revision baseRevision, Revision revision) {
        this.baseRevision = baseRevision;
        this.revision = revision;
        this.nodeStore = nodeStore;
    }

    UpdateOp getUpdateOperationForNode(String path) {
        UpdateOp op = this.operations.get(path);
        if (op == null) {
            String id = Utils.getIdFromPath(path);
            op = new UpdateOp(id, false);
            NodeDocument.setModified(op, this.revision);
            this.operations.put(path, op);
        }
        return op;
    }

    public static long getModifiedInSecs(long timestamp) {
        long timeInSec = TimeUnit.MILLISECONDS.toSeconds(timestamp);
        return timeInSec - timeInSec % 5L;
    }

    @Nonnull
    Revision getRevision() {
        return this.revision;
    }

    @CheckForNull
    Revision getBaseRevision() {
        return this.baseRevision;
    }

    void addNodeDiff(DocumentNodeState n) {
        this.diff.tag('+').key(n.getPath());
        this.diff.object();
        n.append(this.diff, false);
        this.diff.endObject();
        this.diff.newline();
    }

    void updateProperty(String path, String propertyName, String value) {
        UpdateOp op = this.getUpdateOperationForNode(path);
        String key = Utils.escapePropertyName(propertyName);
        op.setMapEntry(key, this.revision, value);
    }

    void markNodeHavingBinary(String path) {
        this.nodesWithBinaries.add(path);
    }

    void addNode(DocumentNodeState n) {
        String path = n.getPath();
        if (this.operations.containsKey(path)) {
            String msg = "Node already added: " + path;
            LOG.error(msg);
            throw new MicroKernelException(msg);
        }
        this.operations.put(path, n.asOperation(true));
        this.addedNodes.add(path);
    }

    boolean isEmpty() {
        return this.operations.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    Revision apply() throws MicroKernelException {
        boolean success = false;
        Revision baseRev = this.getBaseRevision();
        boolean isBranch = baseRev != null && baseRev.isBranch();
        Revision rev = this.getRevision();
        if (isBranch && !this.nodeStore.isDisableBranches()) {
            rev = rev.asBranchRevision();
            Branch b = this.nodeStore.getBranches().getBranch(baseRev);
            if (b == null) {
                b = this.nodeStore.getBranches().create(baseRev.asTrunkRevision(), rev);
            } else {
                b.addCommit(rev);
            }
            try {
                this.prepare(baseRev);
                success = true;
            }
            finally {
                if (!success) {
                    b.removeCommit(rev);
                    if (!b.hasCommits()) {
                        this.nodeStore.getBranches().remove(b);
                    }
                }
            }
        } else {
            this.applyInternal();
        }
        if (isBranch) {
            rev = rev.asBranchRevision();
        }
        return rev;
    }

    private void applyInternal() {
        if (!this.operations.isEmpty()) {
            this.updateParentChildStatus();
            this.updateBinaryStatus();
            this.applyToDocumentStore();
        }
    }

    private void prepare(Revision baseRevision) {
        if (!this.operations.isEmpty()) {
            this.updateParentChildStatus();
            this.updateBinaryStatus();
            this.applyToDocumentStore(baseRevision);
        }
    }

    private void updateBinaryStatus() {
        DocumentStore store = this.nodeStore.getDocumentStore();
        for (String path : this.nodesWithBinaries) {
            NodeDocument nd = store.getIfCached(Collection.NODES, Utils.getIdFromPath(path));
            if (nd != null && nd.hasBinary()) continue;
            UpdateOp updateParentOp = this.getUpdateOperationForNode(path);
            NodeDocument.setHasBinary(updateParentOp);
        }
    }

    void applyToDocumentStore() {
        this.applyToDocumentStore(null);
    }

    private void applyToDocumentStore(Revision baseBranchRevision) {
        String commitValue = baseBranchRevision != null ? baseBranchRevision.toString() : "c";
        DocumentStore store = this.nodeStore.getDocumentStore();
        String commitRootPath = null;
        if (baseBranchRevision != null) {
            commitRootPath = "/";
        }
        ArrayList<UpdateOp> newNodes = new ArrayList<UpdateOp>();
        ArrayList<UpdateOp> changedNodes = new ArrayList<UpdateOp>();
        ArrayList<UpdateOp> opLog = new ArrayList<UpdateOp>();
        for (String p : this.operations.keySet()) {
            this.markChanged(p);
            if (commitRootPath == null) {
                commitRootPath = p;
                continue;
            }
            while (!PathUtils.isAncestor(commitRootPath, p) && !PathUtils.denotesRoot(commitRootPath = PathUtils.getParentPath(commitRootPath))) {
            }
        }
        int commitRootDepth = PathUtils.getDepth(commitRootPath);
        boolean commitRootHasChanges = this.operations.containsKey(commitRootPath);
        UpdateOp commitRoot = this.getUpdateOperationForNode(commitRootPath);
        for (String p : this.operations.keySet()) {
            UpdateOp op = this.operations.get(p);
            if (op.isNew()) {
                NodeDocument.setDeleted(op, this.revision, false);
            }
            if (op == commitRoot) {
                if (op.isNew() || !commitRootHasChanges) continue;
                changedNodes.add(op);
                continue;
            }
            NodeDocument.setCommitRoot(op, this.revision, commitRootDepth);
            if (op.isNew()) {
                if (baseBranchRevision == null) {
                    NodeDocument.setLastRev(op, this.revision);
                }
                newNodes.add(op);
                continue;
            }
            changedNodes.add(op);
        }
        if (changedNodes.size() == 0 && commitRoot.isNew()) {
            NodeDocument.setRevision(commitRoot, this.revision, commitValue);
            newNodes.add(commitRoot);
        }
        try {
            if (newNodes.size() > 0 && !store.create(Collection.NODES, newNodes)) {
                for (UpdateOp op : newNodes) {
                    if (op == commitRoot) {
                        NodeDocument.unsetRevision(commitRoot, this.revision);
                    }
                    NodeDocument.unsetLastRev(op, this.revision.getClusterId());
                    changedNodes.add(op);
                }
                newNodes.clear();
            }
            for (UpdateOp op : changedNodes) {
                NodeDocument.setCommitRoot(op, this.revision, commitRootDepth);
                opLog.add(op);
                this.createOrUpdateNode(store, op);
            }
            if (changedNodes.size() > 0 || !commitRoot.isNew()) {
                NodeDocument.setRevision(commitRoot, this.revision, commitValue);
                if (commitRootHasChanges) {
                    NodeDocument.removeCommitRoot(commitRoot, this.revision);
                }
                opLog.add(commitRoot);
                if (baseBranchRevision == null) {
                    UpdateOp commit = commitRoot.shallowCopy(commitRoot.getId());
                    commit.setNew(false);
                    commit.containsMapEntry("_collisions", this.revision, false);
                    NodeDocument before = this.nodeStore.updateCommitRoot(commit);
                    if (before == null) {
                        String msg = "Conflicting concurrent change. Update operation failed: " + commitRoot;
                        throw new MicroKernelException(msg);
                    }
                    this.checkConflicts(commitRoot, before);
                    this.checkSplitCandidate(before);
                } else {
                    this.createOrUpdateNode(store, commitRoot);
                }
                this.operations.put(commitRootPath, commitRoot);
            }
        }
        catch (MicroKernelException e) {
            this.rollback(newNodes, opLog, commitRoot);
            throw e;
        }
    }

    private void updateParentChildStatus() {
        DocumentStore store = this.nodeStore.getDocumentStore();
        HashSet<String> processedParents = Sets.newHashSet();
        for (String path : this.addedNodes) {
            NodeDocument nd;
            String parentPath;
            if (PathUtils.denotesRoot(path) || processedParents.contains(parentPath = PathUtils.getParentPath(path))) continue;
            processedParents.add(parentPath);
            UpdateOp op = this.operations.get(parentPath);
            if (op != null) {
                if (op.isNew()) {
                    NodeDocument.setChildrenFlag(op, true);
                    continue;
                }
                nd = store.getIfCached(Collection.NODES, Utils.getIdFromPath(parentPath));
                if (nd != null && nd.hasChildren()) continue;
                NodeDocument.setChildrenFlag(op, true);
                continue;
            }
            nd = store.getIfCached(Collection.NODES, Utils.getIdFromPath(parentPath));
            if (nd != null && nd.hasChildren()) continue;
            UpdateOp updateParentOp = this.getUpdateOperationForNode(parentPath);
            NodeDocument.setChildrenFlag(updateParentOp, true);
        }
    }

    private void rollback(List<UpdateOp> newDocuments, List<UpdateOp> changed, UpdateOp commitRoot) {
        UpdateOp reverse;
        DocumentStore store = this.nodeStore.getDocumentStore();
        for (UpdateOp op : changed) {
            reverse = op.getReverseOperation();
            store.findAndUpdate(Collection.NODES, reverse);
        }
        for (UpdateOp op : newDocuments) {
            reverse = op.getReverseOperation();
            NodeDocument.unsetLastRev(reverse, this.revision.getClusterId());
            store.findAndUpdate(Collection.NODES, reverse);
        }
        UpdateOp removeCollision = new UpdateOp(commitRoot.getId(), false);
        NodeDocument.removeCollision(removeCollision, this.revision);
        store.findAndUpdate(Collection.NODES, removeCollision);
    }

    private void createOrUpdateNode(DocumentStore store, UpdateOp op) {
        NodeDocument doc = store.createOrUpdate(Collection.NODES, op);
        this.checkConflicts(op, doc);
        this.checkSplitCandidate(doc);
    }

    private void checkSplitCandidate(@Nullable NodeDocument doc) {
        if (doc != null && doc.getMemory() > 8192) {
            this.nodeStore.addSplitCandidate(doc.getId());
        }
    }

    private void checkConflicts(@Nonnull UpdateOp op, @Nullable NodeDocument before) {
        DocumentStore store = this.nodeStore.getDocumentStore();
        this.collisions.clear();
        if (this.baseRevision != null) {
            Revision newestRev = null;
            if (before != null) {
                newestRev = before.getNewestRevision(this.nodeStore, this.revision, new CollisionHandler(){

                    @Override
                    void concurrentModification(Revision other) {
                        Commit.this.collisions.add(other);
                    }
                });
            }
            String conflictMessage = null;
            if (newestRev == null) {
                if (op.isDelete() || !op.isNew()) {
                    conflictMessage = "The node " + op.getId() + " does not exist or is already deleted";
                }
            } else if (op.isNew()) {
                conflictMessage = "The node " + op.getId() + " was already added in revision\n" + newestRev;
            } else if (this.nodeStore.isRevisionNewer(newestRev, this.baseRevision) && (op.isDelete() || this.isConflicting(before, op))) {
                conflictMessage = "The node " + op.getId() + " was changed in revision\n" + newestRev + ", which was applied after the base revision\n" + this.baseRevision;
            }
            if (conflictMessage == null && !this.collisions.isEmpty() && this.isConflicting(before, op)) {
                for (Revision r : this.collisions) {
                    Collision c = new Collision(before, r, op, this.revision, this.nodeStore);
                    if (!c.mark(store).equals(this.revision) || this.baseRevision.isBranch()) continue;
                    conflictMessage = "The node " + op.getId() + " was changed in revision\n" + r + ", which was applied after the base revision\n" + this.baseRevision;
                }
            }
            if (conflictMessage != null) {
                conflictMessage = conflictMessage + ", before\n" + this.revision + "; document:\n" + (before == null ? "" : before.format()) + ",\nrevision order:\n" + this.nodeStore.getRevisionComparator();
                throw new MicroKernelException(conflictMessage);
            }
        }
    }

    private boolean isConflicting(@Nullable NodeDocument doc, @Nonnull UpdateOp op) {
        if (this.baseRevision == null || doc == null) {
            return false;
        }
        return doc.isConflicting(op, this.baseRevision, this.revision, this.nodeStore);
    }

    public void applyToCache(Revision before, boolean isBranchCommit) {
        HashMap<String, ArrayList<String>> nodesWithChangedChildren = new HashMap<String, ArrayList<String>>();
        for (String p : this.modifiedNodes) {
            if (PathUtils.denotesRoot(p)) continue;
            String parent = PathUtils.getParentPath(p);
            ArrayList<String> list = (ArrayList<String>)nodesWithChangedChildren.get(parent);
            if (list == null) {
                list = new ArrayList<String>();
                nodesWithChangedChildren.put(parent, list);
            }
            list.add(p);
        }
        DiffCache.Entry cacheEntry = this.nodeStore.getDiffCache().newEntry(before, this.revision);
        ArrayList<String> added = new ArrayList<String>();
        ArrayList<String> removed = new ArrayList<String>();
        ArrayList<String> changed = new ArrayList<String>();
        for (String path : this.modifiedNodes) {
            UpdateOp op;
            added.clear();
            removed.clear();
            changed.clear();
            ArrayList changes = (ArrayList)nodesWithChangedChildren.get(path);
            if (changes != null) {
                for (String s : changes) {
                    if (this.addedNodes.contains(s)) {
                        added.add(s);
                        continue;
                    }
                    if (this.removedNodes.contains(s)) {
                        removed.add(s);
                        continue;
                    }
                    changed.add(s);
                }
            }
            boolean isNew = (op = this.operations.get(path)) != null && op.isNew();
            boolean pendingLastRev = op == null || !NodeDocument.hasLastRev(op, this.revision.getClusterId());
            this.nodeStore.applyChanges(this.revision, path, isNew, pendingLastRev, isBranchCommit, added, removed, changed, cacheEntry);
        }
        cacheEntry.done();
    }

    public void moveNode(String sourcePath, String targetPath) {
        this.diff.tag('>').key(sourcePath).value(targetPath);
    }

    public void copyNode(String sourcePath, String targetPath) {
        this.diff.tag('*').key(sourcePath).value(targetPath);
    }

    private void markChanged(String path) {
        if (!PathUtils.denotesRoot(path) && !PathUtils.isAbsolute(path)) {
            throw new IllegalArgumentException("path: " + path);
        }
        while (this.modifiedNodes.add(path) && !PathUtils.denotesRoot(path)) {
            path = PathUtils.getParentPath(path);
        }
    }

    public void updatePropertyDiff(String path, String propertyName, String value) {
        this.diff.tag('^').key(PathUtils.concat(path, propertyName)).value(value);
    }

    public void removeNodeDiff(String path) {
        this.diff.tag('-').value(path).newline();
    }

    public void removeNode(String path) {
        this.removedNodes.add(path);
        UpdateOp op = this.getUpdateOperationForNode(path);
        op.setDelete(true);
        NodeDocument.setDeleted(op, this.revision, true);
    }
}

