/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.IndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdateCallback;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.spi.commit.CompositeEditor;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.commit.EditorDiff;
import org.apache.jackrabbit.oak.spi.commit.VisibleEditor;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class IndexUpdate
implements Editor {
    private final IndexEditorProvider provider;
    private final String async;
    private final NodeState root;
    private final NodeBuilder builder;
    private final IndexUpdate parent;
    private final String name;
    private String path;
    private final List<Editor> editors = Lists.newArrayList();
    private final Map<String, Editor> reindex = new HashMap<String, Editor>();
    private final IndexUpdateCallback updateCallback;

    public IndexUpdate(IndexEditorProvider provider, String async, NodeState root, NodeBuilder builder, IndexUpdateCallback updateCallback) {
        this.parent = null;
        this.name = null;
        this.path = "/";
        this.provider = Preconditions.checkNotNull(provider);
        this.async = async;
        this.root = Preconditions.checkNotNull(root);
        this.builder = Preconditions.checkNotNull(builder);
        this.updateCallback = Preconditions.checkNotNull(updateCallback);
    }

    private IndexUpdate(IndexUpdate parent, String name) {
        this.parent = Preconditions.checkNotNull(parent);
        this.name = name;
        this.provider = parent.provider;
        this.async = parent.async;
        this.root = parent.root;
        this.builder = parent.builder.child(Preconditions.checkNotNull(name));
        this.updateCallback = parent.updateCallback;
    }

    @Override
    public void enter(NodeState before, NodeState after) throws CommitFailedException {
        this.collectIndexEditors(this.builder.getChildNode("oak:index"));
        CommitFailedException exception = EditorDiff.process(CompositeEditor.compose(this.reindex.values()), EmptyNodeState.MISSING_NODE, after);
        if (exception != null) {
            throw exception;
        }
        for (Editor editor : this.editors) {
            editor.enter(before, after);
        }
    }

    private void collectIndexEditors(NodeBuilder definitions) throws CommitFailedException {
        for (String name : definitions.getChildNodeNames()) {
            NodeBuilder definition = definitions.getChildNode(name);
            if (!Objects.equal(this.async, definition.getString("async"))) continue;
            String type = definition.getString("type");
            Editor editor = this.provider.getIndexEditor(type, definition, this.root, this.updateCallback);
            if (editor == null) {
                definition.setProperty("reindex", true);
                continue;
            }
            if (definition.getBoolean("reindex")) {
                if (definition.getBoolean("reindex-async") && definition.getString("async") == null) {
                    definition.setProperty("async", "async-reindex");
                    continue;
                }
                definition.setProperty("reindex", false);
                for (String rm : definition.getChildNodeNames()) {
                    definition.getChildNode(rm).remove();
                }
                this.reindex.put(PathUtils.concat(this.getPath(), "oak:index", name), VisibleEditor.wrap(editor));
                continue;
            }
            this.editors.add(VisibleEditor.wrap(editor));
        }
    }

    private String getPath() {
        if (this.path == null) {
            this.path = PathUtils.concat(this.parent.getPath(), this.name);
        }
        return this.path;
    }

    @Override
    public void leave(NodeState before, NodeState after) throws CommitFailedException {
        for (Editor editor : this.editors) {
            editor.leave(before, after);
        }
    }

    @Override
    public void propertyAdded(PropertyState after) throws CommitFailedException {
        for (Editor editor : this.editors) {
            editor.propertyAdded(after);
        }
    }

    @Override
    public void propertyChanged(PropertyState before, PropertyState after) throws CommitFailedException {
        for (Editor editor : this.editors) {
            editor.propertyChanged(before, after);
        }
    }

    @Override
    public void propertyDeleted(PropertyState before) throws CommitFailedException {
        for (Editor editor : this.editors) {
            editor.propertyDeleted(before);
        }
    }

    @Override
    @Nonnull
    public Editor childNodeAdded(String name, NodeState after) throws CommitFailedException {
        ArrayList<Editor> children = Lists.newArrayListWithCapacity(1 + this.editors.size());
        children.add(new IndexUpdate(this, name));
        for (Editor editor : this.editors) {
            Editor child = editor.childNodeAdded(name, after);
            if (child == null) continue;
            children.add(child);
        }
        return CompositeEditor.compose(children);
    }

    @Override
    @Nonnull
    public Editor childNodeChanged(String name, NodeState before, NodeState after) throws CommitFailedException {
        ArrayList<Editor> children = Lists.newArrayListWithCapacity(1 + this.editors.size());
        children.add(new IndexUpdate(this, name));
        for (Editor editor : this.editors) {
            Editor child = editor.childNodeChanged(name, before, after);
            if (child == null) continue;
            children.add(child);
        }
        return CompositeEditor.compose(children);
    }

    @Override
    @CheckForNull
    public Editor childNodeDeleted(String name, NodeState before) throws CommitFailedException {
        ArrayList<Editor> children = Lists.newArrayListWithCapacity(this.editors.size());
        for (Editor editor : this.editors) {
            Editor child = editor.childNodeDeleted(name, before);
            if (child == null) continue;
            children.add(child);
        }
        return CompositeEditor.compose(children);
    }

    protected Set<String> getReindexedDefinitions() {
        return this.reindex.keySet();
    }
}

